/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.siterouting.routingprotocols.routingprotocol;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.AddressFamily;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.siterouting.routingprotocols.routingprotocol.Ospf;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.siterouting.routingprotocols.routingprotocol.ospf.ShamLinks;
import org.onosproject.yang.gen.v1.ietfyangtypes.rev20130715.ietfyangtypes.DottedQuad;
import org.onosproject.yang.model.InnerModelObject;

public class DefaultOspf
extends InnerModelObject
implements Ospf {
    protected DottedQuad areaAddress;
    protected int metric;
    protected List<Class<? extends AddressFamily>> addressFamily;
    protected BitSet valueLeafFlags = new BitSet();
    protected ShamLinks shamLinks;

    @Override
    public DottedQuad areaAddress() {
        return this.areaAddress;
    }

    @Override
    public int metric() {
        return this.metric;
    }

    @Override
    public List<Class<? extends AddressFamily>> addressFamily() {
        return this.addressFamily;
    }

    @Override
    public BitSet valueLeafFlags() {
        return this.valueLeafFlags;
    }

    @Override
    public ShamLinks shamLinks() {
        return this.shamLinks;
    }

    @Override
    public void areaAddress(DottedQuad areaAddress) {
        this.valueLeafFlags.set(Ospf.LeafIdentifier.AREAADDRESS.getLeafIndex());
        this.areaAddress = areaAddress;
    }

    @Override
    public void metric(int metric) {
        this.valueLeafFlags.set(Ospf.LeafIdentifier.METRIC.getLeafIndex());
        this.metric = metric;
    }

    @Override
    public void addressFamily(List<Class<? extends AddressFamily>> addressFamily) {
        this.valueLeafFlags.set(Ospf.LeafIdentifier.ADDRESSFAMILY.getLeafIndex());
        this.addressFamily = addressFamily;
    }

    @Override
    public void shamLinks(ShamLinks shamLinks) {
        this.shamLinks = shamLinks;
    }

    @Override
    public void addToAddressFamily(Class<? extends AddressFamily> addTo) {
        if (this.addressFamily == null) {
            this.addressFamily = new ArrayList<Class<? extends AddressFamily>>();
        }
        this.addressFamily.add(addTo);
    }

    public int hashCode() {
        return Objects.hash(this.areaAddress, this.metric, this.addressFamily, this.valueLeafFlags, this.shamLinks);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultOspf) {
            DefaultOspf other = (DefaultOspf)obj;
            return Objects.equals(this.areaAddress, other.areaAddress) && Objects.equals(this.metric, other.metric) && Objects.equals(this.addressFamily, other.addressFamily) && Objects.equals(this.valueLeafFlags, other.valueLeafFlags) && Objects.equals(this.shamLinks, other.shamLinks);
        }
        return false;
    }

    public String toString() {
        return new StringJoiner(", ", this.getClass().getSimpleName() + "{", "}").add("areaAddress=" + this.areaAddress).add("metric=" + this.metric).add("addressFamily=" + this.addressFamily).add("valueLeafFlags=" + this.valueLeafFlags).add("shamLinks=" + this.shamLinks).toString();
    }

    @Override
    public boolean isLeafValueSet(Ospf.LeafIdentifier leaf) {
        return this.valueLeafFlags.get(leaf.getLeafIndex());
    }
}

