/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.customerlocationinfo;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.customerlocationinfo.Location;
import org.onosproject.yang.model.InnerModelObject;

public class DefaultLocation
extends InnerModelObject
implements Location {
    protected String address;
    protected String zipCode;
    protected String state;
    protected String city;
    protected String countryCode;
    protected BitSet valueLeafFlags = new BitSet();

    @Override
    public String address() {
        return this.address;
    }

    @Override
    public String zipCode() {
        return this.zipCode;
    }

    @Override
    public String state() {
        return this.state;
    }

    @Override
    public String city() {
        return this.city;
    }

    @Override
    public String countryCode() {
        return this.countryCode;
    }

    @Override
    public BitSet valueLeafFlags() {
        return this.valueLeafFlags;
    }

    @Override
    public void address(String address) {
        this.valueLeafFlags.set(Location.LeafIdentifier.ADDRESS.getLeafIndex());
        this.address = address;
    }

    @Override
    public void zipCode(String zipCode) {
        this.valueLeafFlags.set(Location.LeafIdentifier.ZIPCODE.getLeafIndex());
        this.zipCode = zipCode;
    }

    @Override
    public void state(String state) {
        this.valueLeafFlags.set(Location.LeafIdentifier.STATE.getLeafIndex());
        this.state = state;
    }

    @Override
    public void city(String city) {
        this.valueLeafFlags.set(Location.LeafIdentifier.CITY.getLeafIndex());
        this.city = city;
    }

    @Override
    public void countryCode(String countryCode) {
        this.valueLeafFlags.set(Location.LeafIdentifier.COUNTRYCODE.getLeafIndex());
        this.countryCode = countryCode;
    }

    public int hashCode() {
        return Objects.hash(this.address, this.zipCode, this.state, this.city, this.countryCode, this.valueLeafFlags);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultLocation) {
            DefaultLocation other = (DefaultLocation)obj;
            return Objects.equals(this.address, other.address) && Objects.equals(this.zipCode, other.zipCode) && Objects.equals(this.state, other.state) && Objects.equals(this.city, other.city) && Objects.equals(this.countryCode, other.countryCode) && Objects.equals(this.valueLeafFlags, other.valueLeafFlags);
        }
        return false;
    }

    public String toString() {
        return new StringJoiner(", ", this.getClass().getSimpleName() + "{", "}").add("address=" + this.address).add("zipCode=" + this.zipCode).add("state=" + this.state).add("city=" + this.city).add("countryCode=" + this.countryCode).add("valueLeafFlags=" + this.valueLeafFlags).toString();
    }

    @Override
    public boolean isLeafValueSet(Location.LeafIdentifier leaf) {
        return this.valueLeafFlags.get(leaf.getLeafIndex());
    }
}

