/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.gen.v1.ietfip.rev20140616.ietfip.devices.device.interfaces.yangautoprefixinterface.augmentedifinterface;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.ietfip.rev20140616.ietfip.devices.device.interfaces.yangautoprefixinterface.augmentedifinterface.Ipv6;
import org.onosproject.yang.gen.v1.ietfip.rev20140616.ietfip.devices.device.interfaces.yangautoprefixinterface.augmentedifinterface.ipv6.Address;
import org.onosproject.yang.gen.v1.ietfip.rev20140616.ietfip.devices.device.interfaces.yangautoprefixinterface.augmentedifinterface.ipv6.Autoconf;
import org.onosproject.yang.gen.v1.ietfip.rev20140616.ietfip.devices.device.interfaces.yangautoprefixinterface.augmentedifinterface.ipv6.Neighbor;
import org.onosproject.yang.model.InnerModelObject;

public class DefaultIpv6
extends InnerModelObject
implements Ipv6 {
    protected boolean enabled;
    protected boolean forwarding;
    protected long mtu;
    protected long dupAddrDetectTransmits;
    protected BitSet valueLeafFlags = new BitSet();
    protected List<Address> address;
    protected List<Neighbor> neighbor;
    protected Autoconf autoconf;

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public boolean forwarding() {
        return this.forwarding;
    }

    @Override
    public long mtu() {
        return this.mtu;
    }

    @Override
    public long dupAddrDetectTransmits() {
        return this.dupAddrDetectTransmits;
    }

    @Override
    public BitSet valueLeafFlags() {
        return this.valueLeafFlags;
    }

    @Override
    public List<Address> address() {
        return this.address;
    }

    @Override
    public List<Neighbor> neighbor() {
        return this.neighbor;
    }

    @Override
    public Autoconf autoconf() {
        return this.autoconf;
    }

    @Override
    public void enabled(boolean enabled) {
        this.valueLeafFlags.set(Ipv6.LeafIdentifier.ENABLED.getLeafIndex());
        this.enabled = enabled;
    }

    @Override
    public void forwarding(boolean forwarding) {
        this.valueLeafFlags.set(Ipv6.LeafIdentifier.FORWARDING.getLeafIndex());
        this.forwarding = forwarding;
    }

    @Override
    public void mtu(long mtu) {
        this.valueLeafFlags.set(Ipv6.LeafIdentifier.MTU.getLeafIndex());
        this.mtu = mtu;
    }

    @Override
    public void dupAddrDetectTransmits(long dupAddrDetectTransmits) {
        this.valueLeafFlags.set(Ipv6.LeafIdentifier.DUPADDRDETECTTRANSMITS.getLeafIndex());
        this.dupAddrDetectTransmits = dupAddrDetectTransmits;
    }

    @Override
    public void address(List<Address> address) {
        this.address = address;
    }

    @Override
    public void neighbor(List<Neighbor> neighbor) {
        this.neighbor = neighbor;
    }

    @Override
    public void autoconf(Autoconf autoconf) {
        this.autoconf = autoconf;
    }

    @Override
    public void addToAddress(Address addTo) {
        if (this.address == null) {
            this.address = new ArrayList<Address>();
        }
        this.address.add(addTo);
    }

    @Override
    public void addToNeighbor(Neighbor addTo) {
        if (this.neighbor == null) {
            this.neighbor = new ArrayList<Neighbor>();
        }
        this.neighbor.add(addTo);
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.forwarding, this.mtu, this.dupAddrDetectTransmits, this.valueLeafFlags, this.address, this.neighbor, this.autoconf);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultIpv6) {
            DefaultIpv6 other = (DefaultIpv6)obj;
            return Objects.equals(this.enabled, other.enabled) && Objects.equals(this.forwarding, other.forwarding) && Objects.equals(this.mtu, other.mtu) && Objects.equals(this.dupAddrDetectTransmits, other.dupAddrDetectTransmits) && Objects.equals(this.valueLeafFlags, other.valueLeafFlags) && Objects.equals(this.address, other.address) && Objects.equals(this.neighbor, other.neighbor) && Objects.equals(this.autoconf, other.autoconf);
        }
        return false;
    }

    public String toString() {
        return new StringJoiner(", ", this.getClass().getSimpleName() + "{", "}").add("enabled=" + this.enabled).add("forwarding=" + this.forwarding).add("mtu=" + this.mtu).add("dupAddrDetectTransmits=" + this.dupAddrDetectTransmits).add("valueLeafFlags=" + this.valueLeafFlags).add("address=" + this.address).add("neighbor=" + this.neighbor).add("autoconf=" + this.autoconf).toString();
    }

    @Override
    public boolean isLeafValueSet(Ipv6.LeafIdentifier leaf) {
        return this.valueLeafFlags.get(leaf.getLeafIndex());
    }
}

