/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.gen.v1.ietfip.rev20140616.ietfip.devices.device.interfaces.yangautoprefixinterface.augmentedifinterface;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.ietfip.rev20140616.ietfip.devices.device.interfaces.yangautoprefixinterface.augmentedifinterface.Ipv4;
import org.onosproject.yang.gen.v1.ietfip.rev20140616.ietfip.devices.device.interfaces.yangautoprefixinterface.augmentedifinterface.ipv4.Address;
import org.onosproject.yang.gen.v1.ietfip.rev20140616.ietfip.devices.device.interfaces.yangautoprefixinterface.augmentedifinterface.ipv4.Neighbor;
import org.onosproject.yang.model.InnerModelObject;

public class DefaultIpv4
extends InnerModelObject
implements Ipv4 {
    protected boolean enabled;
    protected boolean forwarding;
    protected int mtu;
    protected BitSet valueLeafFlags = new BitSet();
    protected List<Address> address;
    protected List<Neighbor> neighbor;

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public boolean forwarding() {
        return this.forwarding;
    }

    @Override
    public int mtu() {
        return this.mtu;
    }

    @Override
    public BitSet valueLeafFlags() {
        return this.valueLeafFlags;
    }

    @Override
    public List<Address> address() {
        return this.address;
    }

    @Override
    public List<Neighbor> neighbor() {
        return this.neighbor;
    }

    @Override
    public void enabled(boolean enabled) {
        this.valueLeafFlags.set(Ipv4.LeafIdentifier.ENABLED.getLeafIndex());
        this.enabled = enabled;
    }

    @Override
    public void forwarding(boolean forwarding) {
        this.valueLeafFlags.set(Ipv4.LeafIdentifier.FORWARDING.getLeafIndex());
        this.forwarding = forwarding;
    }

    @Override
    public void mtu(int mtu) {
        this.valueLeafFlags.set(Ipv4.LeafIdentifier.MTU.getLeafIndex());
        this.mtu = mtu;
    }

    @Override
    public void address(List<Address> address) {
        this.address = address;
    }

    @Override
    public void neighbor(List<Neighbor> neighbor) {
        this.neighbor = neighbor;
    }

    @Override
    public void addToAddress(Address addTo) {
        if (this.address == null) {
            this.address = new ArrayList<Address>();
        }
        this.address.add(addTo);
    }

    @Override
    public void addToNeighbor(Neighbor addTo) {
        if (this.neighbor == null) {
            this.neighbor = new ArrayList<Neighbor>();
        }
        this.neighbor.add(addTo);
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.forwarding, this.mtu, this.valueLeafFlags, this.address, this.neighbor);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultIpv4) {
            DefaultIpv4 other = (DefaultIpv4)obj;
            return Objects.equals(this.enabled, other.enabled) && Objects.equals(this.forwarding, other.forwarding) && Objects.equals(this.mtu, other.mtu) && Objects.equals(this.valueLeafFlags, other.valueLeafFlags) && Objects.equals(this.address, other.address) && Objects.equals(this.neighbor, other.neighbor);
        }
        return false;
    }

    public String toString() {
        return new StringJoiner(", ", this.getClass().getSimpleName() + "{", "}").add("enabled=" + this.enabled).add("forwarding=" + this.forwarding).add("mtu=" + this.mtu).add("valueLeafFlags=" + this.valueLeafFlags).add("address=" + this.address).add("neighbor=" + this.neighbor).toString();
    }

    @Override
    public boolean isLeafValueSet(Ipv4.LeafIdentifier leaf) {
        return this.valueLeafFlags.get(leaf.getLeafIndex());
    }
}

