/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.gen.v1.ietfinettypes.rev20130715.ietfinettypes.ipaddress;

import java.util.BitSet;
import java.util.Objects;
import org.onosproject.yang.gen.v1.ietfinettypes.rev20130715.ietfinettypes.Ipv4Address;
import org.onosproject.yang.gen.v1.ietfinettypes.rev20130715.ietfinettypes.Ipv6Address;

public final class IpAddressUnion {
    private Ipv4Address ipv4Address;
    private Ipv6Address ipv6Address;
    private BitSet setValue = new BitSet();

    private IpAddressUnion() {
    }

    public IpAddressUnion(Ipv4Address ipv4Address) {
        this.setValue.set(0);
        this.ipv4Address = ipv4Address;
    }

    public IpAddressUnion(Ipv6Address ipv6Address) {
        this.setValue.set(1);
        this.ipv6Address = ipv6Address;
    }

    public static IpAddressUnion of(Ipv4Address value) {
        return new IpAddressUnion(value);
    }

    public static IpAddressUnion of(Ipv6Address value) {
        return new IpAddressUnion(value);
    }

    public Ipv4Address ipv4Address() {
        return this.ipv4Address;
    }

    public Ipv6Address ipv6Address() {
        return this.ipv6Address;
    }

    public void ipv4Address(Ipv4Address ipv4Address) {
        this.ipv4Address = ipv4Address;
    }

    public void ipv6Address(Ipv6Address ipv6Address) {
        this.ipv6Address = ipv6Address;
    }

    public int hashCode() {
        return Objects.hash(this.ipv4Address, this.ipv6Address);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof IpAddressUnion) {
            IpAddressUnion other = (IpAddressUnion)obj;
            return Objects.equals(this.ipv4Address, other.ipv4Address) && Objects.equals(this.ipv6Address, other.ipv6Address);
        }
        return false;
    }

    public String toString() {
        if (this.setValue.get(0)) {
            return this.ipv4Address.toString();
        }
        if (this.setValue.get(1)) {
            return this.ipv6Address.toString();
        }
        return null;
    }

    public static IpAddressUnion fromString(String valInString) {
        try {
            Ipv4Address tmpVal = Ipv4Address.fromString(valInString);
            return IpAddressUnion.of(tmpVal);
        }
        catch (Exception tmpVal) {
            try {
                Ipv6Address tmpVal2 = Ipv6Address.fromString(valInString);
                return IpAddressUnion.of(tmpVal2);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("not a valid input element");
            }
        }
    }
}

