/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.lisp.ctl.impl.map;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.onosproject.lisp.ctl.impl.map.ExpireMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpireHashMap<K, V>
implements ExpireMap<K, V> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final long DEFAULT_TTL = 60000L;
    private final ConcurrentMap<K, ExpiredObject<K, V>> map = new ConcurrentHashMap<K, ExpiredObject<K, V>>();
    private final Lock writeLock = new ReentrantLock();
    private final Timer timer = new Timer("ExpireMapTimer", true);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(K key, V value, long expireMs) {
        try {
            this.writeLock.lock();
            ExpiredObject<K, V> object = this.map.putIfAbsent(key, new ExpiredObject<K, V>(key, value, expireMs));
            if (object != null) {
                object.getTask().cancel();
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void put(K key, V value) {
        this.put(key, value, 60000L);
    }

    @Override
    public V get(K key) {
        return this.map.containsKey(key) ? (V)((ExpiredObject)this.map.get(key)).getValue() : null;
    }

    @Override
    public void clear() {
        try {
            this.writeLock.lock();
            for (ExpiredObject object : this.map.values()) {
                object.getTask().cancel();
            }
            this.map.clear();
            this.timer.purge();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public boolean containsKey(K key) {
        return this.map.containsKey(key);
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<V> values() {
        List values = Collections.emptyList();
        this.map.values().forEach(v -> values.add(v.getValue()));
        return values;
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public V remove(K key) {
        ExpiredObject object;
        try {
            this.writeLock.lock();
            object = (ExpiredObject)this.map.remove(key);
            if (object != null) {
                object.getTask().cancel();
            }
        }
        finally {
            this.writeLock.unlock();
        }
        return object == null ? null : (V)object.getValue();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    class ExpiryTask<K2>
    extends TimerTask {
        private final K2 key;

        ExpiryTask(K2 key) {
            this.key = key;
        }

        K2 getKey() {
            return this.key;
        }

        @Override
        public void run() {
            ExpireHashMap.this.log.info("Removing element with key [{}]", this.key);
            try {
                ExpireHashMap.this.writeLock.lock();
                if (ExpireHashMap.this.map.containsKey(this.key)) {
                    ExpireHashMap.this.map.remove(this.getKey());
                }
            }
            finally {
                ExpireHashMap.this.writeLock.unlock();
            }
        }
    }

    class ExpiredObject<K1, V1> {
        private final V1 value;
        private final ExpiryTask<K1> task;
        private final long ttl;

        public ExpiredObject(K1 key, V1 value) {
            this(key, value, 60000L);
        }

        ExpiredObject(K1 key, V1 value, long ttl) {
            this.value = value;
            this.task = new ExpiryTask<K1>(key);
            this.ttl = ttl;
            ExpireHashMap.this.timer.schedule(this.task, ttl);
        }

        ExpiryTask<K1> getTask() {
            return this.task;
        }

        V1 getValue() {
            return this.value;
        }

        long getTtl() {
            return this.ttl;
        }
    }
}

