/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.lisp.ctl.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.onlab.packet.IpPrefix;
import org.onosproject.lisp.ctl.impl.map.ExpireHashMap;
import org.onosproject.lisp.ctl.impl.map.ExpireMap;
import org.onosproject.lisp.msg.protocols.DefaultLispProxyMapRecord;
import org.onosproject.lisp.msg.protocols.LispEidRecord;
import org.onosproject.lisp.msg.protocols.LispMapRecord;
import org.onosproject.lisp.msg.protocols.LispProxyMapRecord;
import org.onosproject.lisp.msg.types.LispAfiAddress;

public final class LispMappingDatabase {
    private static final long MINUTE_TO_MS_UNIT = 60000L;
    private ExpireMap<LispEidRecord, LispProxyMapRecord> map = new ExpireHashMap<LispEidRecord, LispProxyMapRecord>();

    private LispMappingDatabase() {
    }

    public static LispMappingDatabase getInstance() {
        return SingletonHelper.INSTANCE;
    }

    public void putMapRecord(LispEidRecord eid, LispMapRecord rloc, boolean proxyMapReply) {
        LispProxyMapRecord mapWithProxy = new DefaultLispProxyMapRecord.DefaultMapWithProxyBuilder().withMapRecord(rloc).withIsProxyMapReply(proxyMapReply).build();
        this.map.put(eid, mapWithProxy, (long)rloc.getRecordTtl() * 60000L);
    }

    public boolean hasEidRecord(LispEidRecord eid) {
        return this.map.containsKey(eid);
    }

    public void removeMapRecordByEid(LispEidRecord eid) {
        this.map.remove(eid);
    }

    public List<LispMapRecord> getAllMapRecords() {
        ArrayList mapRecords = Lists.newArrayList();
        this.map.values().forEach(value -> mapRecords.add(value.getMapRecord()));
        return mapRecords;
    }

    public LispMapRecord getMapRecordByEidRecord(LispEidRecord eid, boolean proxyMapReply) {
        for (LispEidRecord key : this.map.keySet()) {
            if (!this.isInRange(key, eid) || this.map.get(key) == null || this.map.get(key).isProxyMapReply() != proxyMapReply) continue;
            return this.map.get(key).getMapRecord();
        }
        return null;
    }

    public List<LispMapRecord> getMapRecordByEidRecords(List<LispEidRecord> eids, boolean proxyMapReply) {
        ArrayList mapRecords = Lists.newArrayList();
        eids.forEach(eidRecord -> {
            LispMapRecord mapRecord = this.getMapRecordByEidRecord((LispEidRecord)eidRecord, proxyMapReply);
            if (mapRecord != null) {
                mapRecords.add(mapRecord);
            }
        });
        return ImmutableList.copyOf((Collection)mapRecords);
    }

    public LispMapRecord getMapRecordByEidAddress(LispAfiAddress address) {
        Optional<LispEidRecord> eidRecord = this.map.keySet().stream().filter(k -> k.getPrefix().equals((Object)address)).findFirst();
        return eidRecord.map(lispEidRecord -> this.map.get((LispEidRecord)lispEidRecord).getMapRecord()).orElse(null);
    }

    private String cidrfy(LispEidRecord eidRecord) {
        StringBuilder sb = new StringBuilder();
        sb.append(eidRecord.getPrefix().toString());
        sb.append("/");
        sb.append(eidRecord.getMaskLength());
        return sb.toString();
    }

    private boolean isInRange(LispEidRecord origin, LispEidRecord compare) {
        IpPrefix originIpPrefix = IpPrefix.valueOf((String)this.cidrfy(origin));
        IpPrefix compareIpPrefix = IpPrefix.valueOf((String)this.cidrfy(compare));
        return originIpPrefix.contains(compareIpPrefix);
    }

    private static final class SingletonHelper {
        private static final String ILLEGAL_ACCESS_MSG = "Should not instantiate this class.";
        private static final LispMappingDatabase INSTANCE = new LispMappingDatabase();

        private SingletonHelper() {
            throw new IllegalAccessError(ILLEGAL_ACCESS_MSG);
        }
    }
}

