/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.lisp.ctl.impl;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import org.onlab.packet.IpAddress;
import org.onosproject.lisp.ctl.impl.LispMappingDatabase;
import org.onosproject.lisp.msg.authentication.LispAuthenticationConfig;
import org.onosproject.lisp.msg.authentication.LispAuthenticationKeyEnum;
import org.onosproject.lisp.msg.protocols.DefaultLispInfoReply;
import org.onosproject.lisp.msg.protocols.DefaultLispInfoRequest;
import org.onosproject.lisp.msg.protocols.DefaultLispMapNotify;
import org.onosproject.lisp.msg.protocols.DefaultLispMapRegister;
import org.onosproject.lisp.msg.protocols.LispEidRecord;
import org.onosproject.lisp.msg.protocols.LispInfoReply;
import org.onosproject.lisp.msg.protocols.LispInfoRequest;
import org.onosproject.lisp.msg.protocols.LispMapNotify;
import org.onosproject.lisp.msg.protocols.LispMapRecord;
import org.onosproject.lisp.msg.protocols.LispMapRegister;
import org.onosproject.lisp.msg.protocols.LispMessage;
import org.onosproject.lisp.msg.types.LispAfiAddress;
import org.onosproject.lisp.msg.types.LispIpv4Address;
import org.onosproject.lisp.msg.types.LispIpv6Address;
import org.onosproject.lisp.msg.types.LispNoAddress;
import org.onosproject.lisp.msg.types.lcaf.LispNatLcafAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LispMapServer {
    private static final Logger log = LoggerFactory.getLogger(LispMapServer.class);
    private static final int MAP_NOTIFY_PORT = 4342;
    private static final int INFO_REPLY_PORT = 4342;
    private static final String INVALID_AUTHENTICATION_DATA_MSG = "Unmatched authentication data of {}.";
    private static final String FAILED_TO_FORMULATE_NAT_MSG = "Fails during formulate NAT address.";
    private LispMappingDatabase mapDb = LispMappingDatabase.getInstance();
    private LispAuthenticationConfig authConfig = LispAuthenticationConfig.getInstance();

    private LispMapServer() {
    }

    static LispMapServer getInstance() {
        return SingletonHelper.INSTANCE;
    }

    LispMapNotify processMapRegister(LispMessage message) {
        LispMapRegister register = (LispMapRegister)message;
        if (!this.checkMapRegisterAuthData(register)) {
            log.warn(INVALID_AUTHENTICATION_DATA_MSG, (Object)"Map-Register");
            return null;
        }
        register.getMapRecords().forEach(mapRecord -> {
            LispEidRecord eidRecord = new LispEidRecord(mapRecord.getMaskLength(), mapRecord.getEidPrefixAfi());
            this.mapDb.putMapRecord(eidRecord, (LispMapRecord)mapRecord, register.isProxyMapReply());
        });
        if (register.isWantMapNotify()) {
            DefaultLispMapNotify.DefaultNotifyBuilder notifyBuilder = new DefaultLispMapNotify.DefaultNotifyBuilder();
            notifyBuilder.withKeyId(this.authConfig.lispAuthKeyId());
            notifyBuilder.withAuthDataLength(LispAuthenticationKeyEnum.valueOf((short)this.authConfig.lispAuthKeyId()).getHashLength());
            notifyBuilder.withAuthKey(this.authConfig.lispAuthKey());
            notifyBuilder.withNonce(register.getNonce());
            notifyBuilder.withMapRecords(register.getMapRecords());
            LispMapNotify notify = notifyBuilder.build();
            InetSocketAddress address = new InetSocketAddress(register.getSender().getAddress(), 4342);
            notify.configSender(address);
            return notify;
        }
        return null;
    }

    LispInfoReply processInfoRequest(LispMessage message) {
        LispInfoRequest request = (LispInfoRequest)message;
        if (!this.checkInfoRequestAuthData(request)) {
            log.warn(INVALID_AUTHENTICATION_DATA_MSG, (Object)"Info-Request");
            return null;
        }
        LispNatLcafAddress.NatAddressBuilder natBuilder = new LispNatLcafAddress.NatAddressBuilder();
        try {
            LispIpv4Address msAddress = new LispIpv4Address(IpAddress.valueOf((InetAddress)InetAddress.getLocalHost()));
            natBuilder.withMsRlocAddress((LispAfiAddress)msAddress);
            natBuilder.withMsUdpPortNumber((short)4342);
            IpAddress globalRlocIp = IpAddress.valueOf((InetAddress)request.getSender().getAddress());
            Object globalRlocAddress = globalRlocIp.isIp4() ? new LispIpv4Address(globalRlocIp) : new LispIpv6Address(globalRlocIp);
            natBuilder.withGlobalEtrRlocAddress((LispAfiAddress)globalRlocAddress);
            natBuilder.withEtrUdpPortNumber((short)request.getSender().getPort());
            natBuilder.withPrivateEtrRlocAddress((LispAfiAddress)new LispNoAddress());
        }
        catch (UnknownHostException e) {
            log.warn(FAILED_TO_FORMULATE_NAT_MSG, (Throwable)e);
        }
        DefaultLispInfoReply.DefaultInfoReplyBuilder replyBuilder = new DefaultLispInfoReply.DefaultInfoReplyBuilder();
        replyBuilder.withKeyId(request.getKeyId());
        replyBuilder.withAuthDataLength(LispAuthenticationKeyEnum.valueOf((short)this.authConfig.lispAuthKeyId()).getHashLength());
        replyBuilder.withAuthKey(this.authConfig.lispAuthKey());
        replyBuilder.withNonce(request.getNonce());
        replyBuilder.withEidPrefix(request.getPrefix());
        replyBuilder.withMaskLength(request.getMaskLength());
        replyBuilder.withTtl(request.getTtl());
        replyBuilder.withNatLcafAddress(natBuilder.build());
        replyBuilder.withIsInfoReply(true);
        LispInfoReply reply = replyBuilder.build();
        reply.configSender(request.getSender());
        return reply;
    }

    private boolean checkMapRegisterAuthData(LispMapRegister register) {
        DefaultLispMapRegister.DefaultRegisterBuilder registerBuilder = new DefaultLispMapRegister.DefaultRegisterBuilder();
        registerBuilder.withKeyId(register.getKeyId());
        registerBuilder.withAuthKey(this.authConfig.lispAuthKey());
        registerBuilder.withNonce(register.getNonce());
        registerBuilder.withIsProxyMapReply(register.isProxyMapReply());
        registerBuilder.withIsWantMapNotify(register.isWantMapNotify());
        registerBuilder.withMapRecords(register.getMapRecords());
        LispMapRegister authRegister = registerBuilder.build();
        return Arrays.equals(authRegister.getAuthData(), register.getAuthData());
    }

    private boolean checkInfoRequestAuthData(LispInfoRequest request) {
        DefaultLispInfoRequest.DefaultInfoRequestBuilder requestBuilder = new DefaultLispInfoRequest.DefaultInfoRequestBuilder();
        requestBuilder.withKeyId(request.getKeyId());
        requestBuilder.withAuthKey(this.authConfig.lispAuthKey());
        requestBuilder.withNonce(request.getNonce());
        requestBuilder.withTtl(request.getTtl());
        requestBuilder.withEidPrefix(request.getPrefix());
        requestBuilder.withIsInfoReply(request.isInfoReply());
        requestBuilder.withMaskLength(request.getMaskLength());
        LispInfoRequest authRequest = requestBuilder.build();
        return Arrays.equals(authRequest.getAuthData(), request.getAuthData());
    }

    private static final class SingletonHelper {
        private static final String ILLEGAL_ACCESS_MSG = "Should not instantiate this class.";
        private static final LispMapServer INSTANCE = new LispMapServer();

        private SingletonHelper() {
            throw new IllegalAccessError(ILLEGAL_ACCESS_MSG);
        }
    }
}

