/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.lisp.ctl.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import org.onosproject.lisp.ctl.impl.LispMappingDatabase;
import org.onosproject.lisp.msg.protocols.DefaultLispEncapsulatedControl;
import org.onosproject.lisp.msg.protocols.DefaultLispMapRecord;
import org.onosproject.lisp.msg.protocols.DefaultLispMapReply;
import org.onosproject.lisp.msg.protocols.LispEidRecord;
import org.onosproject.lisp.msg.protocols.LispEncapsulatedControl;
import org.onosproject.lisp.msg.protocols.LispLocator;
import org.onosproject.lisp.msg.protocols.LispMapRecord;
import org.onosproject.lisp.msg.protocols.LispMapReply;
import org.onosproject.lisp.msg.protocols.LispMapReplyAction;
import org.onosproject.lisp.msg.protocols.LispMapRequest;
import org.onosproject.lisp.msg.protocols.LispMessage;
import org.onosproject.lisp.msg.types.LispAfiAddress;
import org.onosproject.lisp.msg.types.LispIpAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LispMapResolver {
    private static final Logger log = LoggerFactory.getLogger(LispMapResolver.class);
    private static final int ECM_DST_PORT = 4342;
    private static final int NEGATIVE_REPLY_DST_PORT = 4342;
    private static final int MAP_REPLY_RECORD_TTL = 15;
    private static final short MAP_VERSION_NUMBER = 0;
    private static final String NO_ITR_RLOCS_MSG = "No ITR RLOC is found, cannot respond to ITR.";
    private static final String NO_ETR_RLOCS_MSG = "No ETR RLOC is found, cannot relay to ETR.";
    private static final String NO_MAP_INFO_MSG = "Map information is not found.";
    private LispMappingDatabase mapDb = LispMappingDatabase.getInstance();

    private LispMapResolver() {
    }

    static LispMapResolver getInstance() {
        return SingletonHelper.INSTANCE;
    }

    List<LispMessage> processMapRequest(LispMessage message) {
        LispEncapsulatedControl ecm = (LispEncapsulatedControl)message;
        LispMapRequest request = (LispMapRequest)ecm.getControlMessage();
        List<LispMapRecord> mapReplyRecords = this.mapDb.getMapRecordByEidRecords(request.getEids(), true);
        List<LispMapRecord> mapRequestRecords = this.mapDb.getMapRecordByEidRecords(request.getEids(), false);
        if (mapReplyRecords.size() + mapRequestRecords.size() == 0) {
            ArrayList mapReplies = Lists.newArrayList();
            LispMapReply.ReplyBuilder replyBuilder = this.initMapReplyBuilder(request);
            replyBuilder.withMapRecords(this.getNegativeMapRecords(request.getEids()));
            LispMapReply mapReply = replyBuilder.build();
            mapReply.configSender(new InetSocketAddress(ecm.getSender().getAddress(), 4342));
            mapReplies.add(mapReply);
            log.warn(NO_MAP_INFO_MSG);
        } else {
            if (!mapReplyRecords.isEmpty()) {
                ArrayList mapReplies = Lists.newArrayList();
                LispMapReply.ReplyBuilder replyBuilder = this.initMapReplyBuilder(request);
                replyBuilder.withMapRecords(mapReplyRecords);
                List<InetSocketAddress> addresses = this.getItrAddresses(request.getItrRlocs(), ecm.innerUdp().getSourcePort());
                addresses.forEach(address -> {
                    if (address != null) {
                        LispMapReply reply = replyBuilder.build();
                        reply.configSender(address);
                        mapReplies.add(reply);
                    } else {
                        log.warn(NO_ITR_RLOCS_MSG);
                    }
                });
                return mapReplies;
            }
            if (!mapRequestRecords.isEmpty()) {
                ArrayList ecms = Lists.newArrayList();
                List<InetSocketAddress> addresses = this.getEtrAddresses(mapRequestRecords, 4342);
                addresses.forEach(address -> {
                    if (address != null) {
                        LispEncapsulatedControl reencapEcm = this.cloneEcm(ecm);
                        reencapEcm.configSender(address);
                        ecms.add(reencapEcm);
                    } else {
                        log.warn(NO_ETR_RLOCS_MSG);
                    }
                });
                return ecms;
            }
        }
        return ImmutableList.of();
    }

    private LispMapReply.ReplyBuilder initMapReplyBuilder(LispMapRequest request) {
        DefaultLispMapReply.DefaultReplyBuilder replyBuilder = new DefaultLispMapReply.DefaultReplyBuilder();
        replyBuilder.withNonce(request.getNonce());
        replyBuilder.withIsEtr(false);
        replyBuilder.withIsSecurity(false);
        replyBuilder.withIsProbe(request.isProbe());
        return replyBuilder;
    }

    private LispEncapsulatedControl cloneEcm(LispEncapsulatedControl ecm) {
        DefaultLispEncapsulatedControl.DefaultEcmBuilder ecmBuilder = new DefaultLispEncapsulatedControl.DefaultEcmBuilder();
        ecmBuilder.innerLispMessage(ecm.getControlMessage());
        ecmBuilder.isSecurity(ecm.isSecurity());
        ecmBuilder.innerIpHeader(ecm.innerIpHeader());
        ecmBuilder.innerUdpHeader(ecm.innerUdp());
        return ecmBuilder.build();
    }

    private List<LispMapRecord> getNegativeMapRecords(List<LispEidRecord> eids) {
        ArrayList mapRecords = Lists.newArrayList();
        DefaultLispMapRecord.DefaultMapRecordBuilder recordBuilder = new DefaultLispMapRecord.DefaultMapRecordBuilder();
        recordBuilder.withRecordTtl(15);
        recordBuilder.withLocators((List)Lists.newArrayList());
        recordBuilder.withIsAuthoritative(false);
        recordBuilder.withMapVersionNumber((short)0);
        recordBuilder.withAction(LispMapReplyAction.NativelyForward);
        eids.forEach(arg_0 -> LispMapResolver.lambda$getNegativeMapRecords$2((LispMapRecord.MapRecordBuilder)recordBuilder, mapRecords, arg_0));
        return mapRecords;
    }

    private List<InetSocketAddress> getItrAddresses(List<LispAfiAddress> itrRlocs, int port) {
        ArrayList addresses = Lists.newArrayList();
        for (LispAfiAddress itrRloc : itrRlocs) {
            addresses.add(new InetSocketAddress(((LispIpAddress)itrRloc).getAddress().toInetAddress(), port));
        }
        return addresses;
    }

    private List<InetSocketAddress> getEtrAddresses(List<LispMapRecord> mapRecords, int port) {
        ArrayList addresses = Lists.newArrayList();
        for (LispMapRecord mapRecord : mapRecords) {
            LispLocator locatorRecord = (LispLocator)mapRecord.getLocators().get(0);
            if (locatorRecord == null) continue;
            addresses.add(new InetSocketAddress(((LispIpAddress)locatorRecord.getLocatorAfi()).getAddress().toInetAddress(), port));
        }
        return addresses;
    }

    private static /* synthetic */ void lambda$getNegativeMapRecords$2(LispMapRecord.MapRecordBuilder recordBuilder, List mapRecords, LispEidRecord eid) {
        recordBuilder.withEidPrefixAfi(eid.getPrefix());
        recordBuilder.withMaskLength(eid.getMaskLength());
        mapRecords.add(recordBuilder.build());
    }

    private static final class SingletonHelper {
        private static final String ILLEGAL_ACCESS_MSG = "Should not instantiate this class.";
        private static final LispMapResolver INSTANCE = new LispMapResolver();

        private SingletonHelper() {
            throw new IllegalAccessError(ILLEGAL_ACCESS_MSG);
        }
    }
}

