/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.lisp.ctl.impl;

import com.google.common.collect.Maps;
import java.util.Dictionary;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.Tools;
import org.onosproject.cfg.ComponentConfigService;
import org.onosproject.core.CoreService;
import org.onosproject.lisp.ctl.LispController;
import org.onosproject.lisp.ctl.LispMessageListener;
import org.onosproject.lisp.ctl.LispRouter;
import org.onosproject.lisp.ctl.LispRouterAgent;
import org.onosproject.lisp.ctl.LispRouterFactory;
import org.onosproject.lisp.ctl.LispRouterId;
import org.onosproject.lisp.ctl.LispRouterListener;
import org.onosproject.lisp.ctl.impl.LispControllerBootstrap;
import org.onosproject.lisp.msg.authentication.LispAuthenticationConfig;
import org.onosproject.lisp.msg.protocols.LispInfoReply;
import org.onosproject.lisp.msg.protocols.LispInfoRequest;
import org.onosproject.lisp.msg.protocols.LispMessage;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class LispControllerImpl
implements LispController {
    private static final String APP_ID = "org.onosproject.lisp-base";
    private static final Logger log = LoggerFactory.getLogger(LispControllerImpl.class);
    private static final String DEFAULT_LISP_AUTH_KEY = "onos";
    private static final short DEFAULT_LISP_AUTH_KEY_ID = 1;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ComponentConfigService cfgService;
    @Property(name="lispAuthKey", value={"onos"}, label="Authentication key which is used to calculate authentication data for LISP control message; default value is onos")
    private String lispAuthKey = "onos";
    @Property(name="lispAuthKeyId", intValue={1}, label="Authentication key id which denotes the authentication method that ONOS uses to calculate the authentication data; 1 denotes HMAC SHA1 encryption, 2 denotes HMAC SHA256 encryption; default value is 1")
    private int lispAuthKeyId = 1;
    ExecutorService executorMessages = Executors.newFixedThreadPool(4, Tools.groupedThreads((String)"onos/lisp", (String)"event-stats-%d", (Logger)log));
    protected LispRouterAgent agent = new DefaultLispRouterAgent();
    ConcurrentMap<LispRouterId, LispRouter> connectedRouters = Maps.newConcurrentMap();
    final LispAuthenticationConfig authConfig = LispAuthenticationConfig.getInstance();
    LispControllerBootstrap bootstrap = new LispControllerBootstrap();
    private Set<LispRouterListener> lispRouterListeners = new CopyOnWriteArraySet<LispRouterListener>();
    private Set<LispMessageListener> lispMessageListeners = new CopyOnWriteArraySet<LispMessageListener>();
    private LispRouterFactory routerFactory = LispRouterFactory.getInstance();

    @Activate
    public void activate(ComponentContext context) {
        this.coreService.registerApplication(APP_ID, this::cleanup);
        this.cfgService.registerProperties(this.getClass());
        this.initAuthConfig(context.getProperties());
        this.routerFactory.setAgent(this.agent);
        this.bootstrap.start();
        log.info("Started");
    }

    private void cleanup() {
        this.bootstrap.stop();
        this.routerFactory.cleanAgent();
        this.connectedRouters.values().forEach(LispRouter::disconnectRouter);
        this.connectedRouters.clear();
    }

    @Deactivate
    public void deactivate() {
        this.cleanup();
        this.cfgService.unregisterProperties(this.getClass(), false);
        log.info("Stopped");
    }

    @Modified
    public void modified(ComponentContext context) {
        this.readComponentConfiguration(context);
        this.bootstrap.stop();
        this.bootstrap.start();
    }

    private void initAuthConfig(Dictionary<?, ?> properties) {
        this.authConfig.updateLispAuthKey(Tools.get(properties, (String)"lispAuthKey"));
        this.authConfig.updateLispAuthKeyId(Tools.getIntegerProperty(properties, (String)"lispAuthKeyId").intValue());
    }

    private void readComponentConfiguration(ComponentContext context) {
        Dictionary properties = context.getProperties();
        String lispAuthKeyStr = Tools.get((Dictionary)properties, (String)"lispAuthKey");
        this.lispAuthKey = lispAuthKeyStr != null ? lispAuthKeyStr : DEFAULT_LISP_AUTH_KEY;
        this.authConfig.updateLispAuthKey(this.lispAuthKey);
        log.info("Configured. LISP authentication key is {}", (Object)this.lispAuthKey);
        Integer lispAuthMethodInt = Tools.getIntegerProperty((Dictionary)properties, (String)"lispAuthKeyId");
        if (lispAuthMethodInt == null) {
            this.lispAuthKeyId = 1;
            log.info("LISP authentication method is not configured, default value is {}", (Object)this.lispAuthKeyId);
        } else {
            this.lispAuthKeyId = lispAuthMethodInt;
            log.info("Configured. LISP authentication method is configured to {}", (Object)this.lispAuthKeyId);
        }
        this.authConfig.updateLispAuthKeyId(this.lispAuthKeyId);
    }

    public Iterable<LispRouter> getRouters() {
        return this.connectedRouters.values();
    }

    public Iterable<LispRouter> getSubscribedRouters() {
        return this.connectedRouters.entrySet().stream().filter(e -> ((LispRouter)e.getValue()).isSubscribed()).collect(Collectors.toConcurrentMap(Map.Entry::getKey, Map.Entry::getValue)).values();
    }

    public LispRouter connectRouter(LispRouterId routerId) {
        if (this.connectedRouters.containsKey(routerId)) {
            log.debug("LISP router {} is already existing", (Object)routerId);
            return (LispRouter)this.connectedRouters.get(routerId);
        }
        log.warn("Adding router from netcfg is not supported currently");
        return null;
    }

    public void disconnectRouter(LispRouterId routerId, boolean remove) {
        if (!this.connectedRouters.containsKey(routerId)) {
            log.warn("LISP router {} is not existing", (Object)routerId);
        } else {
            ((LispRouter)this.connectedRouters.get(routerId)).disconnectRouter();
            if (remove) {
                this.agent.removeConnectedRouter(routerId);
            }
        }
    }

    public LispRouter getRouter(LispRouterId routerId) {
        return (LispRouter)this.connectedRouters.get(routerId);
    }

    public void addRouterListener(LispRouterListener listener) {
        if (!this.lispRouterListeners.contains(listener)) {
            this.lispRouterListeners.add(listener);
        }
    }

    public void removeRouterListener(LispRouterListener listener) {
        this.lispRouterListeners.remove(listener);
    }

    public void addMessageListener(LispMessageListener listener) {
        if (!this.lispMessageListeners.contains(listener)) {
            this.lispMessageListeners.add(listener);
        }
    }

    public void removeMessageListener(LispMessageListener listener) {
        this.lispMessageListeners.remove(listener);
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindCfgService(ComponentConfigService componentConfigService) {
        this.cfgService = componentConfigService;
    }

    protected void unbindCfgService(ComponentConfigService componentConfigService) {
        if (this.cfgService == componentConfigService) {
            this.cfgService = null;
        }
    }

    protected final class LispOutgoingMessageHandler
    extends LispMessageHandler
    implements Runnable {
        LispOutgoingMessageHandler(LispRouterId routerId, LispMessage message) {
            super(routerId, message, false);
        }
    }

    protected final class LispIncomingMessageHandler
    extends LispMessageHandler
    implements Runnable {
        LispIncomingMessageHandler(LispRouterId routerId, LispMessage message) {
            super(routerId, message, true);
        }
    }

    protected class LispMessageHandler
    implements Runnable {
        private final LispRouterId routerId;
        private final LispMessage message;
        private final boolean isIncoming;

        LispMessageHandler(LispRouterId routerId, LispMessage message, boolean isIncoming) {
            this.routerId = routerId;
            this.message = message;
            this.isIncoming = isIncoming;
        }

        @Override
        public void run() {
            for (LispMessageListener listener : LispControllerImpl.this.lispMessageListeners) {
                if (this.isIncoming) {
                    listener.handleIncomingMessage(this.routerId, this.message);
                    continue;
                }
                listener.handleOutgoingMessage(this.routerId, this.message);
            }
        }
    }

    public final class DefaultLispRouterAgent
    implements LispRouterAgent {
        private final Logger log = LoggerFactory.getLogger(DefaultLispRouterAgent.class);

        private DefaultLispRouterAgent() {
        }

        public boolean addConnectedRouter(LispRouterId routerId, LispRouter router) {
            if (LispControllerImpl.this.connectedRouters.get(routerId) != null) {
                this.log.warn("Trying to add connectedRouter but found a previous value for routerId: {}", (Object)routerId);
                return false;
            }
            this.log.info("Added router {}", (Object)routerId);
            LispControllerImpl.this.connectedRouters.put(routerId, router);
            for (LispRouterListener listener : LispControllerImpl.this.lispRouterListeners) {
                listener.routerAdded(routerId);
            }
            return true;
        }

        public void removeConnectedRouter(LispRouterId routerId) {
            if (LispControllerImpl.this.connectedRouters.get(routerId) == null) {
                this.log.error("Trying to remove router {} from connectedRouter list but no element was found", (Object)routerId);
            } else {
                this.log.info("Removed router {}", (Object)routerId);
                LispControllerImpl.this.connectedRouters.remove(routerId);
                for (LispRouterListener listener : LispControllerImpl.this.lispRouterListeners) {
                    listener.routerRemoved(routerId);
                }
            }
        }

        public void processUpstreamMessage(LispRouterId routerId, LispMessage message) {
            switch (message.getType()) {
                case LISP_MAP_REGISTER: 
                case LISP_MAP_REQUEST: {
                    LispControllerImpl.this.executorMessages.execute(new LispIncomingMessageHandler(routerId, message));
                    break;
                }
                case LISP_INFO: {
                    if (message instanceof LispInfoRequest) {
                        LispControllerImpl.this.executorMessages.execute(new LispIncomingMessageHandler(routerId, message));
                        break;
                    }
                    this.log.warn("Not incoming LISP control message");
                    break;
                }
                default: {
                    this.log.warn("Not incoming LISP control message");
                }
            }
        }

        public void processDownstreamMessage(LispRouterId routerId, LispMessage message) {
            switch (message.getType()) {
                case LISP_MAP_NOTIFY: 
                case LISP_MAP_REPLY: {
                    LispControllerImpl.this.executorMessages.execute(new LispOutgoingMessageHandler(routerId, message));
                    break;
                }
                case LISP_INFO: {
                    if (message instanceof LispInfoReply) {
                        LispControllerImpl.this.executorMessages.execute(new LispOutgoingMessageHandler(routerId, message));
                        break;
                    }
                    this.log.warn("Not outgoing LISP control message");
                    break;
                }
                default: {
                    this.log.warn("Not outgoing LISP control message");
                }
            }
        }
    }
}

