/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.lisp.ctl.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.AbstractChannel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollDatagramChannel;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioDatagramChannel;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import org.onosproject.lisp.ctl.impl.LispChannelInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LispControllerBootstrap {
    protected static final Logger log = LoggerFactory.getLogger(LispControllerBootstrap.class);
    private static final int LISP_DATA_PORT = 4341;
    private static final int LISP_CONTROL_PORT = 4342;
    protected List<Integer> lispPorts = ImmutableList.of((Object)4341, (Object)4342);
    private EventLoopGroup eventLoopGroup;
    private Class<? extends AbstractChannel> channelClass;
    private List<ChannelFuture> channelFutures = Lists.newArrayList();

    private void run() {
        try {
            Bootstrap bootstrap = this.createServerBootstrap();
            this.configBootstrapOptions(bootstrap);
            this.lispPorts.forEach(p -> {
                InetSocketAddress sa = new InetSocketAddress((int)p);
                this.channelFutures.add(bootstrap.bind((SocketAddress)sa));
                log.info("Listening for LISP router connections on {}", (Object)sa);
            });
            for (ChannelFuture f : this.channelFutures) {
                f.sync();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Bootstrap createServerBootstrap() {
        Bootstrap bootstrap = new Bootstrap();
        this.initEventLoopGroup();
        ((Bootstrap)((Bootstrap)bootstrap.group(this.eventLoopGroup)).channel(this.channelClass)).handler((ChannelHandler)new LispChannelInitializer());
        return bootstrap;
    }

    private void configBootstrapOptions(Bootstrap bootstrap) {
        bootstrap.option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT);
    }

    private void closeChannels(List<ChannelFuture> channelFutures) {
        try {
            for (ChannelFuture f : channelFutures) {
                f.channel().closeFuture().sync();
            }
        }
        catch (InterruptedException e) {
            log.warn("Failed to close channels. Reasons: {}.", (Object)e.getMessage());
        }
    }

    private void initEventLoopGroup() {
        try {
            this.eventLoopGroup = new EpollEventLoopGroup();
            this.channelClass = EpollDatagramChannel.class;
        }
        catch (NoClassDefFoundError e) {
            log.debug("Failed to initialize native (epoll) transport. Reason: {}. Proceeding with NIO event group.", (Throwable)e);
        }
        this.eventLoopGroup = new NioEventLoopGroup();
        this.channelClass = NioDatagramChannel.class;
    }

    public void start() {
        log.info("Starting LISP control I/O");
        this.run();
    }

    public void stop() {
        log.info("Stopping LISP control I/O");
        try {
            this.eventLoopGroup.shutdownGracefully().sync();
            this.closeChannels(this.channelFutures);
        }
        catch (InterruptedException e) {
            log.warn("Failed to stop LISP controller. Reasons: {}.", (Object)e.getMessage());
        }
    }
}

