/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.lisp.ctl.impl;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.ReferenceCountUtil;
import java.net.InetAddress;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.onlab.packet.IpAddress;
import org.onlab.util.Tools;
import org.onosproject.lisp.ctl.LispRouter;
import org.onosproject.lisp.ctl.LispRouterFactory;
import org.onosproject.lisp.ctl.impl.LispMapResolver;
import org.onosproject.lisp.ctl.impl.LispMapServer;
import org.onosproject.lisp.msg.protocols.LispEncapsulatedControl;
import org.onosproject.lisp.msg.protocols.LispInfoReply;
import org.onosproject.lisp.msg.protocols.LispInfoRequest;
import org.onosproject.lisp.msg.protocols.LispMapNotify;
import org.onosproject.lisp.msg.protocols.LispMapRegister;
import org.onosproject.lisp.msg.protocols.LispMapRequest;
import org.onosproject.lisp.msg.protocols.LispMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LispChannelHandler
extends ChannelInboundHandlerAdapter {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final LispRouterFactory routerFactory = LispRouterFactory.getInstance();
    protected ExecutorService executorMessages = Executors.newFixedThreadPool(32, Tools.groupedThreads((String)"onos/lisp", (String)"message-stats-%d", (Logger)this.log));

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        this.executorMessages.execute(new LispMessageHandler(ctx, (LispMessage)msg));
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent) {
            IdleStateEvent event = (IdleStateEvent)evt;
            if (event.state() == IdleState.READER_IDLE) {
                this.log.info("READER_IDLE read timeout");
                ctx.disconnect();
            } else if (event.state() == IdleState.WRITER_IDLE) {
                this.log.info("WRITER_IDLE write timeout");
                ctx.disconnect();
            } else if (event.state() == IdleState.ALL_IDLE) {
                this.log.info("ALL_IDLE total timeout");
                ctx.disconnect();
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.log.warn(cause.getMessage());
    }

    private LispMessage extractLispMessage(LispEncapsulatedControl ecm) {
        LispMessage message = ecm.getControlMessage();
        message.configSender(ecm.getSender());
        return message;
    }

    private final class LispMessageHandler
    implements Runnable {
        protected final ChannelHandlerContext ctx;
        protected final LispMessage msg;
        private LispRouter router;

        public LispMessageHandler(ChannelHandlerContext ctx, LispMessage msg) {
            this.ctx = ctx;
            this.msg = msg;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                LispMapServer mapServer;
                LispInfoReply infoReply;
                LispMapResolver mapResolver;
                List<LispMessage> lispMessages;
                LispMessage innerMsg;
                if (this.msg instanceof LispEncapsulatedControl && (innerMsg = LispChannelHandler.this.extractLispMessage((LispEncapsulatedControl)this.msg)) instanceof LispMapRequest && (lispMessages = (mapResolver = LispMapResolver.getInstance()).processMapRequest(this.msg)) != null) {
                    lispMessages.forEach(arg_0 -> ((ChannelHandlerContext)this.ctx).writeAndFlush(arg_0));
                }
                if (this.msg instanceof LispMapRegister) {
                    LispMapRegister register = (LispMapRegister)this.msg;
                    IpAddress xtrAddress = IpAddress.valueOf((InetAddress)register.getSender().getAddress());
                    this.router = LispChannelHandler.this.routerFactory.getRouterInstance(xtrAddress);
                    this.router.setChannel(this.ctx.channel());
                    this.router.connectRouter();
                    this.router.handleMessage((LispMessage)register);
                    LispMapServer mapServer2 = LispMapServer.getInstance();
                    LispMapNotify mapNotify = mapServer2.processMapRegister((LispMessage)register);
                    if (mapNotify != null) {
                        this.ctx.writeAndFlush((Object)mapNotify);
                    }
                }
                if (this.msg instanceof LispInfoRequest && (infoReply = (mapServer = LispMapServer.getInstance()).processInfoRequest(this.msg)) != null) {
                    this.ctx.writeAndFlush((Object)infoReply);
                }
            }
            finally {
                ReferenceCountUtil.release((Object)this.msg);
            }
        }
    }
}

