/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.reactive.routing;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.Set;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onlab.packet.ARP;
import org.onlab.packet.EthType;
import org.onlab.packet.Ethernet;
import org.onlab.packet.IPv4;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.IpAddress;
import org.onlab.packet.IpPrefix;
import org.onlab.packet.MacAddress;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.incubator.net.intf.Interface;
import org.onosproject.incubator.net.intf.InterfaceService;
import org.onosproject.incubator.net.routing.Route;
import org.onosproject.incubator.net.routing.RouteService;
import org.onosproject.intentsync.IntentSynchronizationService;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.Host;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.host.HostService;
import org.onosproject.net.packet.DefaultOutboundPacket;
import org.onosproject.net.packet.InboundPacket;
import org.onosproject.net.packet.OutboundPacket;
import org.onosproject.net.packet.PacketContext;
import org.onosproject.net.packet.PacketPriority;
import org.onosproject.net.packet.PacketProcessor;
import org.onosproject.net.packet.PacketService;
import org.onosproject.reactive.routing.IntentRequestListener;
import org.onosproject.reactive.routing.LocationType;
import org.onosproject.reactive.routing.ReactiveRoutingConfigurationService;
import org.onosproject.reactive.routing.ReactiveRoutingFib;
import org.onosproject.reactive.routing.TrafficType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class SdnIpReactiveRouting {
    private static final String APP_NAME = "org.onosproject.reactive.routing";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected PacketService packetService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected RouteService routeService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected IntentSynchronizationService intentSynchronizer;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ReactiveRoutingConfigurationService config;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected InterfaceService interfaceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected HostService hostService;
    private ApplicationId appId;
    private IntentRequestListener intentRequestListener;
    private ReactiveRoutingProcessor processor = new ReactiveRoutingProcessor();

    @Activate
    public void activate() {
        this.appId = this.coreService.registerApplication(APP_NAME);
        this.intentRequestListener = new ReactiveRoutingFib(this.appId, this.hostService, this.interfaceService, this.intentSynchronizer);
        this.packetService.addProcessor((PacketProcessor)this.processor, PacketProcessor.director((int)2));
        this.requestIntercepts();
        this.log.info("SDN-IP Reactive Routing Started");
    }

    @Deactivate
    public void deactivate() {
        this.withdrawIntercepts();
        this.packetService.removeProcessor((PacketProcessor)this.processor);
        this.processor = null;
        this.log.info("SDN-IP Reactive Routing Stopped");
    }

    private void requestIntercepts() {
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        selector.matchEthType(Ethernet.TYPE_IPV4);
        this.packetService.requestPackets(selector.build(), PacketPriority.REACTIVE, this.appId);
        selector.matchEthType(Ethernet.TYPE_ARP);
        this.packetService.requestPackets(selector.build(), PacketPriority.REACTIVE, this.appId);
    }

    private void withdrawIntercepts() {
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        selector.matchEthType(Ethernet.TYPE_IPV4);
        this.packetService.cancelPackets(selector.build(), PacketPriority.REACTIVE, this.appId);
        selector = DefaultTrafficSelector.builder();
        selector.matchEthType(Ethernet.TYPE_ARP);
        this.packetService.cancelPackets(selector.build(), PacketPriority.REACTIVE, this.appId);
    }

    private void packetReactiveProcessor(IpAddress dstIpAddress, IpAddress srcIpAddress, ConnectPoint srcConnectPoint, MacAddress srcMacAddress) {
        Preconditions.checkNotNull((Object)dstIpAddress);
        Preconditions.checkNotNull((Object)srcIpAddress);
        Preconditions.checkNotNull((Object)srcConnectPoint);
        Preconditions.checkNotNull((Object)srcMacAddress);
        IpPrefix ipPrefix = null;
        Route route = null;
        if (this.config.isIpAddressLocal(dstIpAddress)) {
            ipPrefix = dstIpAddress.isIp4() ? IpPrefix.valueOf((IpAddress)dstIpAddress, (int)32) : IpPrefix.valueOf((IpAddress)dstIpAddress, (int)128);
        } else {
            route = this.routeService.longestPrefixMatch(dstIpAddress);
            if (route != null) {
                ipPrefix = route.prefix();
            }
        }
        if (ipPrefix != null && this.intentRequestListener.mp2pIntentExists(ipPrefix)) {
            this.intentRequestListener.updateExistingMp2pIntent(ipPrefix, srcConnectPoint);
            return;
        }
        TrafficType trafficType = this.trafficTypeClassifier(srcConnectPoint, dstIpAddress);
        switch (trafficType) {
            case HOST_TO_INTERNET: {
                this.intentRequestListener.setUpConnectivityHostToInternet(srcIpAddress, ipPrefix, route.nextHop());
                break;
            }
            case INTERNET_TO_HOST: {
                this.intentRequestListener.setUpConnectivityInternetToHost(dstIpAddress);
                break;
            }
            case HOST_TO_HOST: {
                this.intentRequestListener.setUpConnectivityHostToHost(dstIpAddress, srcIpAddress, srcMacAddress, srcConnectPoint);
                break;
            }
            case INTERNET_TO_INTERNET: {
                this.log.trace("This is transit traffic, the intent should be preinstalled already");
                break;
            }
            case DROP: {
                break;
            }
            case UNKNOWN: {
                this.log.trace("This is unknown traffic, so we do nothing");
                break;
            }
        }
    }

    private TrafficType trafficTypeClassifier(ConnectPoint srcConnectPoint, IpAddress dstIp) {
        LocationType dstIpLocationType = this.getLocationType(dstIp);
        Optional srcInterface = this.interfaceService.getInterfacesByPort(srcConnectPoint).stream().findFirst();
        Set<ConnectPoint> bgpPeerConnectPoints = this.config.getBgpPeerConnectPoints();
        switch (dstIpLocationType) {
            case INTERNET: {
                if (srcInterface.isPresent() && !bgpPeerConnectPoints.contains(srcConnectPoint)) {
                    return TrafficType.HOST_TO_INTERNET;
                }
                return TrafficType.INTERNET_TO_INTERNET;
            }
            case LOCAL: {
                if (srcInterface.isPresent() && !bgpPeerConnectPoints.contains(srcConnectPoint)) {
                    return TrafficType.HOST_TO_HOST;
                }
                return TrafficType.INTERNET_TO_HOST;
            }
            case NO_ROUTE: {
                return TrafficType.DROP;
            }
        }
        return TrafficType.UNKNOWN;
    }

    private LocationType getLocationType(IpAddress ipAddress) {
        if (this.config.isIpAddressLocal(ipAddress)) {
            return LocationType.LOCAL;
        }
        if (this.routeService.longestPrefixMatch(ipAddress) != null) {
            return LocationType.INTERNET;
        }
        return LocationType.NO_ROUTE;
    }

    public ConnectPoint getEgressConnectPoint(IpAddress dstIpAddress) {
        LocationType type = this.getLocationType(dstIpAddress);
        if (type == LocationType.LOCAL) {
            Set hosts = this.hostService.getHostsByIp(dstIpAddress);
            if (!hosts.isEmpty()) {
                return ((Host)hosts.iterator().next()).location();
            }
            this.hostService.startMonitoringIp(dstIpAddress);
            return null;
        }
        if (type == LocationType.INTERNET) {
            IpAddress nextHopIpAddress = null;
            Route route = this.routeService.longestPrefixMatch(dstIpAddress);
            if (route != null) {
                nextHopIpAddress = route.nextHop();
                Interface it = this.interfaceService.getMatchingInterface(nextHopIpAddress);
                if (it != null) {
                    return it.connectPoint();
                }
                return null;
            }
            return null;
        }
        return null;
    }

    private void forwardPacketToDst(PacketContext context, ConnectPoint connectPoint) {
        TrafficTreatment treatment = DefaultTrafficTreatment.builder().setOutput(connectPoint.port()).build();
        DefaultOutboundPacket packet = new DefaultOutboundPacket(connectPoint.deviceId(), treatment, context.inPacket().unparsed());
        this.packetService.emit((OutboundPacket)packet);
        this.log.trace("sending packet: {}", (Object)packet);
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindPacketService(PacketService packetService) {
        this.packetService = packetService;
    }

    protected void unbindPacketService(PacketService packetService) {
        if (this.packetService == packetService) {
            this.packetService = null;
        }
    }

    protected void bindRouteService(RouteService routeService) {
        this.routeService = routeService;
    }

    protected void unbindRouteService(RouteService routeService) {
        if (this.routeService == routeService) {
            this.routeService = null;
        }
    }

    protected void bindIntentSynchronizer(IntentSynchronizationService intentSynchronizationService) {
        this.intentSynchronizer = intentSynchronizationService;
    }

    protected void unbindIntentSynchronizer(IntentSynchronizationService intentSynchronizationService) {
        if (this.intentSynchronizer == intentSynchronizationService) {
            this.intentSynchronizer = null;
        }
    }

    protected void bindConfig(ReactiveRoutingConfigurationService reactiveRoutingConfigurationService) {
        this.config = reactiveRoutingConfigurationService;
    }

    protected void unbindConfig(ReactiveRoutingConfigurationService reactiveRoutingConfigurationService) {
        if (this.config == reactiveRoutingConfigurationService) {
            this.config = null;
        }
    }

    protected void bindInterfaceService(InterfaceService interfaceService) {
        this.interfaceService = interfaceService;
    }

    protected void unbindInterfaceService(InterfaceService interfaceService) {
        if (this.interfaceService == interfaceService) {
            this.interfaceService = null;
        }
    }

    protected void bindHostService(HostService hostService) {
        this.hostService = hostService;
    }

    protected void unbindHostService(HostService hostService) {
        if (this.hostService == hostService) {
            this.hostService = null;
        }
    }

    private class ReactiveRoutingProcessor
    implements PacketProcessor {
        private ReactiveRoutingProcessor() {
        }

        public void process(PacketContext context) {
            InboundPacket pkt = context.inPacket();
            Ethernet ethPkt = pkt.parsed();
            if (ethPkt == null) {
                return;
            }
            ConnectPoint srcConnectPoint = pkt.receivedFrom();
            switch (EthType.EtherType.lookup((short)ethPkt.getEtherType())) {
                case ARP: {
                    MacAddress gatewayMacAddress;
                    ARP arpPacket = (ARP)ethPkt.getPayload();
                    Ip4Address targetIpAddress = Ip4Address.valueOf((byte[])arpPacket.getTargetProtocolAddress());
                    if (arpPacket.getOpCode() != 1 || !SdnIpReactiveRouting.this.config.isVirtualGatewayIpAddress((IpAddress)targetIpAddress) || (gatewayMacAddress = SdnIpReactiveRouting.this.config.getVirtualGatewayMacAddress()) == null) break;
                    Ethernet eth = ARP.buildArpReply((Ip4Address)targetIpAddress, (MacAddress)gatewayMacAddress, (Ethernet)ethPkt);
                    TrafficTreatment.Builder builder = DefaultTrafficTreatment.builder();
                    builder.setOutput(srcConnectPoint.port());
                    SdnIpReactiveRouting.this.packetService.emit((OutboundPacket)new DefaultOutboundPacket(srcConnectPoint.deviceId(), builder.build(), ByteBuffer.wrap(eth.serialize())));
                    break;
                }
                case IPV4: {
                    IPv4 ipv4Packet = (IPv4)ethPkt.getPayload();
                    IpAddress dstIp = IpAddress.valueOf((int)ipv4Packet.getDestinationAddress());
                    IpAddress srcIp = IpAddress.valueOf((int)ipv4Packet.getSourceAddress());
                    MacAddress srcMac = ethPkt.getSourceMAC();
                    SdnIpReactiveRouting.this.packetReactiveProcessor(dstIp, srcIp, srcConnectPoint, srcMac);
                    ConnectPoint egressConnectPoint = null;
                    egressConnectPoint = SdnIpReactiveRouting.this.getEgressConnectPoint(dstIp);
                    if (egressConnectPoint == null) break;
                    SdnIpReactiveRouting.this.forwardPacketToDst(context, egressConnectPoint);
                    break;
                }
            }
        }
    }
}

