/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.reactive.routing;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.onlab.packet.Ethernet;
import org.onlab.packet.IpAddress;
import org.onlab.packet.IpPrefix;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onosproject.core.ApplicationId;
import org.onosproject.incubator.net.intf.Interface;
import org.onosproject.incubator.net.intf.InterfaceService;
import org.onosproject.intentsync.IntentSynchronizationService;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.Host;
import org.onosproject.net.HostLocation;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.host.HostService;
import org.onosproject.net.intent.Constraint;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.Key;
import org.onosproject.net.intent.MultiPointToSinglePointIntent;
import org.onosproject.net.intent.constraint.PartialFailureConstraint;
import org.onosproject.reactive.routing.IntentRequestListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReactiveRoutingFib
implements IntentRequestListener {
    private static final int PRIORITY_OFFSET = 100;
    private static final int PRIORITY_MULTIPLIER = 5;
    protected static final ImmutableList<Constraint> CONSTRAINTS = ImmutableList.of((Object)new PartialFailureConstraint());
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ApplicationId appId;
    private final HostService hostService;
    private final InterfaceService interfaceService;
    private final IntentSynchronizationService intentSynchronizer;
    private final Map<IpPrefix, MultiPointToSinglePointIntent> routeIntents;

    public ReactiveRoutingFib(ApplicationId appId, HostService hostService, InterfaceService interfaceService, IntentSynchronizationService intentSynchronizer) {
        this.appId = appId;
        this.hostService = hostService;
        this.interfaceService = interfaceService;
        this.intentSynchronizer = intentSynchronizer;
        this.routeIntents = Maps.newConcurrentMap();
    }

    @Override
    public void setUpConnectivityInternetToHost(IpAddress hostIpAddress) {
        Preconditions.checkNotNull((Object)hostIpAddress);
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        if (hostIpAddress.isIp4()) {
            selector.matchEthType(Ethernet.TYPE_IPV4);
        } else {
            selector.matchEthType(Ethernet.TYPE_IPV6);
        }
        IpPrefix ipPrefix = hostIpAddress.toIpPrefix();
        selector.matchIPDst(ipPrefix);
        MacAddress hostMac = null;
        HostLocation egressPoint = null;
        for (Host host : this.hostService.getHostsByIp(hostIpAddress)) {
            if (host.mac() == null) continue;
            hostMac = host.mac();
            egressPoint = host.location();
            break;
        }
        if (hostMac == null) {
            this.hostService.startMonitoringIp(hostIpAddress);
            return;
        }
        TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder().setEthDst(hostMac);
        Key key = Key.of((String)ipPrefix.toString(), (ApplicationId)this.appId);
        int priority = ipPrefix.prefixLength() * 5 + 100;
        Set interfaceConnectPoints = this.interfaceService.getInterfaces().stream().map(intf -> intf.connectPoint()).collect(Collectors.toSet());
        if (interfaceConnectPoints.isEmpty()) {
            this.log.error("The interface connect points are empty!");
            return;
        }
        HashSet<ConnectPoint> ingressPoints = new HashSet<ConnectPoint>();
        for (ConnectPoint connectPoint : interfaceConnectPoints) {
            if (connectPoint.equals((Object)egressPoint)) continue;
            ingressPoints.add(connectPoint);
        }
        MultiPointToSinglePointIntent intent = MultiPointToSinglePointIntent.builder().appId(this.appId).key(key).selector(selector.build()).treatment(treatment.build()).ingressPoints(ingressPoints).egressPoint((ConnectPoint)egressPoint).priority(priority).constraints(CONSTRAINTS).build();
        this.log.trace("Generates ConnectivityInternetToHost intent {}", (Object)intent);
        this.submitReactiveIntent(ipPrefix, intent);
    }

    @Override
    public void setUpConnectivityHostToInternet(IpAddress hostIp, IpPrefix prefix, IpAddress nextHopIpAddress) {
        Interface egressInterface = this.interfaceService.getMatchingInterface(nextHopIpAddress);
        if (egressInterface == null) {
            this.log.warn("No outgoing interface found for {}", (Object)nextHopIpAddress);
            return;
        }
        Set hosts = this.hostService.getHostsByIp(nextHopIpAddress);
        if (hosts.isEmpty()) {
            this.log.warn("No host found for next hop IP address");
            return;
        }
        MacAddress nextHopMacAddress = null;
        Iterator iterator = hosts.iterator();
        if (iterator.hasNext()) {
            Host host = (Host)iterator.next();
            nextHopMacAddress = host.mac();
        }
        if ((hosts = this.hostService.getHostsByIp(hostIp)).isEmpty()) {
            this.log.warn("No host found for host IP address");
            return;
        }
        Host host = (Host)hosts.stream().findFirst().get();
        HostLocation ingressPoint = host.location();
        ConnectPoint egressPort = egressInterface.connectPoint();
        this.log.debug("Generating intent for prefix {}, next hop mac {}", (Object)prefix, (Object)nextHopMacAddress);
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        if (prefix.isIp4()) {
            selector.matchEthType(Ethernet.TYPE_IPV4);
            selector.matchIPDst(prefix);
        } else {
            selector.matchEthType(Ethernet.TYPE_IPV6);
            selector.matchIPv6Dst(prefix);
        }
        TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder().setEthDst(nextHopMacAddress);
        if (!egressInterface.vlan().equals((Object)VlanId.NONE)) {
            treatment.setVlanId(egressInterface.vlan());
            selector.matchVlanId(VlanId.ANY);
        }
        int priority = prefix.prefixLength() * 5 + 100;
        Key key = Key.of((String)(prefix.toString() + "-reactive"), (ApplicationId)this.appId);
        MultiPointToSinglePointIntent intent = MultiPointToSinglePointIntent.builder().appId(this.appId).key(key).selector(selector.build()).treatment(treatment.build()).ingressPoints(Collections.singleton(ingressPoint)).egressPoint(egressPort).priority(priority).constraints(CONSTRAINTS).build();
        this.submitReactiveIntent(prefix, intent);
    }

    @Override
    public void setUpConnectivityHostToHost(IpAddress dstIpAddress, IpAddress srcIpAddress, MacAddress srcMacAddress, ConnectPoint srcConnectPoint) {
        Preconditions.checkNotNull((Object)dstIpAddress);
        Preconditions.checkNotNull((Object)srcIpAddress);
        Preconditions.checkNotNull((Object)srcMacAddress);
        Preconditions.checkNotNull((Object)srcConnectPoint);
        IpPrefix srcIpPrefix = srcIpAddress.toIpPrefix();
        IpPrefix dstIpPrefix = dstIpAddress.toIpPrefix();
        HostLocation dstConnectPoint = null;
        MacAddress dstMacAddress = null;
        for (Host host : this.hostService.getHostsByIp(dstIpAddress)) {
            if (host.mac() == null) continue;
            dstMacAddress = host.mac();
            dstConnectPoint = host.location();
            break;
        }
        if (dstMacAddress == null) {
            this.hostService.startMonitoringIp(dstIpAddress);
            return;
        }
        MultiPointToSinglePointIntent srcToDstIntent = this.hostToHostIntentGenerator(dstIpAddress, (ConnectPoint)dstConnectPoint, dstMacAddress, srcConnectPoint);
        this.submitReactiveIntent(dstIpPrefix, srcToDstIntent);
        if (this.mp2pIntentExists(srcIpPrefix)) {
            this.updateExistingMp2pIntent(srcIpPrefix, (ConnectPoint)dstConnectPoint);
            return;
        }
        MultiPointToSinglePointIntent dstToSrcIntent = this.hostToHostIntentGenerator(srcIpAddress, srcConnectPoint, srcMacAddress, (ConnectPoint)dstConnectPoint);
        this.submitReactiveIntent(srcIpPrefix, dstToSrcIntent);
    }

    private MultiPointToSinglePointIntent hostToHostIntentGenerator(IpAddress dstIpAddress, ConnectPoint dstConnectPoint, MacAddress dstMacAddress, ConnectPoint srcConnectPoint) {
        Preconditions.checkNotNull((Object)dstIpAddress);
        Preconditions.checkNotNull((Object)dstConnectPoint);
        Preconditions.checkNotNull((Object)dstMacAddress);
        Preconditions.checkNotNull((Object)srcConnectPoint);
        HashSet<ConnectPoint> ingressPoints = new HashSet<ConnectPoint>();
        ingressPoints.add(srcConnectPoint);
        IpPrefix dstIpPrefix = dstIpAddress.toIpPrefix();
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        if (dstIpAddress.isIp4()) {
            selector.matchEthType(Ethernet.TYPE_IPV4);
            selector.matchIPDst(dstIpPrefix);
        } else {
            selector.matchEthType(Ethernet.TYPE_IPV6);
            selector.matchIPv6Dst(dstIpPrefix);
        }
        TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder().setEthDst(dstMacAddress);
        Key key = Key.of((String)dstIpPrefix.toString(), (ApplicationId)this.appId);
        int priority = dstIpPrefix.prefixLength() * 5 + 100;
        MultiPointToSinglePointIntent intent = MultiPointToSinglePointIntent.builder().appId(this.appId).key(key).selector(selector.build()).treatment(treatment.build()).ingressPoints(ingressPoints).egressPoint(dstConnectPoint).priority(priority).constraints(CONSTRAINTS).build();
        this.log.trace("Generates ConnectivityHostToHost = {} ", (Object)intent);
        return intent;
    }

    @Override
    public void updateExistingMp2pIntent(IpPrefix ipPrefix, ConnectPoint ingressConnectPoint) {
        Set ingressPoints;
        Preconditions.checkNotNull((Object)ipPrefix);
        Preconditions.checkNotNull((Object)ingressConnectPoint);
        MultiPointToSinglePointIntent existingIntent = this.getExistingMp2pIntent(ipPrefix);
        if (existingIntent != null && (ingressPoints = existingIntent.ingressPoints()).add(ingressConnectPoint)) {
            MultiPointToSinglePointIntent updatedMp2pIntent = MultiPointToSinglePointIntent.builder().appId(this.appId).key(existingIntent.key()).selector(existingIntent.selector()).treatment(existingIntent.treatment()).ingressPoints(ingressPoints).egressPoint(existingIntent.egressPoint()).priority(existingIntent.priority()).constraints(CONSTRAINTS).build();
            this.log.trace("Update an existing MultiPointToSinglePointIntent to new intent = {} ", (Object)updatedMp2pIntent);
            this.submitReactiveIntent(ipPrefix, updatedMp2pIntent);
        }
    }

    void submitReactiveIntent(IpPrefix ipPrefix, MultiPointToSinglePointIntent intent) {
        this.routeIntents.put(ipPrefix, intent);
        this.intentSynchronizer.submit((Intent)intent);
    }

    private MultiPointToSinglePointIntent getExistingMp2pIntent(IpPrefix ipPrefix) {
        Preconditions.checkNotNull((Object)ipPrefix);
        return this.routeIntents.get(ipPrefix);
    }

    @Override
    public boolean mp2pIntentExists(IpPrefix ipPrefix) {
        Preconditions.checkNotNull((Object)ipPrefix);
        return this.routeIntents.get(ipPrefix) != null;
    }
}

