/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.reactive.routing;

import com.google.common.collect.ImmutableSet;
import com.googlecode.concurrenttrees.radix.node.NodeFactory;
import com.googlecode.concurrenttrees.radix.node.concrete.DefaultByteArrayNodeFactory;
import com.googlecode.concurrenttrees.radixinverted.ConcurrentInvertedRadixTree;
import com.googlecode.concurrenttrees.radixinverted.InvertedRadixTree;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.packet.IpAddress;
import org.onlab.packet.IpPrefix;
import org.onlab.packet.MacAddress;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.event.EventListener;
import org.onosproject.incubator.net.intf.InterfaceService;
import org.onosproject.incubator.net.routing.RouteTools;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.config.ConfigFactory;
import org.onosproject.net.config.NetworkConfigEvent;
import org.onosproject.net.config.NetworkConfigListener;
import org.onosproject.net.config.NetworkConfigRegistry;
import org.onosproject.net.config.NetworkConfigService;
import org.onosproject.net.config.basics.SubjectFactories;
import org.onosproject.reactive.routing.LocalIpPrefixEntry;
import org.onosproject.reactive.routing.ReactiveRoutingConfig;
import org.onosproject.reactive.routing.ReactiveRoutingConfigurationService;
import org.onosproject.routing.config.BgpConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class ReactiveRoutingConfiguration
implements ReactiveRoutingConfigurationService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected NetworkConfigRegistry registry;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected NetworkConfigService configService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected InterfaceService interfaceService;
    private Set<IpAddress> gatewayIpAddresses = new HashSet<IpAddress>();
    private Set<ConnectPoint> bgpPeerConnectPoints = new HashSet<ConnectPoint>();
    private InvertedRadixTree<LocalIpPrefixEntry> localPrefixTable4 = new ConcurrentInvertedRadixTree((NodeFactory)new DefaultByteArrayNodeFactory());
    private InvertedRadixTree<LocalIpPrefixEntry> localPrefixTable6 = new ConcurrentInvertedRadixTree((NodeFactory)new DefaultByteArrayNodeFactory());
    private MacAddress virtualGatewayMacAddress;
    private final InternalNetworkConfigListener configListener = new InternalNetworkConfigListener();
    private ConfigFactory<ApplicationId, ReactiveRoutingConfig> reactiveRoutingConfigFactory = new ConfigFactory<ApplicationId, ReactiveRoutingConfig>(SubjectFactories.APP_SUBJECT_FACTORY, ReactiveRoutingConfig.class, "reactiveRouting"){

        public ReactiveRoutingConfig createConfig() {
            return new ReactiveRoutingConfig();
        }
    };

    @Activate
    public void activate() {
        this.configService.addListener((EventListener)this.configListener);
        this.registry.registerConfigFactory(this.reactiveRoutingConfigFactory);
        this.setUpConfiguration();
        this.log.info("Reactive routing configuration service started");
    }

    @Deactivate
    public void deactivate() {
        this.registry.unregisterConfigFactory(this.reactiveRoutingConfigFactory);
        this.configService.removeListener((EventListener)this.configListener);
        this.log.info("Reactive routing configuration service stopped");
    }

    private void setUpConfiguration() {
        ReactiveRoutingConfig config = (ReactiveRoutingConfig)this.configService.getConfig((Object)this.coreService.registerApplication("org.onosproject.reactive.routing"), ReactiveRoutingConfigurationService.CONFIG_CLASS);
        if (config == null) {
            this.log.warn("No reactive routing config available!");
            return;
        }
        for (LocalIpPrefixEntry entry : config.localIp4PrefixEntries()) {
            this.localPrefixTable4.put((CharSequence)RouteTools.createBinaryString((IpPrefix)entry.ipPrefix()), (Object)entry);
            this.gatewayIpAddresses.add(entry.getGatewayIpAddress());
        }
        for (LocalIpPrefixEntry entry : config.localIp6PrefixEntries()) {
            this.localPrefixTable6.put((CharSequence)RouteTools.createBinaryString((IpPrefix)entry.ipPrefix()), (Object)entry);
            this.gatewayIpAddresses.add(entry.getGatewayIpAddress());
        }
        this.virtualGatewayMacAddress = config.virtualGatewayMacAddress();
        ApplicationId routerAppId = this.coreService.getAppId("org.onosproject.router");
        if (routerAppId == null) {
            this.log.info("Router application ID is null!");
            return;
        }
        BgpConfig bgpConfig = (BgpConfig)this.configService.getConfig((Object)routerAppId, BgpConfig.class);
        if (bgpConfig == null) {
            this.log.info("BGP config is null!");
            return;
        }
        this.bgpPeerConnectPoints = bgpConfig.bgpSpeakers().stream().flatMap(speaker -> speaker.peers().stream()).map(peer -> this.interfaceService.getMatchingInterface(peer)).filter(Objects::nonNull).map(intf -> intf.connectPoint()).collect(Collectors.toSet());
    }

    @Override
    public boolean isIpAddressLocal(IpAddress ipAddress) {
        if (ipAddress.isIp4()) {
            return this.localPrefixTable4.getValuesForKeysPrefixing((CharSequence)RouteTools.createBinaryString((IpPrefix)IpPrefix.valueOf((IpAddress)ipAddress, (int)32))).iterator().hasNext();
        }
        return this.localPrefixTable6.getValuesForKeysPrefixing((CharSequence)RouteTools.createBinaryString((IpPrefix)IpPrefix.valueOf((IpAddress)ipAddress, (int)128))).iterator().hasNext();
    }

    @Override
    public boolean isIpPrefixLocal(IpPrefix ipPrefix) {
        return this.localPrefixTable4.getValueForExactKey((CharSequence)RouteTools.createBinaryString((IpPrefix)ipPrefix)) != null || this.localPrefixTable6.getValueForExactKey((CharSequence)RouteTools.createBinaryString((IpPrefix)ipPrefix)) != null;
    }

    @Override
    public boolean isVirtualGatewayIpAddress(IpAddress ipAddress) {
        return this.gatewayIpAddresses.contains(ipAddress);
    }

    @Override
    public MacAddress getVirtualGatewayMacAddress() {
        return this.virtualGatewayMacAddress;
    }

    @Override
    public Set<ConnectPoint> getBgpPeerConnectPoints() {
        return ImmutableSet.copyOf(this.bgpPeerConnectPoints);
    }

    protected void bindRegistry(NetworkConfigRegistry networkConfigRegistry) {
        this.registry = networkConfigRegistry;
    }

    protected void unbindRegistry(NetworkConfigRegistry networkConfigRegistry) {
        if (this.registry == networkConfigRegistry) {
            this.registry = null;
        }
    }

    protected void bindConfigService(NetworkConfigService networkConfigService) {
        this.configService = networkConfigService;
    }

    protected void unbindConfigService(NetworkConfigService networkConfigService) {
        if (this.configService == networkConfigService) {
            this.configService = null;
        }
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindInterfaceService(InterfaceService interfaceService) {
        this.interfaceService = interfaceService;
    }

    protected void unbindInterfaceService(InterfaceService interfaceService) {
        if (this.interfaceService == interfaceService) {
            this.interfaceService = null;
        }
    }

    private class InternalNetworkConfigListener
    implements NetworkConfigListener {
        private InternalNetworkConfigListener() {
        }

        public void event(NetworkConfigEvent event) {
            switch ((NetworkConfigEvent.Type)event.type()) {
                case CONFIG_REGISTERED: {
                    break;
                }
                case CONFIG_UNREGISTERED: {
                    break;
                }
                case CONFIG_ADDED: 
                case CONFIG_UPDATED: 
                case CONFIG_REMOVED: {
                    if (event.configClass() != ReactiveRoutingConfigurationService.CONFIG_CLASS) break;
                    ReactiveRoutingConfiguration.this.setUpConfiguration();
                    break;
                }
            }
        }
    }
}

