/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.reactive.routing;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import org.onlab.packet.IpAddress;
import org.onlab.packet.IpPrefix;
import org.onlab.packet.MacAddress;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.config.Config;
import org.onosproject.reactive.routing.LocalIpPrefixEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReactiveRoutingConfig
extends Config<ApplicationId> {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    public static final String IP4LOCALPREFIXES = "ip4LocalPrefixes";
    public static final String IP6LOCALPREFIXES = "ip6LocalPrefixes";
    public static final String IPPREFIX = "ipPrefix";
    public static final String TYPE = "type";
    public static final String GATEWAYIP = "gatewayIp";
    public static final String VIRTUALGATEWAYMACADDRESS = "virtualGatewayMacAddress";

    public Set<LocalIpPrefixEntry> localIp4PrefixEntries() {
        HashSet prefixes = Sets.newHashSet();
        JsonNode prefixesNode = this.object.get(IP4LOCALPREFIXES);
        if (prefixesNode == null) {
            this.log.warn("ip4LocalPrefixes is null!");
            return prefixes;
        }
        prefixesNode.forEach(jsonNode -> prefixes.add(new LocalIpPrefixEntry(IpPrefix.valueOf((String)jsonNode.get(IPPREFIX).asText()), LocalIpPrefixEntry.IpPrefixType.valueOf(jsonNode.get(TYPE).asText()), IpAddress.valueOf((String)jsonNode.get(GATEWAYIP).asText()))));
        return prefixes;
    }

    public Set<LocalIpPrefixEntry> localIp6PrefixEntries() {
        HashSet prefixes = Sets.newHashSet();
        JsonNode prefixesNode = this.object.get(IP6LOCALPREFIXES);
        if (prefixesNode == null) {
            this.log.warn("ip6LocalPrefixes is null!");
            return prefixes;
        }
        prefixesNode.forEach(jsonNode -> prefixes.add(new LocalIpPrefixEntry(IpPrefix.valueOf((String)jsonNode.get(IPPREFIX).asText()), LocalIpPrefixEntry.IpPrefixType.valueOf(jsonNode.get(TYPE).asText()), IpAddress.valueOf((String)jsonNode.get(GATEWAYIP).asText()))));
        return prefixes;
    }

    public MacAddress virtualGatewayMacAddress() {
        return MacAddress.valueOf((String)this.object.get(VIRTUALGATEWAYMACADDRESS).asText());
    }
}

