/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.reactive.routing;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.onlab.packet.IpAddress;
import org.onlab.packet.IpPrefix;

public class LocalIpPrefixEntry {
    private final IpPrefix ipPrefix;
    private final IpPrefixType type;
    private final IpAddress gatewayIpAddress;

    public LocalIpPrefixEntry(IpPrefix ipPrefix, IpPrefixType type, IpAddress gatewayIpAddress) {
        this.ipPrefix = ipPrefix;
        this.type = type;
        this.gatewayIpAddress = gatewayIpAddress;
    }

    public IpPrefix ipPrefix() {
        return this.ipPrefix;
    }

    public IpPrefixType ipPrefixType() {
        return this.type;
    }

    public IpAddress getGatewayIpAddress() {
        return this.gatewayIpAddress;
    }

    public boolean isIp4() {
        return this.ipPrefix.isIp4();
    }

    public boolean isIp6() {
        return this.ipPrefix.isIp6();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.ipPrefix, this.type});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LocalIpPrefixEntry)) {
            return false;
        }
        LocalIpPrefixEntry that = (LocalIpPrefixEntry)obj;
        return Objects.equals(this.ipPrefix, that.ipPrefix) && Objects.equals((Object)this.type, (Object)that.type);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("ipPrefix", (Object)this.ipPrefix).add("ipPrefixType", (Object)this.type).toString();
    }

    public static enum IpPrefixType {
        PUBLIC,
        PRIVATE,
        BLACK_LIST;

    }
}

