/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.castor;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.packet.IpAddress;
import org.onlab.packet.MacAddress;
import org.onlab.util.KryoNamespace;
import org.onosproject.castor.CastorStore;
import org.onosproject.castor.Peer;
import org.onosproject.net.intent.Key;
import org.onosproject.net.intent.MultiPointToSinglePointIntent;
import org.onosproject.net.intent.PointToPointIntent;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.AsyncDistributedSet;
import org.onosproject.store.service.ConsistentMap;
import org.onosproject.store.service.ConsistentMapBuilder;
import org.onosproject.store.service.DistributedSet;
import org.onosproject.store.service.DistributedSetBuilder;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.StorageService;
import org.onosproject.store.service.Versioned;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class DistributedCastorStore
implements CastorStore {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StorageService storageService;
    private ConsistentMap<IpAddress, MacAddress> addressMap;
    private ConsistentMap<Key, PointToPointIntent> peerIntents;
    private ConsistentMap<String, MultiPointToSinglePointIntent> layer2Intents;
    private DistributedSet<Peer> allPeers;
    private DistributedSet<Peer> customers;
    private DistributedSet<Peer> routeServers;

    @Activate
    protected void activate() {
        this.addressMap = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withName("castor-addressMap")).withSerializer(Serializer.using((KryoNamespace)KryoNamespaces.API))).build();
        this.peerIntents = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withName("castor-peerIntents")).withSerializer(Serializer.using((KryoNamespace)KryoNamespaces.API))).build();
        this.layer2Intents = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withName("castor-layer2Intents")).withSerializer(Serializer.using((KryoNamespace)KryoNamespaces.API))).build();
        this.allPeers = ((AsyncDistributedSet)((DistributedSetBuilder)((DistributedSetBuilder)this.storageService.setBuilder().withName("castor-allPeers")).withSerializer(Serializer.using((KryoNamespace)new KryoNamespace.Builder().register(KryoNamespaces.API).register(new Class[]{Peer.class}).build()))).build()).asDistributedSet();
        this.customers = ((AsyncDistributedSet)((DistributedSetBuilder)((DistributedSetBuilder)this.storageService.setBuilder().withName("castor-customers")).withSerializer(Serializer.using((KryoNamespace)new KryoNamespace.Builder().register(KryoNamespaces.API).register(new Class[]{Peer.class}).build()))).build()).asDistributedSet();
        this.routeServers = ((AsyncDistributedSet)((DistributedSetBuilder)((DistributedSetBuilder)this.storageService.setBuilder().withName("castor-routeServers")).withSerializer(Serializer.using((KryoNamespace)new KryoNamespace.Builder().register(KryoNamespaces.API).register(new Class[]{Peer.class}).build()))).build()).asDistributedSet();
        this.log.info("Started");
    }

    @Deactivate
    protected void deactivate() {
    }

    public Set<Peer> getAllPeers() {
        return ImmutableSet.copyOf((Collection)this.allPeers);
    }

    public void storePeer(Peer peer) {
        this.allPeers.add((Object)peer);
    }

    public Set<Peer> getServers() {
        return ImmutableSet.copyOf((Collection)this.routeServers);
    }

    public void storeServer(Peer server) {
        this.routeServers.add((Object)server);
    }

    public Set<Peer> getCustomers() {
        return ImmutableSet.copyOf((Collection)this.customers);
    }

    public void storeCustomer(Peer customer) {
        this.customers.add((Object)customer);
    }

    public Map<IpAddress, MacAddress> getAddressMap() {
        HashMap<IpAddress, MacAddress> validMapping = new HashMap<IpAddress, MacAddress>();
        for (Map.Entry entry : this.addressMap.entrySet()) {
            validMapping.put((IpAddress)entry.getKey(), (MacAddress)((Versioned)entry.getValue()).value());
        }
        return validMapping;
    }

    public void setAddressMap(IpAddress ip, MacAddress mac) {
        this.addressMap.put((Object)ip, (Object)mac);
    }

    public Map<Key, PointToPointIntent> getPeerIntents() {
        HashMap<Key, PointToPointIntent> validMapping = new HashMap<Key, PointToPointIntent>();
        for (Map.Entry entry : this.peerIntents.entrySet()) {
            validMapping.put((Key)entry.getKey(), (PointToPointIntent)((Versioned)entry.getValue()).value());
        }
        return validMapping;
    }

    public void storePeerIntent(Key key, PointToPointIntent intent) {
        this.peerIntents.put((Object)key, (Object)intent);
    }

    public Map<String, MultiPointToSinglePointIntent> getLayer2Intents() {
        HashMap<String, MultiPointToSinglePointIntent> validMapping = new HashMap<String, MultiPointToSinglePointIntent>();
        for (Map.Entry entry : this.layer2Intents.entrySet()) {
            validMapping.put((String)entry.getKey(), (MultiPointToSinglePointIntent)((Versioned)entry.getValue()).value());
        }
        return validMapping;
    }

    public void storeLayer2Intent(String key, MultiPointToSinglePointIntent intent) {
        this.layer2Intents.put((Object)key, (Object)intent);
    }

    public Map<String, String> getCustomersMap() {
        HashMap<String, String> peerMap = new HashMap<String, String>();
        for (Peer cust : this.customers) {
            peerMap.put(cust.getName(), cust.getIpAddress());
        }
        return peerMap;
    }

    public void removeCustomer(Peer peer) {
        this.customers.remove((Object)peer);
        this.allPeers.remove((Object)peer);
    }

    public void removePeerIntent(Key key) {
        this.peerIntents.remove((Object)key);
    }

    public void removeLayer2Intent(String key) {
        this.layer2Intents.remove((Object)key);
    }

    protected void bindStorageService(StorageService storageService) {
        this.storageService = storageService;
    }

    protected void unbindStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
        }
    }
}

