/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.castor;

import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.Set;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.packet.ARP;
import org.onlab.packet.Ethernet;
import org.onlab.packet.IPacket;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.IpAddress;
import org.onlab.packet.MacAddress;
import org.onosproject.castor.ArpService;
import org.onosproject.castor.CastorArpManager;
import org.onosproject.castor.CastorStore;
import org.onosproject.castor.ConnectivityManagerService;
import org.onosproject.castor.Peer;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.packet.DefaultOutboundPacket;
import org.onosproject.net.packet.InboundPacket;
import org.onosproject.net.packet.OutboundPacket;
import org.onosproject.net.packet.PacketContext;
import org.onosproject.net.packet.PacketPriority;
import org.onosproject.net.packet.PacketProcessor;
import org.onosproject.net.packet.PacketService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, enabled=true)
@Service
public class CastorArpManager
implements ArpService {
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ConnectivityManagerService connectivityManager;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected PacketService packetService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CastorStore castorStore;
    private ProxyArpProcessor processor = new ProxyArpProcessor(this, null);
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final int FLOW_PRIORITY = 500;
    private static final MacAddress ARP_SOURCEMAC = MacAddress.valueOf((String)"00:00:00:00:00:01");
    private static final MacAddress ARP_DEST = MacAddress.valueOf((String)"00:00:00:00:00:00");
    private static final byte[] ZERO_MAC_ADDRESS = MacAddress.ZERO.toBytes();
    private static final IpAddress ARP_SRC = Ip4Address.valueOf((String)"0.0.0.0");
    private ApplicationId appId;
    Optional<DeviceId> deviceID = null;

    @Activate
    public void activate() {
        this.appId = this.coreService.getAppId("org.onosproject.castor");
        this.packetService.addProcessor((PacketProcessor)this.processor, PacketProcessor.director((int)1));
        this.requestPackets();
    }

    @Deactivate
    public void deactivate() {
        this.withdrawIntercepts();
        this.packetService.removeProcessor((PacketProcessor)this.processor);
        this.processor = null;
    }

    private void requestPackets() {
        TrafficSelector.Builder selectorBuilder = DefaultTrafficSelector.builder();
        selectorBuilder.matchEthType(Ethernet.TYPE_ARP);
        this.packetService.requestPackets(selectorBuilder.build(), PacketPriority.CONTROL, this.appId);
    }

    private void withdrawIntercepts() {
        TrafficSelector.Builder selectorBuilder = DefaultTrafficSelector.builder();
        selectorBuilder.matchEthType(Ethernet.TYPE_ARP);
        this.packetService.cancelPackets(selectorBuilder.build(), PacketPriority.CONTROL, this.appId, this.deviceID);
    }

    private void forward(MessageContext context) {
        TrafficTreatment.Builder builder = null;
        Ethernet eth = context.packet();
        ByteBuffer buf = ByteBuffer.wrap(eth.serialize());
        IpAddress target = context.target();
        String value = this.getMatchingConnectPoint(target);
        if (value != null) {
            ConnectPoint connectPoint = ConnectPoint.deviceConnectPoint((String)value);
            builder = DefaultTrafficTreatment.builder();
            builder.setOutput(connectPoint.port());
            this.packetService.emit((OutboundPacket)new DefaultOutboundPacket(connectPoint.deviceId(), builder.build(), buf));
        }
    }

    public void createArp(Peer peer) {
        Ethernet packet = null;
        packet = this.buildArpRequest(peer);
        ByteBuffer buf = ByteBuffer.wrap(packet.serialize());
        ConnectPoint connectPoint = ConnectPoint.deviceConnectPoint((String)peer.getPort());
        TrafficTreatment.Builder builder = DefaultTrafficTreatment.builder();
        builder.setOutput(connectPoint.port());
        this.packetService.emit((OutboundPacket)new DefaultOutboundPacket(connectPoint.deviceId(), builder.build(), buf));
    }

    private Ethernet buildArpRequest(Peer peer) {
        ARP arp = new ARP();
        arp.setHardwareType((short)1).setHardwareAddressLength((byte)6).setProtocolType((short)2048).setProtocolAddressLength((byte)4).setOpCode((short)1);
        arp.setSenderHardwareAddress(ARP_SOURCEMAC.toBytes()).setSenderProtocolAddress(ARP_SRC.toOctets()).setTargetHardwareAddress(ZERO_MAC_ADDRESS).setTargetProtocolAddress(IpAddress.valueOf((String)peer.getIpAddress()).toOctets());
        Ethernet ethernet = new Ethernet();
        ethernet.setEtherType(Ethernet.TYPE_ARP).setDestinationMACAddress(MacAddress.BROADCAST).setSourceMACAddress(ARP_SOURCEMAC).setPayload((IPacket)arp);
        ethernet.setPad(true);
        return ethernet;
    }

    private String getMatchingConnectPoint(IpAddress target) {
        Set peers = this.castorStore.getAllPeers();
        for (Peer peer : peers) {
            IpAddress match = IpAddress.valueOf((String)peer.getIpAddress());
            if (!match.equals((Object)target)) continue;
            return peer.getPort();
        }
        return null;
    }

    private Peer getMatchingPeer(ConnectPoint connectPoint) {
        for (Peer peer : this.castorStore.getAllPeers()) {
            if (!connectPoint.equals((Object)ConnectPoint.deviceConnectPoint((String)peer.getPort()))) continue;
            return peer;
        }
        return null;
    }

    private Peer getMatchingCustomer(ConnectPoint connectPoint) {
        for (Peer peer : this.castorStore.getCustomers()) {
            if (!connectPoint.equals((Object)ConnectPoint.deviceConnectPoint((String)peer.getPort()))) continue;
            return peer;
        }
        return null;
    }

    private void updateMac(MessageContext context) {
        if (this.castorStore.getAddressMap().containsKey(context.sender())) {
            return;
        }
        Ethernet eth = context.packet();
        MacAddress macAddress = eth.getSourceMAC();
        IpAddress ipAddress = context.sender();
        this.castorStore.setAddressMap(ipAddress, macAddress);
    }

    private void handleArpForL2(MessageContext msgContext) {
        ConnectPoint cp = msgContext.inPort();
        Peer peer = this.getMatchingCustomer(cp);
        if (peer != null && !peer.getl2Status()) {
            this.connectivityManager.setUpL2(peer);
        }
    }

    public boolean handlePacket(PacketContext context) {
        InboundPacket pkt = context.inPacket();
        Ethernet ethPkt = pkt.parsed();
        if (ethPkt == null) {
            return false;
        }
        MessageContext msgContext = this.createContext(ethPkt, pkt.receivedFrom());
        if (msgContext == null) {
            return false;
        }
        switch (1.$SwitchMap$org$onosproject$castor$CastorArpManager$MessageType[msgContext.type().ordinal()]) {
            case 1: {
                this.forward(msgContext);
                this.updateMac(msgContext);
                this.handleArpForL2(msgContext);
                break;
            }
            case 2: {
                this.forward(msgContext);
                this.updateMac(msgContext);
                this.handleArpForL2(msgContext);
                break;
            }
            default: {
                return false;
            }
        }
        context.block();
        return true;
    }

    private MessageContext createContext(Ethernet eth, ConnectPoint inPort) {
        if (eth.getEtherType() == Ethernet.TYPE_ARP) {
            return this.createArpContext(eth, inPort);
        }
        return null;
    }

    private MessageContext createArpContext(Ethernet eth, ConnectPoint inPort) {
        MessageType type;
        if (eth.getEtherType() != Ethernet.TYPE_ARP) {
            return null;
        }
        ARP arp = (ARP)eth.getPayload();
        Ip4Address target = Ip4Address.valueOf((byte[])arp.getTargetProtocolAddress());
        Ip4Address sender = Ip4Address.valueOf((byte[])arp.getSenderProtocolAddress());
        if (arp.getOpCode() == 1) {
            type = MessageType.REQUEST;
        } else if (arp.getOpCode() == 2) {
            type = MessageType.REPLY;
        } else {
            return null;
        }
        return new MessageContext(this, eth, inPort, Protocol.ARP, type, (IpAddress)target, (IpAddress)sender);
    }

    protected void bindConnectivityManager(ConnectivityManagerService connectivityManagerService) {
        this.connectivityManager = connectivityManagerService;
    }

    protected void unbindConnectivityManager(ConnectivityManagerService connectivityManagerService) {
        if (this.connectivityManager == connectivityManagerService) {
            this.connectivityManager = null;
        }
    }

    protected void bindPacketService(PacketService packetService) {
        this.packetService = packetService;
    }

    protected void unbindPacketService(PacketService packetService) {
        if (this.packetService == packetService) {
            this.packetService = null;
        }
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindCastorStore(CastorStore castorStore) {
        this.castorStore = castorStore;
    }

    protected void unbindCastorStore(CastorStore castorStore) {
        if (this.castorStore == castorStore) {
            this.castorStore = null;
        }
    }
}

