/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.tl1.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.netty.channel.Channel;
import java.util.Objects;
import org.onlab.packet.IpAddress;
import org.onosproject.tl1.Tl1Device;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTl1Device
implements Tl1Device {
    private final Logger log = LoggerFactory.getLogger(DefaultTl1Device.class);
    private static final String TL1 = "tl1";
    private IpAddress ip;
    private int port;
    private String username;
    private String password;
    private String tid;
    private Channel channel;

    public void connect(Channel channel) {
        this.channel = channel;
    }

    public void disconnect() {
        this.channel = null;
    }

    public boolean isConnected() {
        return this.channel != null;
    }

    public IpAddress ip() {
        return this.ip;
    }

    public int port() {
        return this.port;
    }

    public String username() {
        return this.username;
    }

    public String password() {
        return this.password;
    }

    public Channel channel() {
        return this.channel;
    }

    public String tid() {
        return this.tid;
    }

    public DefaultTl1Device(IpAddress ip, int port, String username, String password) {
        this.ip = (IpAddress)Preconditions.checkNotNull((Object)ip);
        Preconditions.checkArgument((0 <= port && port <= 65535 ? 1 : 0) != 0);
        this.port = port;
        this.username = (String)Preconditions.checkNotNull((Object)username);
        this.password = (String)Preconditions.checkNotNull((Object)password);
        this.tid = null;
        this.channel = null;
    }

    public int hashCode() {
        return Objects.hash(this.ip, this.port, this.username, this.password);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultTl1Device) {
            DefaultTl1Device that = (DefaultTl1Device)obj;
            return Objects.equals(this.ip, that.ip) && Objects.equals(this.port, that.port) && Objects.equals(this.username, that.username) && Objects.equals(this.password, that.password) && Objects.equals(this.tid, that.tid) && Objects.equals(this.channel, that.channel);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("ip", (Object)this.ip).add("port", this.port).add("username", (Object)this.username).add("password", (Object)this.password).add("tid", (Object)(this.tid == null ? "N/A" : this.tid)).toString();
    }
}

