/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.tl1.impl;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.DelimiterBasedFrameDecoder;
import io.netty.handler.codec.string.StringDecoder;
import io.netty.util.CharsetUtil;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.Tools;
import org.onosproject.mastership.MastershipService;
import org.onosproject.net.DeviceId;
import org.onosproject.tl1.Tl1Command;
import org.onosproject.tl1.Tl1Controller;
import org.onosproject.tl1.Tl1Device;
import org.onosproject.tl1.Tl1Listener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class DefaultTl1Controller
implements Tl1Controller {
    private final Logger log = LoggerFactory.getLogger(DefaultTl1Controller.class);
    private static final ByteBuf DELIMITER = Unpooled.copiedBuffer((char[])new char[]{';'}, (Charset)Charset.defaultCharset());
    private static final String COMPLD = "COMPLD";
    private static final String DENY = "DENY";
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected MastershipService mastershipService;
    private ConcurrentMap<DeviceId, Tl1Device> deviceMap = new ConcurrentHashMap<DeviceId, Tl1Device>();
    private ConcurrentMap<Channel, ConcurrentMap<Integer, CompletableFuture<String>>> msgMap = new ConcurrentHashMap<Channel, ConcurrentMap<Integer, CompletableFuture<String>>>();
    private EventLoopGroup workerGroup = new NioEventLoopGroup();
    private Set<Tl1Listener> tl1Listeners = new CopyOnWriteArraySet<Tl1Listener>();
    private ExecutorService executor;

    @Activate
    public void activate() {
        this.executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors(), Tools.groupedThreads((String)"onos/tl1controller", (String)"%d", (Logger)this.log));
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.executor.shutdown();
        this.deviceMap.clear();
        this.msgMap.clear();
        this.log.info("Stopped");
    }

    public CompletableFuture<String> sendMsg(DeviceId deviceId, Tl1Command msg) {
        this.log.debug("Sending TL1 message to device {}: {}", (Object)deviceId, (Object)msg);
        Tl1Device device = (Tl1Device)this.deviceMap.get(deviceId);
        if (device == null || !device.isConnected() || !this.mastershipService.isLocalMaster(deviceId)) {
            return CompletableFuture.completedFuture("");
        }
        CompletableFuture<String> future = new CompletableFuture<String>();
        Channel channel = device.channel();
        if (!this.msgMap.containsKey(channel)) {
            return CompletableFuture.completedFuture("");
        }
        ((ConcurrentMap)this.msgMap.get(channel)).put(msg.ctag(), future);
        channel.writeAndFlush((Object)Unpooled.copiedBuffer((CharSequence)msg.toString(), (Charset)CharsetUtil.UTF_8));
        return future;
    }

    public Optional<Tl1Device> getDevice(DeviceId deviceId) {
        return Optional.ofNullable(this.deviceMap.get(deviceId));
    }

    public boolean addDevice(DeviceId deviceId, Tl1Device device) {
        this.log.debug("Adding TL1 device {} {}", (Object)deviceId);
        if (this.deviceMap.containsKey(deviceId)) {
            this.log.error("Ignoring duplicate device {}", (Object)deviceId);
            return false;
        }
        this.deviceMap.put(deviceId, device);
        return true;
    }

    public void connectDevice(DeviceId deviceId) {
        Tl1Device device = (Tl1Device)this.deviceMap.get(deviceId);
        if (device == null || device.isConnected()) {
            return;
        }
        Bootstrap b = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)b.group(this.workerGroup)).channel(NioSocketChannel.class)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel socketChannel) throws Exception {
                socketChannel.pipeline().addLast(new ChannelHandler[]{new DelimiterBasedFrameDecoder(8192, DELIMITER)});
                socketChannel.pipeline().addLast("stringDecoder", (ChannelHandler)new StringDecoder(CharsetUtil.UTF_8));
                socketChannel.pipeline().addLast(new ChannelHandler[]{new Tl1InboundHandler()});
            }
        })).remoteAddress(device.ip().toInetAddress(), device.port()).connect().addListener(channelFuture -> {
            if (channelFuture.isSuccess()) {
                this.msgMap.put(channelFuture.channel(), new ConcurrentHashMap());
                device.connect(channelFuture.channel());
                this.tl1Listeners.forEach(l -> this.executor.execute(() -> l.deviceConnected(deviceId)));
            }
        });
    }

    public void removeDevice(DeviceId deviceId) {
        this.disconnectDevice(deviceId);
        this.deviceMap.remove(deviceId);
    }

    public void addListener(Tl1Listener listener) {
        this.tl1Listeners.add(listener);
    }

    public void removeListener(Tl1Listener listener) {
        this.tl1Listeners.remove(listener);
    }

    public void disconnectDevice(DeviceId deviceId) {
        Tl1Device device = (Tl1Device)this.deviceMap.get(deviceId);
        if (device == null) {
            return;
        }
        Channel channel = device.channel();
        if (channel != null) {
            channel.close();
            this.msgMap.remove(channel);
        }
        device.disconnect();
        this.tl1Listeners.forEach(l -> l.deviceDisconnected(deviceId));
    }

    public Set<DeviceId> getDeviceIds() {
        return this.deviceMap.keySet();
    }

    public Collection<Tl1Device> getDevices() {
        return this.deviceMap.values();
    }

    protected void bindMastershipService(MastershipService mastershipService) {
        this.mastershipService = mastershipService;
    }

    protected void unbindMastershipService(MastershipService mastershipService) {
        if (this.mastershipService == mastershipService) {
            this.mastershipService = null;
        }
    }

    private class Tl1InboundHandler
    extends SimpleChannelInboundHandler<String> {
        private Tl1InboundHandler() {
        }

        protected void channelRead0(ChannelHandlerContext ctx, String s) throws Exception {
            DefaultTl1Controller.this.log.debug("Received TL1 message {}", (Object)s);
            String[] words = s.split("\\s");
            for (int i = 0; i < words.length; ++i) {
                CompletableFuture f;
                String w = words[i];
                if (!w.startsWith(DefaultTl1Controller.COMPLD) && !w.startsWith(DefaultTl1Controller.DENY)) continue;
                int ctag = Integer.parseInt(words[i - 1]);
                String result = Arrays.stream(words).skip(i + 1).collect(Collectors.joining());
                Map msg = (Map)DefaultTl1Controller.this.msgMap.get(ctx.channel());
                if (msg != null && (f = (CompletableFuture)msg.remove(ctag)) != null) {
                    f.complete(result);
                }
                return;
            }
        }
    }
}

