/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.tl1.impl;

import com.google.common.base.Preconditions;
import java.util.Optional;
import org.onosproject.tl1.Tl1Command;

public final class DefaultTl1Command
implements Tl1Command {
    private static final char HYPHEN = '-';
    private static final char COLON = ':';
    private static final char SEMICOLON = ';';
    private String verb;
    private String modifier;
    private Optional<String> tid;
    private String aid;
    private int ctag;
    private String parameters;

    private DefaultTl1Command(String verb, String modifier, String tid, String aid, int ctag, String parameters) {
        this.verb = verb;
        this.modifier = modifier;
        this.tid = Optional.ofNullable(tid);
        this.aid = aid;
        this.ctag = ctag;
        this.parameters = parameters;
    }

    public String verb() {
        return this.verb;
    }

    public String modifier() {
        return this.modifier;
    }

    public Optional<String> tid() {
        return this.tid;
    }

    public Optional<String> aid() {
        return Optional.ofNullable(this.aid);
    }

    public int ctag() {
        return this.ctag;
    }

    public Optional<String> parameters() {
        return Optional.ofNullable(this.parameters);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append(this.verb).append('-').append(this.modifier).append(':').append(this.tid().orElse("")).append(':').append(this.aid().orElse("")).append(':').append(this.ctag);
        if (this.parameters().isPresent()) {
            sb.append(':').append(':').append(this.parameters);
        }
        return sb.append(';').toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements Tl1Command.Builder {
        private String verb;
        private String modifier;
        private String tid;
        private String aid;
        private int ctag;
        private String parameters;

        public Tl1Command.Builder withVerb(String verb) {
            this.verb = verb;
            return this;
        }

        public Tl1Command.Builder withModifier(String modifier) {
            this.modifier = modifier;
            return this;
        }

        public Tl1Command.Builder forTid(String tid) {
            this.tid = tid;
            return this;
        }

        public Tl1Command.Builder withAid(String aid) {
            this.aid = aid;
            return this;
        }

        public Tl1Command.Builder withCtag(int ctag) {
            this.ctag = ctag;
            return this;
        }

        public Tl1Command.Builder withParameters(String parameters) {
            this.parameters = parameters;
            return this;
        }

        public Tl1Command build() {
            Preconditions.checkNotNull((Object)this.verb, (Object)"Must supply a verb");
            Preconditions.checkNotNull((Object)this.modifier, (Object)"Must supply a modifier");
            Preconditions.checkArgument((0 < this.ctag ? 1 : 0) != 0, (Object)"ctag cannot be less than 0");
            Preconditions.checkArgument((this.ctag <= 999999 ? 1 : 0) != 0, (Object)"ctag cannot be larger than 999999");
            return new DefaultTl1Command(this.verb, this.modifier, this.tid, this.aid, this.ctag, this.parameters);
        }
    }
}

