/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ovsdb.provider.host;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onlab.util.Tools;
import org.onosproject.core.CoreService;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Host;
import org.onosproject.net.HostId;
import org.onosproject.net.HostLocation;
import org.onosproject.net.PortNumber;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.host.DefaultHostDescription;
import org.onosproject.net.host.HostDescription;
import org.onosproject.net.host.HostProvider;
import org.onosproject.net.host.HostProviderRegistry;
import org.onosproject.net.host.HostProviderService;
import org.onosproject.net.host.HostService;
import org.onosproject.net.provider.AbstractProvider;
import org.onosproject.net.provider.Provider;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.ovsdb.controller.EventSubject;
import org.onosproject.ovsdb.controller.OvsdbController;
import org.onosproject.ovsdb.controller.OvsdbEvent;
import org.onosproject.ovsdb.controller.OvsdbEventListener;
import org.onosproject.ovsdb.controller.OvsdbEventSubject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class OvsdbHostProvider
extends AbstractProvider
implements HostProvider {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected HostProviderRegistry providerRegistry;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected HostService hostService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected OvsdbController controller;
    private HostProviderService providerService;
    private OvsdbEventListener innerEventListener = new InnerOvsdbEventListener();

    @Activate
    public void activate() {
        this.providerService = (HostProviderService)this.providerRegistry.register((Provider)this);
        this.controller.addOvsdbEventListener(this.innerEventListener);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.providerRegistry.unregister((Provider)this);
        this.providerService = null;
        this.log.info("Stopped");
    }

    public OvsdbHostProvider() {
        super(new ProviderId("ovsdb", "org.onosproject.ovsdb.provider.host"));
    }

    public void triggerProbe(Host host) {
        this.log.info("Triggering probe on host {}", (Object)host);
    }

    public URI uri(String value) {
        try {
            return new URI("of", Tools.toHex((long)Long.valueOf(value)), null);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    protected void bindProviderRegistry(HostProviderRegistry hostProviderRegistry) {
        this.providerRegistry = hostProviderRegistry;
    }

    protected void unbindProviderRegistry(HostProviderRegistry hostProviderRegistry) {
        if (this.providerRegistry == hostProviderRegistry) {
            this.providerRegistry = null;
        }
    }

    protected void bindHostService(HostService hostService) {
        this.hostService = hostService;
    }

    protected void unbindHostService(HostService hostService) {
        if (this.hostService == hostService) {
            this.hostService = null;
        }
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindController(OvsdbController ovsdbController) {
        this.controller = ovsdbController;
    }

    protected void unbindController(OvsdbController ovsdbController) {
        if (this.controller == ovsdbController) {
            this.controller = null;
        }
    }

    private class InnerOvsdbEventListener
    implements OvsdbEventListener {
        private InnerOvsdbEventListener() {
        }

        public void handle(OvsdbEvent<EventSubject> event) {
            OvsdbEventSubject subject = null;
            if (event.subject() instanceof OvsdbEventSubject) {
                subject = (OvsdbEventSubject)event.subject();
            }
            Preconditions.checkNotNull(subject, (Object)"EventSubject is not null");
            if (subject.ifaceid() == null) {
                return;
            }
            switch (event.type()) {
                case PORT_ADDED: {
                    HostId hostId = HostId.hostId((MacAddress)subject.hwAddress(), (VlanId)VlanId.vlanId());
                    DeviceId deviceId = DeviceId.deviceId((URI)OvsdbHostProvider.this.uri(subject.dpid().value()));
                    PortNumber portNumber = PortNumber.portNumber((long)subject.portNumber().value(), (String)subject.portName().value());
                    HostLocation loaction = new HostLocation(deviceId, portNumber, 0L);
                    DefaultAnnotations annotations = DefaultAnnotations.builder().set("ifaceid", subject.ifaceid().value()).build();
                    DefaultHostDescription hostDescription = new DefaultHostDescription(subject.hwAddress(), VlanId.vlanId(), loaction, new SparseAnnotations[]{annotations});
                    OvsdbHostProvider.this.providerService.hostDetected(hostId, (HostDescription)hostDescription, false);
                    break;
                }
                case PORT_REMOVED: {
                    HostId host = HostId.hostId((MacAddress)subject.hwAddress(), (VlanId)VlanId.vlanId());
                    OvsdbHostProvider.this.providerService.hostVanished(host);
                    break;
                }
            }
        }
    }
}

