/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yms.ypm;

import org.onosproject.yms.ypm.YpmContext;

public class DefaultYpmNode
implements YpmContext {
    private String name;
    private DefaultYpmNode parent;
    private DefaultYpmNode child;
    private DefaultYpmNode nextSibling;
    private DefaultYpmNode previousSibling;
    private Object metaData;

    public DefaultYpmNode(String name) {
        this.setName(name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public DefaultYpmNode getParent() {
        return this.parent;
    }

    @Override
    public void setParent(YpmContext parent) {
        this.parent = (DefaultYpmNode)parent;
    }

    @Override
    public YpmContext getFirstChild() {
        return this.child;
    }

    @Override
    public YpmContext getChild(String ypmName) {
        if (ypmName == null) {
            return null;
        }
        if (this.child == null) {
            return null;
        }
        if (this.child.name.equals(ypmName)) {
            return this.child;
        }
        YpmContext currentChild = this.child;
        while (currentChild.getNextSibling() != null) {
            if (!(currentChild = currentChild.getNextSibling()).getName().equals(ypmName)) continue;
            return currentChild;
        }
        return null;
    }

    @Override
    public void addChild(String ypmName) {
        if (ypmName == null) {
            return;
        }
        if (this.getChild(ypmName) != null) {
            return;
        }
        DefaultYpmNode newNode = new DefaultYpmNode(ypmName);
        newNode.setParent(this);
        if (this.child == null) {
            this.child = newNode;
            return;
        }
        YpmContext currentChild = this.child;
        while (currentChild.getNextSibling() != null) {
            currentChild = currentChild.getNextSibling();
        }
        currentChild.setNextSibling(newNode);
        newNode.setPreviousSibling((DefaultYpmNode)currentChild);
    }

    @Override
    public YpmContext getSibling(String ypmName) {
        if (ypmName == null) {
            return null;
        }
        for (YpmContext sibling = this.getNextSibling(); sibling != null; sibling = sibling.getNextSibling()) {
            if (!sibling.getName().equals(ypmName)) continue;
            return sibling;
        }
        return null;
    }

    @Override
    public void addSibling(String ypmName) {
        if (ypmName == null) {
            return;
        }
        if (this.getSibling(ypmName) != null) {
            return;
        }
        DefaultYpmNode newSibling = new DefaultYpmNode(ypmName);
        newSibling.setParent(this.getParent());
        YpmContext sibling = this.getNextSibling();
        if (sibling == null) {
            this.setNextSibling(newSibling);
            newSibling.setPreviousSibling(this);
        } else {
            while (sibling.getNextSibling() != null) {
                sibling = sibling.getNextSibling();
            }
            sibling.setNextSibling(newSibling);
            newSibling.setPreviousSibling((DefaultYpmNode)sibling);
        }
    }

    @Override
    public DefaultYpmNode getNextSibling() {
        return this.nextSibling;
    }

    @Override
    public void setNextSibling(DefaultYpmNode sibling) {
        this.nextSibling = sibling;
    }

    @Override
    public DefaultYpmNode getPreviousSibling() {
        return this.previousSibling;
    }

    @Override
    public void setPreviousSibling(DefaultYpmNode sibling) {
        this.previousSibling = sibling;
    }

    @Override
    public Object getMetaData() {
        return this.metaData;
    }

    @Override
    public void setMetaData(Object data) {
        this.metaData = data;
    }
}

