/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.flowperf;

import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.packet.MacAddress;
import org.onlab.util.Tools;
import org.onosproject.cfg.ComponentConfigService;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.event.EventListener;
import org.onosproject.net.Device;
import org.onosproject.net.PortNumber;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.flow.DefaultFlowRule;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.FlowRuleEvent;
import org.onosproject.net.flow.FlowRuleListener;
import org.onosproject.net.flow.FlowRuleService;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.flow.instructions.Instructions;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, enabled=true)
@Service(value={FlowPerfApp.class})
public class FlowPerfApp {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected FlowRuleService flowRuleService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ComponentConfigService configService;
    protected ApplicationId appId;
    private static final int DEFAULT_BATCH_SIZE = 200;
    private static final int DEFAULT_TOTAL_THREADS = 1;
    private static final int DEFAULT_TOTAL_FLOWS = 100000;
    private AtomicInteger pendingBatchCount;
    private CountDownLatch installationLatch;
    private CountDownLatch uninstallationLatch;
    private Iterator<Device> devices;
    private AtomicLong macIndex;
    List<FlowRule> addedRules = Lists.newArrayList();
    @Property(name="totalFlows", intValue={100000}, label="Total number of flows")
    protected int totalFlows = 100000;
    @Property(name="batchSize", intValue={200}, label="Number of flows per batch")
    protected int batchSize = 200;
    @Property(name="totalThreads", intValue={1}, label="Number of installer threads")
    protected int totalThreads = 1;
    private ExecutorService installer;
    private ExecutorService testRunner = Executors.newSingleThreadExecutor(Tools.groupedThreads((String)"app/flow-perf-test-runner", (String)""));

    @Activate
    public void activate(ComponentContext context) {
        this.appId = this.coreService.registerApplication("org.onosproject.flowperf");
        this.configService.registerProperties(this.getClass());
        this.installer = Executors.newFixedThreadPool(this.totalThreads, Tools.groupedThreads((String)"app/flow-perf-worker", (String)"%d"));
        this.testRunner.submit(this::runTest);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate(ComponentContext context) {
        this.installer.shutdown();
        this.testRunner.shutdown();
        this.configService.unregisterProperties(this.getClass(), false);
        this.log.info("Stopped.");
    }

    private void runTest() {
        this.pendingBatchCount = new AtomicInteger(this.totalFlows / this.batchSize);
        this.installationLatch = new CountDownLatch(this.totalFlows);
        ArrayList deviceList = Lists.newArrayList();
        this.deviceService.getAvailableDevices().forEach(deviceList::add);
        this.devices = Iterables.cycle((Iterable)deviceList).iterator();
        this.log.info("Starting installation. Total flows: {}, Total threads: {}, Batch Size: {}", new Object[]{this.totalFlows, this.totalThreads, this.batchSize});
        this.macIndex = new AtomicLong(0L);
        FlowRuleListener addMonitor = event -> {
            if (event.type() == FlowRuleEvent.Type.RULE_ADDED) {
                this.installationLatch.countDown();
            }
        };
        this.flowRuleService.addListener((EventListener)addMonitor);
        long addStartTime = System.currentTimeMillis();
        for (int i = 0; i < this.totalThreads; ++i) {
            this.installer.submit(() -> {
                while (this.pendingBatchCount.getAndDecrement() > 0) {
                    List<FlowRule> batch = this.nextBatch(this.batchSize);
                    this.addedRules.addAll(batch);
                    this.flowRuleService.applyFlowRules(batch.toArray(new FlowRule[0]));
                }
            });
        }
        try {
            this.installationLatch.await();
        }
        catch (InterruptedException e) {
            Thread.interrupted();
        }
        this.log.info("Time to install {} flows: {} ms", (Object)this.totalFlows, (Object)(System.currentTimeMillis() - addStartTime));
        this.flowRuleService.removeListener((EventListener)addMonitor);
        this.uninstallationLatch = new CountDownLatch(this.totalFlows);
        FlowRuleListener removeListener = event -> {
            if (event.type() == FlowRuleEvent.Type.RULE_REMOVED) {
                this.uninstallationLatch.countDown();
            }
        };
        AtomicInteger currentIndex = new AtomicInteger(0);
        long removeStartTime = System.currentTimeMillis();
        this.flowRuleService.addListener((EventListener)removeListener);
        this.installer.submit(() -> {
            while (currentIndex.get() < this.addedRules.size()) {
                List<FlowRule> removeBatch = this.addedRules.subList(currentIndex.get(), Math.min(currentIndex.get() + this.batchSize, this.addedRules.size()));
                currentIndex.addAndGet(removeBatch.size());
                this.flowRuleService.removeFlowRules(removeBatch.toArray(new FlowRule[0]));
            }
        });
        try {
            this.uninstallationLatch.await();
        }
        catch (InterruptedException e) {
            Thread.interrupted();
        }
        this.log.info("Time to uninstall {} flows: {} ms", (Object)this.totalFlows, (Object)(System.currentTimeMillis() - removeStartTime));
        this.flowRuleService.removeListener((EventListener)removeListener);
    }

    private List<FlowRule> nextBatch(int size) {
        ArrayList rules = Lists.newArrayList();
        for (int i = 0; i < size; ++i) {
            Device device = this.devices.next();
            long srcMac = this.macIndex.incrementAndGet();
            long dstMac = srcMac + 1L;
            TrafficSelector selector = DefaultTrafficSelector.builder().matchEthSrc(MacAddress.valueOf((long)srcMac)).matchEthDst(MacAddress.valueOf((long)dstMac)).matchInPort(PortNumber.portNumber((long)2L)).build();
            TrafficTreatment treatment = DefaultTrafficTreatment.builder().add((Instruction)Instructions.createOutput((PortNumber)PortNumber.portNumber((long)3L))).build();
            DefaultFlowRule rule = new DefaultFlowRule(device.id(), selector, treatment, 100, this.appId, 50000, true, null);
            rules.add(rule);
        }
        return rules;
    }

    @Modified
    public void modified(ComponentContext context) {
        boolean modified;
        if (context == null) {
            this.totalFlows = 100000;
            this.batchSize = 200;
            this.totalThreads = 1;
            return;
        }
        Dictionary properties = context.getProperties();
        int newTotalFlows = this.totalFlows;
        int newBatchSize = this.batchSize;
        int newTotalThreads = this.totalThreads;
        try {
            String s = Tools.get((Dictionary)properties, (String)"batchSize");
            newTotalFlows = Strings.isNullOrEmpty((String)s) ? this.totalFlows : Integer.parseInt(s.trim());
            s = Tools.get((Dictionary)properties, (String)"batchSize");
            newBatchSize = Strings.isNullOrEmpty((String)s) ? this.batchSize : Integer.parseInt(s.trim());
            s = Tools.get((Dictionary)properties, (String)"totalThreads");
            newTotalThreads = Strings.isNullOrEmpty((String)s) ? this.totalThreads : Integer.parseInt(s.trim());
        }
        catch (ClassCastException | NumberFormatException e) {
            return;
        }
        boolean bl = modified = newTotalFlows != this.totalFlows || newTotalThreads != this.totalThreads || newBatchSize != this.batchSize;
        if (!modified) {
            return;
        }
        this.totalFlows = newTotalFlows;
        this.batchSize = newBatchSize;
        if (this.totalThreads != newTotalThreads) {
            this.totalThreads = newTotalThreads;
            this.installer.shutdown();
            this.installer = Executors.newFixedThreadPool(this.totalThreads, Tools.groupedThreads((String)"flow-perf-worker", (String)"%d"));
        }
    }

    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }

    protected void bindFlowRuleService(FlowRuleService flowRuleService) {
        this.flowRuleService = flowRuleService;
    }

    protected void unbindFlowRuleService(FlowRuleService flowRuleService) {
        if (this.flowRuleService == flowRuleService) {
            this.flowRuleService = null;
        }
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindConfigService(ComponentConfigService componentConfigService) {
        this.configService = componentConfigService;
    }

    protected void unbindConfigService(ComponentConfigService componentConfigService) {
        if (this.configService == componentConfigService) {
            this.configService = null;
        }
    }
}

