/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pim.impl;

import com.google.common.base.Preconditions;
import org.onlab.packet.Ethernet;
import org.onlab.packet.IPv4;
import org.onlab.packet.IpAddress;
import org.onlab.packet.PIM;
import org.onosproject.pim.impl.PimInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PimPacketHandler {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public void processPacket(Ethernet ethPkt, PimInterface pimi) {
        Preconditions.checkNotNull((Object)ethPkt);
        Preconditions.checkNotNull((Object)pimi);
        if (ethPkt.getEtherType() != Ethernet.TYPE_IPV4) {
            return;
        }
        IPv4 ip = (IPv4)ethPkt.getPayload();
        if (ip.getProtocol() != 103) {
            return;
        }
        IpAddress nbraddr = IpAddress.valueOf((int)ip.getDestinationAddress());
        if (this.log.isTraceEnabled()) {
            this.log.trace("Packet {} received on port {}", (Object)nbraddr, (Object)pimi);
        }
        PIM pim = (PIM)ip.getPayload();
        Preconditions.checkNotNull((Object)pim);
        switch (pim.getPimMsgType()) {
            case 0: {
                pimi.processHello(ethPkt);
                break;
            }
            case 3: {
                pimi.processJoinPrune(ethPkt);
                this.log.debug("Received a PIM Join/Prune message");
                break;
            }
            default: {
                this.log.debug("Received unsupported PIM type: {}", (Object)pim.getPimMsgType());
            }
        }
    }
}

