/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pim.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.onlab.packet.Ethernet;
import org.onlab.packet.IPacket;
import org.onlab.packet.IPv4;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.IpAddress;
import org.onlab.packet.IpPrefix;
import org.onlab.packet.MacAddress;
import org.onlab.packet.PIM;
import org.onlab.packet.pim.PIMAddrUnicast;
import org.onlab.packet.pim.PIMHello;
import org.onlab.packet.pim.PIMHelloOption;
import org.onlab.packet.pim.PIMJoinPrune;
import org.onlab.packet.pim.PIMJoinPruneGroup;
import org.onosproject.incubator.net.intf.Interface;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.host.InterfaceIpAddress;
import org.onosproject.net.mcast.McastRoute;
import org.onosproject.net.packet.DefaultOutboundPacket;
import org.onosproject.net.packet.OutboundPacket;
import org.onosproject.net.packet.PacketService;
import org.onosproject.pim.impl.PimNeighbor;
import org.onosproject.pim.impl.PimPacket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PimInterface {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final int JOIN_PERIOD = 60;
    private static final double HOLD_TIME_MULTIPLIER = 3.5;
    private final PacketService packetService;
    private Interface onosInterface;
    private final TrafficTreatment outputTreatment;
    private short holdtime = (short)105;
    private int pruneDelay = 500;
    private int priority = 1;
    private final int helloInterval;
    private long lastHello;
    private final int generationId;
    private IpAddress drIpaddress;
    private Map<IpAddress, PimNeighbor> pimNeighbors = new ConcurrentHashMap<IpAddress, PimNeighbor>();
    private Map<McastRoute, RouteData> routes = new ConcurrentHashMap<McastRoute, RouteData>();

    private PimInterface(Interface intf, int helloInterval, short holdTime, int priority, short propagationDelay, short overrideInterval, PacketService packetService) {
        this.onosInterface = intf;
        this.outputTreatment = this.createOutputTreatment();
        this.helloInterval = helloInterval;
        this.holdtime = holdTime;
        this.packetService = packetService;
        IpAddress ourIp = this.getIpAddress();
        MacAddress mac = intf.mac();
        this.lastHello = 0L;
        this.generationId = new Random().nextInt();
        PimNeighbor us = new PimNeighbor(ourIp, mac, holdTime, 0, priority, this.generationId);
        this.pimNeighbors.put(ourIp, us);
        this.drIpaddress = ourIp;
    }

    private TrafficTreatment createOutputTreatment() {
        return DefaultTrafficTreatment.builder().setOutput(this.onosInterface.connectPoint().port()).build();
    }

    public Interface getInterface() {
        return this.onosInterface;
    }

    public PimInterface setInterface(Interface intf) {
        this.onosInterface = intf;
        return this;
    }

    public List<InterfaceIpAddress> getIpAddresses() {
        return this.onosInterface.ipAddressesList();
    }

    public IpAddress getIpAddress() {
        IpAddress ipaddr;
        block1: {
            if (this.onosInterface.ipAddressesList().isEmpty()) {
                return null;
            }
            ipaddr = null;
            Iterator iterator = this.onosInterface.ipAddressesList().iterator();
            if (!iterator.hasNext()) break block1;
            InterfaceIpAddress ifipaddr = (InterfaceIpAddress)iterator.next();
            ipaddr = ifipaddr.ipAddress();
        }
        return ipaddr;
    }

    public short getHoldtime() {
        return this.holdtime;
    }

    public int getPruneDelay() {
        return this.pruneDelay;
    }

    public int getPriority() {
        return this.priority;
    }

    public int getGenerationId() {
        return this.generationId;
    }

    public Collection<PimNeighbor> getNeighbors() {
        return ImmutableList.copyOf(this.pimNeighbors.values());
    }

    public Collection<McastRoute> getRoutes() {
        return this.routes.keySet();
    }

    public void checkNeighborTimeouts() {
        Set expired = this.pimNeighbors.values().stream().filter(neighbor -> !neighbor.ipAddress().equals((Object)this.getIpAddress())).filter(neighbor -> neighbor.isExpired()).collect(Collectors.toSet());
        for (PimNeighbor neighbor2 : expired) {
            this.log.info("Timing out neighbor {}", (Object)neighbor2);
            this.pimNeighbors.remove(neighbor2.ipAddress(), neighbor2);
        }
    }

    public void sendHello() {
        if (this.lastHello + TimeUnit.SECONDS.toMillis(this.helloInterval) > System.currentTimeMillis()) {
            return;
        }
        this.lastHello = System.currentTimeMillis();
        PimPacket pimPacket = new PimPacket(0);
        pimPacket.setSrcMacAddr(this.onosInterface.mac());
        pimPacket.setSrcIpAddress(Ip4Address.valueOf((byte[])this.getIpAddress().toOctets()));
        PIMHello hello = new PIMHello();
        hello.createDefaultOptions();
        hello.addOption(PIMHelloOption.createHoldTime((short)this.holdtime));
        hello.addOption(PIMHelloOption.createPriority((int)this.priority));
        hello.addOption(PIMHelloOption.createGenID((int)this.generationId));
        pimPacket.setPimPayload((IPacket)hello);
        this.packetService.emit((OutboundPacket)new DefaultOutboundPacket(this.onosInterface.connectPoint().deviceId(), this.outputTreatment, ByteBuffer.wrap(pimPacket.getEthernet().serialize())));
    }

    public void processHello(Ethernet ethPkt) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("Received a PIM hello packet");
        }
        MacAddress nbrmac = ethPkt.getSourceMAC();
        IPv4 iphdr = (IPv4)ethPkt.getPayload();
        IpAddress srcip = IpAddress.valueOf((int)iphdr.getSourceAddress());
        PIM pimhdr = (PIM)iphdr.getPayload();
        if (pimhdr.getPimMsgType() != 0) {
            this.log.error("process Hello has received a non hello packet type: " + pimhdr.getPimMsgType());
            return;
        }
        PimNeighbor dr = this.pimNeighbors.get(this.drIpaddress);
        Preconditions.checkNotNull((Object)dr);
        IpAddress drip = this.drIpaddress;
        int drpri = dr.priority();
        boolean reElectDr = false;
        boolean genidChanged = false;
        PIMHello hello = (PIMHello)pimhdr.getPayload();
        PimNeighbor nbr = this.pimNeighbors.getOrDefault(srcip, null);
        PimNeighbor newNbr = PimNeighbor.createPimNeighbor(srcip, nbrmac, hello.getOptions().values());
        if (nbr == null) {
            this.pimNeighbors.putIfAbsent(srcip, newNbr);
            nbr = newNbr;
        } else if (!nbr.equals(newNbr)) {
            if (newNbr.holdtime() == 0) {
                this.pimNeighbors.remove(srcip, nbr);
                return;
            }
            this.pimNeighbors.put(srcip, newNbr);
            nbr = newNbr;
        }
        nbr.refreshTimestamp();
        IpAddress electedIp = this.election(nbr, drip, drpri);
        if (!drip.equals((Object)electedIp)) {
            this.drIpaddress = electedIp;
        }
    }

    private IpAddress election(PimNeighbor nbr, IpAddress drIp, int drPriority) {
        IpAddress nbrIp = nbr.ipAddress();
        if (nbr.priority() > drPriority) {
            return nbrIp;
        }
        if (nbrIp.compareTo(drIp) > 0) {
            return nbrIp;
        }
        return drIp;
    }

    public void processJoinPrune(Ethernet ethPkt) {
        IPv4 ip = (IPv4)ethPkt.getPayload();
        Preconditions.checkNotNull((Object)ip);
        PIM pim = (PIM)ip.getPayload();
        Preconditions.checkNotNull((Object)pim);
        PIMJoinPrune jpHdr = (PIMJoinPrune)pim.getPayload();
        Preconditions.checkNotNull((Object)jpHdr);
        Collection jpgs = jpHdr.getJoinPrunes();
        for (PIMJoinPruneGroup jpg : jpgs) {
            IpPrefix gpfx = jpg.getGroup();
            for (IpPrefix ipPrefix : jpg.getJoins().values()) {
            }
            for (IpPrefix ipPrefix : jpg.getPrunes().values()) {
            }
        }
    }

    public void addRoute(McastRoute route, IpAddress nextHop, MacAddress nextHopMac) {
        RouteData data = new RouteData(nextHop, nextHopMac);
        this.routes.put(route, data);
        this.sendJoinPrune(route, data, true);
    }

    public void removeRoute(McastRoute route) {
        RouteData data = this.routes.remove(route);
        if (data != null) {
            this.sendJoinPrune(route, data, false);
        }
    }

    public void sendJoins() {
        this.routes.entrySet().forEach(entry -> {
            if (((RouteData)entry.getValue()).timestamp + TimeUnit.SECONDS.toMillis(60L) > System.currentTimeMillis()) {
                return;
            }
            this.sendJoinPrune((McastRoute)entry.getKey(), (RouteData)entry.getValue(), true);
        });
    }

    private void sendJoinPrune(McastRoute route, RouteData data, boolean join) {
        PIMJoinPrune jp = new PIMJoinPrune();
        jp.addJoinPrune(route.source().toIpPrefix(), route.group().toIpPrefix(), join);
        jp.setHoldTime(join ? (short)Math.floor(210.0) : (short)0);
        jp.setUpstreamAddr(new PIMAddrUnicast(data.ipAddress.toString()));
        PIM pim = new PIM();
        pim.setPIMType((byte)3);
        pim.setPayload((IPacket)jp);
        IPv4 ipv4 = new IPv4();
        ipv4.setDestinationAddress(PIM.PIM_ADDRESS.getIp4Address().toInt());
        ipv4.setSourceAddress(this.getIpAddress().getIp4Address().toInt());
        ipv4.setProtocol((byte)103);
        ipv4.setTtl((byte)1);
        ipv4.setDiffServ((byte)-64);
        ipv4.setPayload((IPacket)pim);
        Ethernet eth = new Ethernet();
        eth.setSourceMACAddress(this.onosInterface.mac());
        eth.setDestinationMACAddress(MacAddress.valueOf((String)"01:00:5E:00:00:0d"));
        eth.setEtherType(Ethernet.TYPE_IPV4);
        eth.setPayload((IPacket)ipv4);
        TrafficTreatment treatment = DefaultTrafficTreatment.builder().setOutput(this.onosInterface.connectPoint().port()).build();
        this.packetService.emit((OutboundPacket)new DefaultOutboundPacket(this.onosInterface.connectPoint().deviceId(), treatment, ByteBuffer.wrap(eth.serialize())));
        data.timestamp = System.currentTimeMillis();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static class RouteData {
        final IpAddress ipAddress;
        final MacAddress macAddress;
        long timestamp;

        public RouteData(IpAddress ip, MacAddress mac) {
            this.ipAddress = ip;
            this.macAddress = mac;
            this.timestamp = System.currentTimeMillis();
        }
    }

    public static class Builder {
        private Interface intf;
        private PacketService packetService;
        private int helloInterval = 30;
        private short holdtime = (short)105;
        private int priority = 1;
        private short propagationDelay = (short)500;
        private short overrideInterval = (short)2500;

        public Builder withInterface(Interface intf) {
            this.intf = (Interface)Preconditions.checkNotNull((Object)intf);
            return this;
        }

        public Builder withPacketService(PacketService packetService) {
            this.packetService = (PacketService)Preconditions.checkNotNull((Object)packetService);
            return this;
        }

        public Builder withHelloInterval(int helloInterval) {
            this.helloInterval = helloInterval;
            return this;
        }

        public Builder withHoldTime(short holdTime) {
            this.holdtime = holdTime;
            return this;
        }

        public Builder withPriority(int priority) {
            this.priority = priority;
            return this;
        }

        public Builder withPropagationDelay(short propagationDelay) {
            this.propagationDelay = propagationDelay;
            return this;
        }

        public Builder withOverrideInterval(short overrideInterval) {
            this.overrideInterval = overrideInterval;
            return this;
        }

        public PimInterface build() {
            Preconditions.checkArgument((this.intf != null ? 1 : 0) != 0, (Object)"Must provide an interface");
            Preconditions.checkArgument((this.packetService != null ? 1 : 0) != 0, (Object)"Must provide a packet service");
            return new PimInterface(this.intf, this.helloInterval, this.holdtime, this.priority, this.propagationDelay, this.overrideInterval, this.packetService);
        }
    }
}

