/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.lumentum;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.onlab.packet.ChassisId;
import org.onosproject.net.ChannelSpacing;
import org.onosproject.net.CltSignalType;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.GridType;
import org.onosproject.net.OchSignal;
import org.onosproject.net.OduSignalType;
import org.onosproject.net.PortNumber;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.device.DefaultDeviceDescription;
import org.onosproject.net.device.DeviceDescription;
import org.onosproject.net.device.DeviceDescriptionDiscovery;
import org.onosproject.net.device.PortDescription;
import org.onosproject.net.driver.AbstractHandlerBehaviour;
import org.onosproject.net.optical.device.OchPortHelper;
import org.onosproject.net.optical.device.OduCltPortHelper;
import org.onosproject.tl1.Tl1Command;
import org.onosproject.tl1.Tl1Controller;
import org.onosproject.tl1.Tl1Device;
import org.onosproject.tl1.impl.DefaultTl1Command;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LumentumWaveReadyDiscovery
extends AbstractHandlerBehaviour
implements DeviceDescriptionDiscovery {
    private final Logger log = LoggerFactory.getLogger(LumentumWaveReadyDiscovery.class);
    private static final int TIMEOUT = 10000;
    private static final String LUMENTUM = "Lumentum";
    private static final String WAVEREADY = "WaveReady";
    private static final String SWVERSION = "1.0";
    private static final String SERIAL = "3100";
    private static final String ACT = "ACT";
    private static final String USER = "USER";
    private static final String RTRV = "RTRV";
    private static final String NETYPE = "NETYPE";
    private static final String PLUGGABLE_INV = "PLUGGABLE-INV";
    private static final String CANC = "CANC";
    private static final String EIGHTFIFTY = "850";

    public DeviceDescription discoverDeviceDetails() {
        DeviceId deviceId = this.handler().data().deviceId();
        Tl1Controller ctrl = (Tl1Controller)Preconditions.checkNotNull((Object)this.handler().get(Tl1Controller.class));
        DefaultDeviceDescription defaultDescription = new DefaultDeviceDescription(deviceId.uri(), Device.Type.OTN, LUMENTUM, WAVEREADY, SWVERSION, SERIAL, new ChassisId(), false, new SparseAnnotations[]{DefaultAnnotations.EMPTY});
        Optional device = ctrl.getDevice(deviceId);
        if (!device.isPresent()) {
            return defaultDescription;
        }
        Tl1Command loginCmd = DefaultTl1Command.builder().withVerb(ACT).withModifier(USER).withAid(((Tl1Device)device.get()).username()).withCtag(100).withParameters(((Tl1Device)device.get()).password()).build();
        CompletableFuture login = ctrl.sendMsg(deviceId, loginCmd);
        try {
            String loginResponse = (String)login.get(10000L, TimeUnit.MILLISECONDS);
            if (loginResponse.contains("Access denied")) {
                this.log.error("Access denied: {}", (Object)loginResponse);
                return defaultDescription;
            }
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            this.log.error("Login failed", (Throwable)e);
            return defaultDescription;
        }
        Tl1Command ddCmd = DefaultTl1Command.builder().withVerb(RTRV).withModifier(NETYPE).withCtag(101).build();
        CompletableFuture dd = ctrl.sendMsg(deviceId, ddCmd);
        try {
            String ddResponse = (String)dd.get(10000L, TimeUnit.MILLISECONDS);
            return new DefaultDeviceDescription((DeviceDescription)defaultDescription, true, new SparseAnnotations[]{this.extractAnnotations(ddResponse)});
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            this.log.error("Device description not found", (Throwable)e);
            return defaultDescription;
        }
    }

    public List<PortDescription> discoverPortDetails() {
        DeviceId deviceId = this.handler().data().deviceId();
        Tl1Controller ctrl = (Tl1Controller)Preconditions.checkNotNull((Object)this.handler().get(Tl1Controller.class));
        Tl1Command pdCmd = DefaultTl1Command.builder().withVerb(RTRV).withModifier(PLUGGABLE_INV).withCtag(102).build();
        CompletableFuture pd = ctrl.sendMsg(deviceId, pdCmd);
        try {
            String pdResponse = (String)pd.get(10000L, TimeUnit.MILLISECONDS);
            return this.extractPorts(pdResponse);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            this.log.error("Port description not found", (Throwable)e);
            return Collections.EMPTY_LIST;
        }
    }

    private SparseAnnotations extractAnnotations(String s) {
        DefaultAnnotations.Builder annot = DefaultAnnotations.builder();
        Arrays.stream(s.split(",")).forEach(w -> {
            String[] pair = w.replaceAll("\\\\\"", "").split("=");
            if (pair.length == 2) {
                annot.set(pair[0], pair[1]);
            } else {
                annot.set(pair[0], "");
            }
        });
        return annot.build();
    }

    private List<PortDescription> extractPorts(String s) {
        ArrayList<PortDescription> ports = new ArrayList<PortDescription>();
        if (s.length() == 0) {
            return ports;
        }
        Arrays.stream(s.split("\"\"")).forEach(p -> {
            if (p.contains(EIGHTFIFTY)) {
                PortDescription cltPort = OduCltPortHelper.oduCltPortDescription((PortNumber)PortNumber.portNumber((long)(ports.size() + 1)), (boolean)true, (CltSignalType)CltSignalType.CLT_10GBE, (SparseAnnotations)this.extractAnnotations((String)p));
                ports.add(cltPort);
            } else {
                PortDescription netPort = OchPortHelper.ochPortDescription((PortNumber)PortNumber.portNumber((long)(ports.size() + 1)), (boolean)true, (OduSignalType)OduSignalType.ODU2e, (boolean)true, (OchSignal)new OchSignal(GridType.DWDM, ChannelSpacing.CHL_50GHZ, 0, 4), (SparseAnnotations)this.extractAnnotations((String)p));
                ports.add(netPort);
            }
        });
        return ports;
    }

    private void logout() {
        DeviceId deviceId = this.handler().data().deviceId();
        Tl1Controller ctrl = (Tl1Controller)Preconditions.checkNotNull((Object)this.handler().get(Tl1Controller.class));
        Optional device = ctrl.getDevice(deviceId);
        if (!device.isPresent()) {
            return;
        }
        Tl1Command logoutCmd = DefaultTl1Command.builder().withVerb(CANC).withModifier(USER).withAid(((Tl1Device)device.get()).username()).withCtag(103).build();
        CompletableFuture logout = ctrl.sendMsg(deviceId, logoutCmd);
        try {
            String string = (String)logout.get(10000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            this.log.error("Lougout failed", (Throwable)e);
        }
    }
}

