/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.lumentum;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import org.onlab.util.Frequency;
import org.onosproject.net.ChannelSpacing;
import org.onosproject.net.DeviceId;
import org.onosproject.net.GridType;
import org.snmp4j.CommunityTarget;
import org.snmp4j.PDU;
import org.snmp4j.Session;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.TransportMapping;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.GenericAddress;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.transport.DefaultUdpTransportMapping;
import org.snmp4j.util.DefaultPDUFactory;
import org.snmp4j.util.PDUFactory;
import org.snmp4j.util.TreeEvent;
import org.snmp4j.util.TreeUtils;

public class LumentumSnmpDevice {
    private static final int MAX_SIZE_RESPONSE_PDU = 65535;
    private static final int MAX_REPETITIONS = 50;
    public static final GridType GRID_TYPE = GridType.DWDM;
    public static final ChannelSpacing CHANNEL_SPACING = ChannelSpacing.CHL_50GHZ;
    public static final Frequency START_CENTER_FREQ = Frequency.ofGHz((long)191350L);
    public static final Frequency END_CENTER_FREQ = Frequency.ofGHz((long)196100L);
    public static final int MULTIPLIER_SHIFT = 36;
    private Snmp snmp;
    private CommunityTarget target;

    public LumentumSnmpDevice(DeviceId did) throws IOException {
        String[] deviceComponents = did.toString().split(":");
        Preconditions.checkArgument((deviceComponents.length > 1 ? 1 : 0) != 0);
        String ipAddress = deviceComponents[1];
        String port = deviceComponents[2];
        this.createDevice(ipAddress, Integer.parseInt(port));
    }

    public LumentumSnmpDevice(String ipAddress, int port) throws IOException {
        this.createDevice(ipAddress, port);
    }

    private void createDevice(String ipAddress, int port) throws IOException {
        Address targetAddress = GenericAddress.parse((String)("udp:" + ipAddress + "/" + port));
        DefaultUdpTransportMapping transport = new DefaultUdpTransportMapping();
        transport.listen();
        this.snmp = new Snmp((TransportMapping)transport);
        this.target = new CommunityTarget();
        this.target.setCommunity(new OctetString("public"));
        this.target.setAddress(targetAddress);
        this.target.setRetries(3);
        this.target.setTimeout(3000L);
        this.target.setVersion(1);
        this.target.setMaxSizeRequestPDU(65535);
    }

    public ResponseEvent set(PDU pdu) throws IOException {
        return this.snmp.set(pdu, (Target)this.target);
    }

    public List<TreeEvent> get(OID oid) {
        TreeUtils treeUtils = new TreeUtils((Session)this.snmp, (PDUFactory)new DefaultPDUFactory());
        treeUtils.setMaxRepetitions(50);
        return treeUtils.getSubtree((Target)this.target, oid);
    }
}

