/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.lumentum;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.onosproject.driver.optical.flowrule.CrossConnectCache;
import org.onosproject.driver.optical.flowrule.CrossConnectFlowRule;
import org.onosproject.drivers.lumentum.LumentumSnmpDevice;
import org.onosproject.net.ChannelSpacing;
import org.onosproject.net.GridType;
import org.onosproject.net.Lambda;
import org.onosproject.net.OchSignal;
import org.onosproject.net.OchSignalType;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.driver.AbstractHandlerBehaviour;
import org.onosproject.net.flow.DefaultFlowEntry;
import org.onosproject.net.flow.DefaultFlowRule;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.FlowEntry;
import org.onosproject.net.flow.FlowId;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.FlowRuleProgrammable;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.criteria.Criteria;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snmp4j.PDU;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.UnsignedInteger32;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.util.TreeEvent;

public class LumentumSdnRoadmFlowRuleProgrammable
extends AbstractHandlerBehaviour
implements FlowRuleProgrammable {
    private static final Logger log = LoggerFactory.getLogger(LumentumSdnRoadmFlowRuleProgrammable.class);
    private static final int DEFAULT_TARGET_GAIN_PREAMP = 150;
    private static final int DEFAULT_TARGET_GAIN_BOOSTER = 200;
    private static final int DISABLE_CHANNEL_TARGET_POWER = -650;
    private static final int DEFAULT_CHANNEL_TARGET_POWER = -30;
    private static final int DISABLE_CHANNEL_ABSOLUTE_ATTENUATION = 160;
    private static final int DEFAULT_CHANNEL_ABSOLUTE_ATTENUATION = 50;
    private static final int DISABLE_CHANNEL_ADD_DROP_PORT_INDEX = 1;
    private static final int OUT_OF_SERVICE = 1;
    private static final int IN_SERVICE = 2;
    private static final int OPEN_LOOP = 1;
    private static final int CLOSED_LOOP = 2;
    private static final int DROP_PORT_OFFSET = 20;
    private static final String CTRL_AMP_MODULE_SERVICE_STATE_PREAMP = ".1.3.6.1.4.1.46184.1.4.4.1.2.1";
    private static final String CTRL_AMP_MODULE_SERVICE_STATE_BOOSTER = ".1.3.6.1.4.1.46184.1.4.4.1.2.2";
    private static final String CTRL_AMP_MODULE_TARGET_GAIN_PREAMP = ".1.3.6.1.4.1.46184.1.4.4.1.8.1";
    private static final String CTRL_AMP_MODULE_TARGET_GAIN_BOOSTER = ".1.3.6.1.4.1.46184.1.4.4.1.8.2";
    private static final String CTRL_CHANNEL_STATE = ".1.3.6.1.4.1.46184.1.4.2.1.3.";
    private static final String CTRL_CHANNEL_MODE = ".1.3.6.1.4.1.46184.1.4.2.1.4.";
    private static final String CTRL_CHANNEL_TARGET_POWER = ".1.3.6.1.4.1.46184.1.4.2.1.6.";
    private static final String CTRL_CHANNEL_ADD_DROP_PORT_INDEX = ".1.3.6.1.4.1.46184.1.4.2.1.13.";
    private static final String CTRL_CHANNEL_ABSOLUTE_ATTENUATION = ".1.3.6.1.4.1.46184.1.4.2.1.5.";
    private LumentumSnmpDevice snmp;

    public Collection<FlowEntry> getFlowEntries() {
        try {
            this.snmp = new LumentumSnmpDevice(this.handler().data().deviceId());
        }
        catch (IOException e) {
            log.error("Failed to connect to device: ", (Throwable)e);
            return Collections.emptyList();
        }
        DeviceService deviceService = (DeviceService)this.handler().get(DeviceService.class);
        List ports = deviceService.getPorts(this.data().deviceId());
        if (ports.size() < 2) {
            return Collections.emptyList();
        }
        PortNumber lineIn = ((Port)ports.get(ports.size() - 2)).number();
        PortNumber lineOut = ((Port)ports.get(ports.size() - 1)).number();
        LinkedList entries = Lists.newLinkedList();
        OID addOid = new OID(".1.3.6.1.4.1.46184.1.4.2.1.3.1");
        entries.addAll(this.fetchRules(addOid, true, lineOut).stream().map(fr -> new DefaultFlowEntry(fr, FlowEntry.FlowEntryState.ADDED, 0L, 0L, 0L)).collect(Collectors.toList()));
        OID dropOid = new OID(".1.3.6.1.4.1.46184.1.4.2.1.3.2");
        entries.addAll(this.fetchRules(dropOid, false, lineIn).stream().map(fr -> new DefaultFlowEntry(fr, FlowEntry.FlowEntryState.ADDED, 0L, 0L, 0L)).collect(Collectors.toList()));
        return entries;
    }

    public Collection<FlowRule> applyFlowRules(Collection<FlowRule> rules) {
        try {
            this.snmp = new LumentumSnmpDevice(this.data().deviceId());
        }
        catch (IOException e) {
            log.error("Failed to connect to device: ", (Throwable)e);
        }
        DeviceService deviceService = (DeviceService)this.handler().get(DeviceService.class);
        List ports = deviceService.getPorts(this.data().deviceId());
        List linePorts = ports.subList(ports.size() - 2, ports.size()).stream().map(p -> p.number()).collect(Collectors.toList());
        Collection added = rules.stream().map(r -> new CrossConnectFlowRule(r, linePorts)).filter(xc -> this.installCrossConnect((CrossConnectFlowRule)xc)).collect(Collectors.toList());
        CrossConnectCache cache = (CrossConnectCache)this.handler().get(CrossConnectCache.class);
        added.forEach(xc -> cache.set(Objects.hash(this.data().deviceId(), xc.selector(), xc.treatment()), xc.id(), xc.priority()));
        return added;
    }

    public Collection<FlowRule> removeFlowRules(Collection<FlowRule> rules) {
        try {
            this.snmp = new LumentumSnmpDevice(this.data().deviceId());
        }
        catch (IOException e) {
            log.error("Failed to connect to device: ", (Throwable)e);
        }
        DeviceService deviceService = (DeviceService)this.handler().get(DeviceService.class);
        List ports = deviceService.getPorts(this.data().deviceId());
        List linePorts = ports.subList(ports.size() - 2, ports.size()).stream().map(p -> p.number()).collect(Collectors.toList());
        Collection removed = rules.stream().map(r -> new CrossConnectFlowRule(r, linePorts)).filter(xc -> this.removeCrossConnect((CrossConnectFlowRule)xc)).collect(Collectors.toList());
        CrossConnectCache cache = (CrossConnectCache)this.handler().get(CrossConnectCache.class);
        removed.forEach(xc -> cache.remove(Objects.hash(this.data().deviceId(), xc.selector(), xc.treatment())));
        return removed;
    }

    private boolean installCrossConnect(CrossConnectFlowRule xc) {
        OID ctrlChannelAbsoluteAttenuation;
        OID ctrlChannelMode;
        int channel = LumentumSdnRoadmFlowRuleProgrammable.toChannel(xc.ochSignal());
        long addDrop = xc.addDrop().toLong();
        if (!xc.isAddRule()) {
            addDrop -= 20L;
        }
        PDU pdu = new PDU();
        pdu.setType(-93);
        List<OID> oids = Arrays.asList(new OID(CTRL_AMP_MODULE_SERVICE_STATE_PREAMP), new OID(CTRL_AMP_MODULE_SERVICE_STATE_BOOSTER));
        oids.forEach(oid -> pdu.add(new VariableBinding(oid, (Variable)new Integer32(2))));
        OID ctrlAmpModuleTargetGainPreamp = new OID(CTRL_AMP_MODULE_TARGET_GAIN_PREAMP);
        pdu.add(new VariableBinding(ctrlAmpModuleTargetGainPreamp, (Variable)new Integer32(150)));
        OID ctrlAmpModuleTargetGainBooster = new OID(CTRL_AMP_MODULE_TARGET_GAIN_BOOSTER);
        pdu.add(new VariableBinding(ctrlAmpModuleTargetGainBooster, (Variable)new Integer32(200)));
        OID ctrlChannelAddDropPortIndex = new OID(CTRL_CHANNEL_ADD_DROP_PORT_INDEX + (xc.isAddRule() ? "1." : "2.") + channel);
        pdu.add(new VariableBinding(ctrlChannelAddDropPortIndex, (Variable)new UnsignedInteger32(addDrop)));
        if (xc.isAddRule()) {
            ctrlChannelMode = new OID(".1.3.6.1.4.1.46184.1.4.2.1.4.1." + channel);
            pdu.add(new VariableBinding(ctrlChannelMode, (Variable)new Integer32(2)));
            OID ctrlChannelTargetPower = new OID(".1.3.6.1.4.1.46184.1.4.2.1.6.1." + channel);
            pdu.add(new VariableBinding(ctrlChannelTargetPower, (Variable)new Integer32(-30)));
        } else {
            ctrlChannelMode = new OID(".1.3.6.1.4.1.46184.1.4.2.1.4.2." + channel);
            pdu.add(new VariableBinding(ctrlChannelMode, (Variable)new Integer32(1)));
            ctrlChannelAbsoluteAttenuation = new OID(".1.3.6.1.4.1.46184.1.4.2.1.5.2." + channel);
            pdu.add(new VariableBinding(ctrlChannelAbsoluteAttenuation, (Variable)new UnsignedInteger32(50)));
        }
        OID ctrlChannelState = new OID(CTRL_CHANNEL_STATE + (xc.isAddRule() ? "1." : "2.") + channel);
        pdu.add(new VariableBinding(ctrlChannelState, (Variable)new Integer32(2)));
        try {
            ctrlChannelAbsoluteAttenuation = this.snmp.set(pdu);
        }
        catch (IOException e) {
            log.error("Failed to create cross connect, unable to connect to device: ", (Throwable)e);
        }
        return true;
    }

    private boolean removeCrossConnect(CrossConnectFlowRule xc) {
        OID ctrlChannelAbsoluteAttenuation;
        int channel = LumentumSdnRoadmFlowRuleProgrammable.toChannel(xc.ochSignal());
        PDU pdu = new PDU();
        pdu.setType(-93);
        OID ctrlChannelState = new OID(CTRL_CHANNEL_STATE + (xc.isAddRule() ? "1." : "2.") + channel);
        pdu.add(new VariableBinding(ctrlChannelState, (Variable)new Integer32(1)));
        OID ctrlChannelAddDropPortIndex = new OID(CTRL_CHANNEL_ADD_DROP_PORT_INDEX + (xc.isAddRule() ? "1." : "2.") + channel);
        pdu.add(new VariableBinding(ctrlChannelAddDropPortIndex, (Variable)new UnsignedInteger32(1)));
        OID ctrlChannelMode = new OID(CTRL_CHANNEL_MODE + (xc.isAddRule() ? "1." : "2.") + channel);
        pdu.add(new VariableBinding(ctrlChannelMode, (Variable)new Integer32(1)));
        if (xc.isAddRule()) {
            OID ctrlChannelTargetPower = new OID(".1.3.6.1.4.1.46184.1.4.2.1.6.1." + channel);
            pdu.add(new VariableBinding(ctrlChannelTargetPower, (Variable)new Integer32(-650)));
        } else {
            ctrlChannelAbsoluteAttenuation = new OID(".1.3.6.1.4.1.46184.1.4.2.1.5.2." + channel);
            pdu.add(new VariableBinding(ctrlChannelAbsoluteAttenuation, (Variable)new UnsignedInteger32(160)));
        }
        try {
            ctrlChannelAbsoluteAttenuation = this.snmp.set(pdu);
        }
        catch (IOException e) {
            log.error("Failed to remove cross connect, unable to connect to device: ", (Throwable)e);
            return false;
        }
        return true;
    }

    public static int toChannel(OchSignal ochSignal) {
        Preconditions.checkArgument((ochSignal.channelSpacing() == ChannelSpacing.CHL_50GHZ ? 1 : 0) != 0);
        Preconditions.checkArgument((LumentumSnmpDevice.START_CENTER_FREQ.compareTo(ochSignal.centralFrequency()) <= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((LumentumSnmpDevice.END_CENTER_FREQ.compareTo(ochSignal.centralFrequency()) >= 0 ? 1 : 0) != 0);
        return ochSignal.spacingMultiplier() + 36;
    }

    public static OchSignal toOchSignal(int channel) {
        Preconditions.checkArgument((1 <= channel ? 1 : 0) != 0);
        Preconditions.checkArgument((channel <= 96 ? 1 : 0) != 0);
        return new OchSignal(GridType.DWDM, ChannelSpacing.CHL_50GHZ, channel - 36, 4);
    }

    private PortNumber getAddDropPort(int channel, boolean isAddPort) {
        OID oid = new OID(CTRL_CHANNEL_ADD_DROP_PORT_INDEX + (isAddPort ? "1" : "2"));
        for (TreeEvent event : this.snmp.get(oid)) {
            VariableBinding[] varBindings;
            if (event == null) {
                return null;
            }
            for (VariableBinding varBinding : varBindings = event.getVariableBindings()) {
                if (varBinding.getOid().last() != channel) continue;
                int port = varBinding.getVariable().toInt();
                if (!isAddPort) {
                    port += 20;
                }
                return PortNumber.portNumber((long)port);
            }
        }
        return null;
    }

    private List<FlowRule> fetchRules(OID oid, boolean isAdd, PortNumber linePort) {
        LinkedList<FlowRule> rules = new LinkedList<FlowRule>();
        for (TreeEvent event : this.snmp.get(oid)) {
            VariableBinding[] varBindings;
            if (event == null) continue;
            for (VariableBinding varBinding : varBindings = event.getVariableBindings()) {
                int channel;
                PortNumber addDropPort;
                CrossConnectCache cache = (CrossConnectCache)this.handler().get(CrossConnectCache.class);
                if (varBinding.getVariable().toInt() != 2 || (addDropPort = this.getAddDropPort(channel = varBinding.getOid().removeLast(), isAdd)) == null) continue;
                TrafficSelector selector = DefaultTrafficSelector.builder().matchInPort(isAdd ? addDropPort : linePort).add(Criteria.matchOchSignalType((OchSignalType)OchSignalType.FIXED_GRID)).add(Criteria.matchLambda((Lambda)LumentumSdnRoadmFlowRuleProgrammable.toOchSignal(channel))).build();
                TrafficTreatment treatment = DefaultTrafficTreatment.builder().setOutput(isAdd ? linePort : addDropPort).build();
                int hash = Objects.hash(this.data().deviceId(), selector, treatment);
                Pair lookup = cache.get(hash);
                if (lookup == null) continue;
                FlowRule fr = DefaultFlowRule.builder().forDevice(this.data().deviceId()).makePermanent().withSelector(selector).withTreatment(treatment).withPriority(((Integer)lookup.getRight()).intValue()).withCookie(((FlowId)lookup.getLeft()).value()).build();
                rules.add(fr);
            }
        }
        return rules;
    }
}

