/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.lumentum;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.onlab.util.Frequency;
import org.onosproject.drivers.lumentum.LumentumSnmpDevice;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.device.DefaultDeviceDescription;
import org.onosproject.net.device.DeviceDescription;
import org.onosproject.net.device.DeviceDescriptionDiscovery;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.device.PortDescription;
import org.onosproject.net.driver.AbstractHandlerBehaviour;
import org.onosproject.net.optical.device.OmsPortHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.util.TreeEvent;

public class LumentumRoadmDiscovery
extends AbstractHandlerBehaviour
implements DeviceDescriptionDiscovery {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String CTRL_PORT_STATE = ".1.3.6.1.4.1.46184.1.4.1.1.3.";
    private LumentumSnmpDevice snmp;

    public DeviceDescription discoverDeviceDetails() {
        DeviceService deviceService = (DeviceService)Preconditions.checkNotNull((Object)this.handler().get(DeviceService.class));
        DeviceId deviceId = this.handler().data().deviceId();
        Device device = deviceService.getDevice(deviceId);
        return new DefaultDeviceDescription(device.id().uri(), Device.Type.ROADM, "Lumentum", "SDN ROADM", "1.0", "v1", device.chassisId(), new SparseAnnotations[]{(SparseAnnotations)device.annotations()});
    }

    public List<PortDescription> discoverPortDetails() {
        return ImmutableList.copyOf(this.getPorts());
    }

    private List<PortDescription> getPorts() {
        OID[] oids;
        try {
            this.snmp = new LumentumSnmpDevice(this.handler().data().deviceId());
        }
        catch (IOException e) {
            this.log.error("Failed to connect to device: ", (Throwable)e);
            return Collections.emptyList();
        }
        LinkedList ports = Lists.newLinkedList();
        for (OID oid : oids = new OID[]{new OID(".1.3.6.1.4.1.46184.1.4.1.1.3.1"), new OID(".1.3.6.1.4.1.46184.1.4.1.1.3.2")}) {
            for (TreeEvent event : this.snmp.get(oid)) {
                VariableBinding[] varBindings;
                if (event == null) continue;
                for (VariableBinding varBinding : varBindings = event.getVariableBindings()) {
                    if (varBinding.getVariable().toInt() != 1) continue;
                    int portNumber = varBinding.getOid().removeLast();
                    int portDirection = varBinding.getOid().removeLast();
                    DefaultAnnotations ann = DefaultAnnotations.builder().set("portName", portDirection + "-" + portNumber).build();
                    PortDescription p = OmsPortHelper.omsPortDescription((PortNumber)PortNumber.portNumber((long)(ports.size() + 1)), (boolean)true, (Frequency)LumentumSnmpDevice.START_CENTER_FREQ, (Frequency)LumentumSnmpDevice.END_CENTER_FREQ, (Frequency)LumentumSnmpDevice.CHANNEL_SPACING.frequency(), (SparseAnnotations)ann);
                    ports.add(p);
                }
            }
        }
        DefaultAnnotations annLineIn = DefaultAnnotations.builder().set("portName", "LINE IN").build();
        ports.add(OmsPortHelper.omsPortDescription((PortNumber)PortNumber.portNumber((long)(ports.size() + 1)), (boolean)true, (Frequency)LumentumSnmpDevice.START_CENTER_FREQ, (Frequency)LumentumSnmpDevice.END_CENTER_FREQ, (Frequency)LumentumSnmpDevice.CHANNEL_SPACING.frequency(), (SparseAnnotations)annLineIn));
        DefaultAnnotations annLineOut = DefaultAnnotations.builder().set("portName", "LINE OUT").build();
        ports.add(OmsPortHelper.omsPortDescription((PortNumber)PortNumber.portNumber((long)(ports.size() + 1)), (boolean)true, (Frequency)LumentumSnmpDevice.START_CENTER_FREQ, (Frequency)LumentumSnmpDevice.END_CENTER_FREQ, (Frequency)LumentumSnmpDevice.CHANNEL_SPACING.frequency(), (SparseAnnotations)annLineOut));
        return ports;
    }
}

