/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.lumentum;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.onosproject.drivers.lumentum.LumentumSnmpDevice;
import org.onosproject.incubator.net.faultmanagement.alarm.Alarm;
import org.onosproject.incubator.net.faultmanagement.alarm.AlarmConsumer;
import org.onosproject.incubator.net.faultmanagement.alarm.AlarmId;
import org.onosproject.incubator.net.faultmanagement.alarm.DefaultAlarm;
import org.onosproject.net.DeviceId;
import org.onosproject.net.driver.AbstractHandlerBehaviour;
import org.onosproject.snmp.SnmpController;
import org.onosproject.snmp.SnmpDevice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.util.TreeEvent;

public class LumentumAlarmConsumer
extends AbstractHandlerBehaviour
implements AlarmConsumer {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String ALARM_TABLE = ".1.3.6.1.4.1.46184.1.3.2";
    private static final String ALARM_ID = ".1.3.6.1.4.1.46184.1.3.2.1.1";
    private static final OID ALARMS_TABLE_OID = new OID(".1.3.6.1.4.1.46184.1.3.2");
    private static final OID ALARMS_ID_OID = new OID(".1.3.6.1.4.1.46184.1.3.2.1.1");
    private LumentumSnmpDevice snmp;

    public List<Alarm> consumeAlarms() {
        SnmpController controller = (SnmpController)Preconditions.checkNotNull((Object)this.handler().get(SnmpController.class));
        ArrayList alarms = new ArrayList();
        DeviceId deviceId = this.handler().data().deviceId();
        SnmpDevice device = controller.getDevice(deviceId);
        try {
            this.snmp = new LumentumSnmpDevice(device.getSnmpHost(), device.getSnmpPort());
        }
        catch (IOException e) {
            this.log.error("Failed to connect to device: ", (Throwable)e);
        }
        this.snmp.get(ALARMS_TABLE_OID).forEach(alarm -> this.snmp.get(ALARMS_ID_OID).forEach(alarmIdEvent -> {
            int alarmId = this.getAlarmId((TreeEvent)alarmIdEvent);
            alarms.add(new DefaultAlarm.Builder(deviceId, this.getMessage(alarmId), this.getSeverity(alarmId), System.currentTimeMillis()).withId(AlarmId.alarmId((DeviceId)deviceId, (String)String.valueOf(alarmId))).build());
        }));
        return ImmutableList.copyOf(alarms);
    }

    private int getAlarmId(TreeEvent treeEvents) {
        int n = 0;
        VariableBinding[] varBindings = treeEvents.getVariableBindings();
        VariableBinding[] variableBindingArray = varBindings;
        int n2 = variableBindingArray.length;
        if (n < n2) {
            VariableBinding varBinding = variableBindingArray[n];
            return varBinding.getVariable().toInt();
        }
        return -1;
    }

    private Alarm.SeverityLevel getSeverity(int alarmId) {
        switch (alarmId) {
            case 14: {
                return Alarm.SeverityLevel.INDETERMINATE;
            }
        }
        return Alarm.SeverityLevel.MAJOR;
    }

    private String getMessage(int alarmId) {
        switch (alarmId) {
            case 1: {
                return "Port Los";
            }
            case 2: {
                return "Port Degrade";
            }
            case 3: {
                return "Port High Power";
            }
            case 4: {
                return "Ta Failure";
            }
            case 5: {
                return "Force Apr";
            }
            case 6: {
                return "Force Shutoff";
            }
            case 7: {
                return "Gain Oor";
            }
            case 8: {
                return "Low Orl";
            }
            case 9: {
                return "Apr";
            }
            case 10: {
                return "Los Shutoff";
            }
            case 11: {
                return "Amp Degrade";
            }
            case 12: {
                return "Channel Los";
            }
            case 13: {
                return "Channel Degrade";
            }
            case 14: {
                return "Unsupported";
            }
        }
        return "Unknown";
    }
}

