/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.lisp.message.impl;

import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onlab.metrics.MetricsService;
import org.onosproject.lisp.ctl.LispController;
import org.onosproject.lisp.ctl.LispMessageListener;
import org.onosproject.lisp.ctl.LispRouterId;
import org.onosproject.lisp.ctl.LispRouterListener;
import org.onosproject.lisp.msg.protocols.LispMessage;
import org.onosproject.net.provider.AbstractProvider;
import org.onosproject.net.provider.ProviderId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class LispMessageProvider
extends AbstractProvider {
    private static final Logger log = LoggerFactory.getLogger(LispMessageProvider.class);
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected LispController controller;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected MetricsService metricsService;
    private static final String SCHEME_NAME = "lisp";
    private static final String MESSAGE_PROVIDER_PACKAGE = "org.onosproject.lisp.provider.message";
    private final InternalDeviceProvider routerListener = new InternalDeviceProvider();
    private final InternalControlMessageListener messageListener = new InternalControlMessageListener();

    public LispMessageProvider() {
        super(new ProviderId(SCHEME_NAME, MESSAGE_PROVIDER_PACKAGE));
    }

    @Activate
    public void activate() {
        this.controller.addRouterListener((LispRouterListener)this.routerListener);
        this.controller.addMessageListener((LispMessageListener)this.messageListener);
        this.attachRouters();
        log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.detachRouters();
        this.controller.removeRouterListener((LispRouterListener)this.routerListener);
        this.controller.removeMessageListener((LispMessageListener)this.messageListener);
        log.info("Stopped");
    }

    private void attachRouters() {
    }

    private void detachRouters() {
    }

    protected void bindController(LispController lispController) {
        this.controller = lispController;
    }

    protected void unbindController(LispController lispController) {
        if (this.controller == lispController) {
            this.controller = null;
        }
    }

    protected void bindMetricsService(MetricsService metricsService) {
        this.metricsService = metricsService;
    }

    protected void unbindMetricsService(MetricsService metricsService) {
        if (this.metricsService == metricsService) {
            this.metricsService = null;
        }
    }

    private class InternalControlMessageListener
    implements LispMessageListener {
        private InternalControlMessageListener() {
        }

        public void handleIncomingMessage(LispRouterId routerId, LispMessage msg) {
        }

        public void handleOutgoingMessage(LispRouterId routerId, LispMessage msg) {
        }
    }

    private class InternalDeviceProvider
    implements LispRouterListener {
        private InternalDeviceProvider() {
        }

        public void routerAdded(LispRouterId routerId) {
        }

        public void routerRemoved(LispRouterId routerId) {
        }

        public void routerChanged(LispRouterId routerId) {
        }
    }
}

