/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ovsdb.controller.driver;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import io.netty.channel.Channel;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.onlab.packet.IpAddress;
import org.onosproject.net.DeviceId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.behaviour.BridgeDescription;
import org.onosproject.net.behaviour.ControllerInfo;
import org.onosproject.net.behaviour.MirroringName;
import org.onosproject.net.behaviour.MirroringStatistics;
import org.onosproject.net.behaviour.QosId;
import org.onosproject.net.behaviour.QueueId;
import org.onosproject.ovsdb.controller.OvsdbBridge;
import org.onosproject.ovsdb.controller.OvsdbClientService;
import org.onosproject.ovsdb.controller.OvsdbInterface;
import org.onosproject.ovsdb.controller.OvsdbMirror;
import org.onosproject.ovsdb.controller.OvsdbNodeId;
import org.onosproject.ovsdb.controller.OvsdbPort;
import org.onosproject.ovsdb.controller.OvsdbPortName;
import org.onosproject.ovsdb.controller.OvsdbPortNumber;
import org.onosproject.ovsdb.controller.OvsdbQos;
import org.onosproject.ovsdb.controller.OvsdbQueue;
import org.onosproject.ovsdb.controller.OvsdbRowStore;
import org.onosproject.ovsdb.controller.OvsdbStore;
import org.onosproject.ovsdb.controller.OvsdbTableStore;
import org.onosproject.ovsdb.controller.driver.OvsdbAgent;
import org.onosproject.ovsdb.controller.driver.OvsdbProviderService;
import org.onosproject.ovsdb.rfc.jsonrpc.Callback;
import org.onosproject.ovsdb.rfc.message.OperationResult;
import org.onosproject.ovsdb.rfc.message.TableUpdates;
import org.onosproject.ovsdb.rfc.notation.Column;
import org.onosproject.ovsdb.rfc.notation.Condition;
import org.onosproject.ovsdb.rfc.notation.Mutation;
import org.onosproject.ovsdb.rfc.notation.OvsdbMap;
import org.onosproject.ovsdb.rfc.notation.OvsdbSet;
import org.onosproject.ovsdb.rfc.notation.Row;
import org.onosproject.ovsdb.rfc.notation.Uuid;
import org.onosproject.ovsdb.rfc.operations.Delete;
import org.onosproject.ovsdb.rfc.operations.Insert;
import org.onosproject.ovsdb.rfc.operations.Mutate;
import org.onosproject.ovsdb.rfc.operations.Operation;
import org.onosproject.ovsdb.rfc.operations.Update;
import org.onosproject.ovsdb.rfc.schema.ColumnSchema;
import org.onosproject.ovsdb.rfc.schema.DatabaseSchema;
import org.onosproject.ovsdb.rfc.schema.TableSchema;
import org.onosproject.ovsdb.rfc.table.Bridge;
import org.onosproject.ovsdb.rfc.table.Controller;
import org.onosproject.ovsdb.rfc.table.Interface;
import org.onosproject.ovsdb.rfc.table.Mirror;
import org.onosproject.ovsdb.rfc.table.OvsdbTable;
import org.onosproject.ovsdb.rfc.table.Port;
import org.onosproject.ovsdb.rfc.table.Qos;
import org.onosproject.ovsdb.rfc.table.Queue;
import org.onosproject.ovsdb.rfc.table.TableGenerator;
import org.onosproject.ovsdb.rfc.utils.ConditionUtil;
import org.onosproject.ovsdb.rfc.utils.FromJsonUtil;
import org.onosproject.ovsdb.rfc.utils.JsonRpcWriterUtil;
import org.onosproject.ovsdb.rfc.utils.MutationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultOvsdbClient
implements OvsdbProviderService,
OvsdbClientService {
    private static final int TRANSACTCONFIG_TIMEOUT = 3;
    private final Logger log = LoggerFactory.getLogger(DefaultOvsdbClient.class);
    private Channel channel;
    private OvsdbAgent agent;
    private boolean connected;
    private OvsdbNodeId nodeId;
    private Callback monitorCallBack;
    private OvsdbStore ovsdbStore = new OvsdbStore();
    private final Map<String, String> requestMethod = Maps.newHashMap();
    private final Map<String, SettableFuture<? extends Object>> requestResult = Maps.newHashMap();
    private final Map<String, DatabaseSchema> schema = Maps.newHashMap();

    public DefaultOvsdbClient(OvsdbNodeId nodeId) {
        this.nodeId = nodeId;
    }

    @Override
    public OvsdbNodeId nodeId() {
        return this.nodeId;
    }

    @Override
    public void setAgent(OvsdbAgent agent) {
        if (this.agent == null) {
            this.agent = agent;
        }
    }

    @Override
    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    @Override
    public void setConnection(boolean connected) {
        this.connected = connected;
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public void nodeAdded() {
        this.agent.addConnectedNode(this.nodeId, this);
    }

    @Override
    public void nodeRemoved() {
        this.agent.removeConnectedNode(this.nodeId);
        this.channel.disconnect();
    }

    private OvsdbTableStore getTableStore(String dbName) {
        if (this.ovsdbStore == null) {
            return null;
        }
        return this.ovsdbStore.getOvsdbTableStore(dbName);
    }

    private OvsdbRowStore getRowStore(String dbName, String tableName) {
        OvsdbTableStore tableStore = this.getTableStore(dbName);
        if (tableStore == null) {
            return null;
        }
        OvsdbRowStore rowStore = tableStore.getRows(tableName);
        if (rowStore == null) {
            rowStore = new OvsdbRowStore();
        }
        return rowStore;
    }

    @Override
    public Row getRow(String dbName, String tableName, String uuid) {
        OvsdbTableStore tableStore = this.getTableStore(dbName);
        if (tableStore == null) {
            return null;
        }
        OvsdbRowStore rowStore = tableStore.getRows(tableName);
        if (rowStore == null) {
            return null;
        }
        return rowStore.getRow(uuid);
    }

    @Override
    public void removeRow(String dbName, String tableName, String uuid) {
        OvsdbTableStore tableStore = this.getTableStore(dbName);
        if (tableStore == null) {
            return;
        }
        OvsdbRowStore rowStore = tableStore.getRows(tableName);
        if (rowStore == null) {
            return;
        }
        rowStore.deleteRow(uuid);
    }

    @Override
    public void updateOvsdbStore(String dbName, String tableName, String uuid, Row row) {
        OvsdbRowStore rowStore;
        OvsdbTableStore tableStore = this.ovsdbStore.getOvsdbTableStore(dbName);
        if (tableStore == null) {
            tableStore = new OvsdbTableStore();
        }
        if ((rowStore = tableStore.getRows(tableName)) == null) {
            rowStore = new OvsdbRowStore();
        }
        rowStore.insertRow(uuid, row);
        tableStore.createOrUpdateTable(tableName, rowStore);
        this.ovsdbStore.createOrUpdateOvsdbStore(dbName, tableStore);
    }

    @Override
    public String getMirrorUuid(String mirrorName) {
        DatabaseSchema dbSchema = this.schema.get("Open_vSwitch");
        OvsdbRowStore rowStore = this.getRowStore("Open_vSwitch", "Mirror");
        if (rowStore == null) {
            this.log.warn("The mirror uuid is null");
            return null;
        }
        ConcurrentMap<String, Row> mirrorTableRows = rowStore.getRowStore();
        if (mirrorTableRows == null) {
            this.log.warn("The mirror uuid is null");
            return null;
        }
        for (String uuid : mirrorTableRows.keySet()) {
            Mirror mirror = (Mirror)TableGenerator.getTable((DatabaseSchema)dbSchema, (Row)((Row)mirrorTableRows.get(uuid)), (OvsdbTable)OvsdbTable.MIRROR);
            String name = mirror.getName();
            if (!name.contains(mirrorName)) continue;
            return uuid;
        }
        this.log.warn("Mirroring not found");
        return null;
    }

    @Override
    public Set<MirroringStatistics> getMirroringStatistics(DeviceId deviceId) {
        Uuid bridgeUuid = this.getBridgeUuid(deviceId);
        if (bridgeUuid == null) {
            this.log.warn("Couldn't find bridge {} in {}", (Object)deviceId, (Object)this.nodeId.getIpAddress());
            return null;
        }
        List<MirroringStatistics> mirrorings = this.getMirrorings(bridgeUuid);
        if (mirrorings == null) {
            this.log.warn("Couldn't find mirrors in {}", (Object)this.nodeId.getIpAddress());
            return null;
        }
        return ImmutableSet.copyOf(mirrorings);
    }

    private List<MirroringStatistics> getMirrorings(Uuid bridgeUuid) {
        DatabaseSchema dbSchema = this.schema.get("Open_vSwitch");
        if (dbSchema == null) {
            this.log.warn("Unable to retrieve dbSchema {}", (Object)"Open_vSwitch");
            return null;
        }
        OvsdbRowStore rowStore = this.getRowStore("Open_vSwitch", "Bridge");
        if (rowStore == null) {
            this.log.warn("Unable to retrieve rowStore {} of {}", (Object)"Bridge", (Object)"Open_vSwitch");
            return null;
        }
        Row bridgeRow = rowStore.getRow(bridgeUuid.value());
        Bridge bridge = (Bridge)TableGenerator.getTable((DatabaseSchema)dbSchema, (Row)bridgeRow, (OvsdbTable)OvsdbTable.BRIDGE);
        Set mirroringsUuids = ((OvsdbSet)bridge.getMirrorsColumn().data()).set();
        OvsdbRowStore mirrorRowStore = this.getRowStore("Open_vSwitch", "Mirror");
        if (mirrorRowStore == null) {
            this.log.warn("Unable to retrieve rowStore {} of {}", (Object)"Mirror", (Object)"Open_vSwitch");
            return null;
        }
        ArrayList mirroringStatistics = new ArrayList();
        ConcurrentMap<String, Row> mirrorTableRows = mirrorRowStore.getRowStore();
        mirrorTableRows.forEach((key, row) -> {
            if (!mirroringsUuids.contains(Uuid.uuid((String)key))) {
                return;
            }
            Mirror mirror = (Mirror)TableGenerator.getTable((DatabaseSchema)dbSchema, (Row)row, (OvsdbTable)OvsdbTable.MIRROR);
            mirroringStatistics.add(MirroringStatistics.mirroringStatistics((String)mirror.getName(), (Map)((OvsdbMap)mirror.getStatisticsColumn().data()).map()));
        });
        return ImmutableList.copyOf(mirroringStatistics);
    }

    @Override
    public String getPortUuid(String portName, String bridgeUuid) {
        Row bridgeRow;
        DatabaseSchema dbSchema = this.schema.get("Open_vSwitch");
        Bridge bridge = (Bridge)TableGenerator.getTable((DatabaseSchema)dbSchema, (Row)(bridgeRow = this.getRow("Open_vSwitch", "Bridge", bridgeUuid)), (OvsdbTable)OvsdbTable.BRIDGE);
        if (bridge != null) {
            OvsdbSet setPorts = (OvsdbSet)bridge.getPortsColumn().data();
            Set ports = setPorts.set();
            if (ports == null || ports.isEmpty()) {
                this.log.warn("The port uuid is null");
                return null;
            }
            for (Uuid uuid : ports) {
                Row portRow = this.getRow("Open_vSwitch", "Port", uuid.value());
                Port port = (Port)TableGenerator.getTable((DatabaseSchema)dbSchema, (Row)portRow, (OvsdbTable)OvsdbTable.PORT);
                if (port == null || !portName.equalsIgnoreCase(port.getName())) continue;
                return uuid.value();
            }
        }
        return null;
    }

    @Override
    public String getBridgeUuid(String bridgeName) {
        DatabaseSchema dbSchema = this.schema.get("Open_vSwitch");
        OvsdbRowStore rowStore = this.getRowStore("Open_vSwitch", "Bridge");
        if (rowStore == null) {
            this.log.debug("The bridge uuid is null");
            return null;
        }
        ConcurrentMap<String, Row> bridgeTableRows = rowStore.getRowStore();
        if (bridgeTableRows == null) {
            this.log.debug("The bridge uuid is null");
            return null;
        }
        for (String uuid : bridgeTableRows.keySet()) {
            Bridge bridge = (Bridge)TableGenerator.getTable((DatabaseSchema)dbSchema, (Row)((Row)bridgeTableRows.get(uuid)), (OvsdbTable)OvsdbTable.BRIDGE);
            if (!bridge.getName().equals(bridgeName)) continue;
            return uuid;
        }
        return null;
    }

    private String getOvsUuid(String dbName) {
        OvsdbRowStore rowStore = this.getRowStore("Open_vSwitch", "Open_vSwitch");
        if (rowStore == null) {
            this.log.debug("The bridge uuid is null");
            return null;
        }
        ConcurrentMap<String, Row> ovsTableRows = rowStore.getRowStore();
        if (ovsTableRows != null) {
            for (String uuid : ovsTableRows.keySet()) {
                Row row = (Row)ovsTableRows.get(uuid);
                String tableName = row.tableName();
                if (!tableName.equals(dbName)) continue;
                return uuid;
            }
        }
        return null;
    }

    @Override
    public void createPort(String bridgeName, String portName) {
        String bridgeUuid = this.getBridgeUuid(bridgeName);
        if (bridgeUuid == null) {
            this.log.error("Can't find bridge {} in {}", (Object)bridgeName, (Object)this.nodeId.getIpAddress());
            return;
        }
        DatabaseSchema dbSchema = this.schema.get("Open_vSwitch");
        String portUuid = this.getPortUuid(portName, bridgeUuid);
        Port port = (Port)TableGenerator.createTable((DatabaseSchema)dbSchema, (OvsdbTable)OvsdbTable.PORT);
        port.setName(portName);
        if (portUuid == null) {
            this.insertConfig("Port", "_uuid", "Bridge", "ports", bridgeUuid, port.getRow());
        }
    }

    @Override
    public void dropPort(String bridgeName, String portName) {
        String bridgeUuid = this.getBridgeUuid(bridgeName);
        if (bridgeUuid == null) {
            this.log.error("Could not find Bridge {} in {}", (Object)bridgeName, (Object)this.nodeId);
            return;
        }
        String portUuid = this.getPortUuid(portName, bridgeUuid);
        if (portUuid != null) {
            this.log.info("Port {} delete", (Object)portName);
            this.deleteConfig("Port", "_uuid", portUuid, "Bridge", "ports", Uuid.uuid((String)portUuid));
        }
    }

    @Override
    @Deprecated
    public void createBridge(String bridgeName) {
        OvsdbBridge ovsdbBridge = OvsdbBridge.builder().name(bridgeName).build();
        this.createBridge(ovsdbBridge);
    }

    @Override
    @Deprecated
    public void createBridge(String bridgeName, String dpid, String exPortName) {
        OvsdbBridge ovsdbBridge = OvsdbBridge.builder().name(bridgeName).failMode(BridgeDescription.FailMode.SECURE).datapathId(dpid).disableInBand().controllers(Lists.newArrayList((Object[])new ControllerInfo[]{this.localController()})).build();
        this.createBridge(ovsdbBridge);
        if (exPortName != null) {
            this.createPort(bridgeName, exPortName);
        }
    }

    @Override
    @Deprecated
    public boolean createBridge(String bridgeName, String dpid, List<ControllerInfo> controllers) {
        OvsdbBridge ovsdbBridge = OvsdbBridge.builder().name(bridgeName).failMode(BridgeDescription.FailMode.SECURE).datapathId(dpid).disableInBand().controllers(controllers).build();
        return this.createBridge(ovsdbBridge);
    }

    @Override
    public boolean createBridge(OvsdbBridge ovsdbBridge) {
        String bridgeUuid;
        DatabaseSchema dbSchema = this.schema.get("Open_vSwitch");
        String ovsUuid = this.getOvsUuid("Open_vSwitch");
        if (dbSchema == null || ovsUuid == null) {
            this.log.error("Can't find database Open_vSwitch");
            return false;
        }
        Bridge bridge = (Bridge)TableGenerator.createTable((DatabaseSchema)dbSchema, (OvsdbTable)OvsdbTable.BRIDGE);
        bridge.setOtherConfig(ovsdbBridge.otherConfigs());
        if (ovsdbBridge.failMode().isPresent()) {
            String failMode = ovsdbBridge.failMode().get().name().toLowerCase();
            bridge.setFailMode((Set)Sets.newHashSet((Object[])new String[]{failMode}));
        }
        if ((bridgeUuid = this.getBridgeUuid(ovsdbBridge.name())) == null) {
            bridge.setName(ovsdbBridge.name());
            bridgeUuid = this.insertConfig("Bridge", "_uuid", "Open_vSwitch", "bridges", ovsUuid, bridge.getRow());
        } else {
            this.updateConfig("Bridge", "_uuid", bridgeUuid, bridge.getRow());
        }
        if (bridgeUuid == null) {
            this.log.warn("Failed to create bridge {} on {}", (Object)ovsdbBridge.name(), (Object)this.nodeId);
            return false;
        }
        this.createPort(ovsdbBridge.name(), ovsdbBridge.name());
        this.setControllersWithUuid(Uuid.uuid((String)bridgeUuid), ovsdbBridge.controllers());
        this.log.info("Created bridge {}", (Object)ovsdbBridge.name());
        return true;
    }

    @Override
    public ControllerInfo localController() {
        IpAddress ipAddress = IpAddress.valueOf((InetAddress)((InetSocketAddress)this.channel.localAddress()).getAddress());
        return new ControllerInfo(ipAddress, 6653, "tcp");
    }

    private void setControllersWithUuid(Uuid bridgeUuid, List<ControllerInfo> controllers) {
        DatabaseSchema dbSchema = this.schema.get("Open_vSwitch");
        if (dbSchema == null) {
            this.log.debug("There is no schema");
            return;
        }
        List<Controller> oldControllers = this.getControllers(bridgeUuid);
        if (oldControllers == null) {
            this.log.warn("There are no controllers");
            return;
        }
        HashSet newControllerUuids = new HashSet();
        HashSet<ControllerInfo> newControllers = new HashSet<ControllerInfo>(controllers);
        ArrayList removeControllers = new ArrayList();
        oldControllers.forEach(controller -> {
            ControllerInfo controllerInfo = new ControllerInfo((String)controller.getTargetColumn().data());
            if (newControllers.contains(controllerInfo)) {
                newControllers.remove(controllerInfo);
                newControllerUuids.add(controller.getRow().uuid());
            } else {
                removeControllers.add(controller);
            }
        });
        OvsdbRowStore controllerRowStore = this.getRowStore("Open_vSwitch", "Controller");
        if (controllerRowStore == null) {
            this.log.debug("There is no controller table");
            return;
        }
        removeControllers.forEach(c -> this.deleteConfig("Controller", "_uuid", c.getRow().uuid().value(), "Bridge", "controller", c.getRow().uuid()));
        newControllers.stream().map(c -> {
            Controller controller = (Controller)TableGenerator.createTable((DatabaseSchema)dbSchema, (OvsdbTable)OvsdbTable.CONTROLLER);
            controller.setTarget(c.target());
            return controller;
        }).forEach(c -> {
            String uuid = this.insertConfig("Controller", "_uuid", "Bridge", "controller", bridgeUuid.value(), c.getRow());
            newControllerUuids.add(Uuid.uuid((String)uuid));
        });
        OvsdbRowStore rowStore = this.getRowStore("Open_vSwitch", "Bridge");
        if (rowStore == null) {
            this.log.debug("There is no bridge table");
            return;
        }
        Row bridgeRow = rowStore.getRow(bridgeUuid.value());
        Bridge bridge = (Bridge)TableGenerator.getTable((DatabaseSchema)dbSchema, (Row)bridgeRow, (OvsdbTable)OvsdbTable.BRIDGE);
        bridge.setController(OvsdbSet.ovsdbSet(newControllerUuids));
        this.updateConfig("Bridge", "_uuid", bridgeUuid.value(), bridge.getRow());
    }

    @Override
    public void setControllersWithDeviceId(DeviceId deviceId, List<ControllerInfo> controllers) {
        this.setControllersWithUuid(this.getBridgeUuid(deviceId), controllers);
    }

    @Override
    public void dropBridge(String bridgeName) {
        String bridgeUuid = this.getBridgeUuid(bridgeName);
        if (bridgeUuid == null) {
            this.log.warn("Could not find bridge in node", (Object)this.nodeId.getIpAddress());
            return;
        }
        this.deleteConfig("Bridge", "_uuid", bridgeUuid, "Open_vSwitch", "bridges", Uuid.uuid((String)bridgeUuid));
    }

    @Override
    public void applyQos(PortNumber portNumber, String qosName) {
        DatabaseSchema dbSchema = this.schema.get("Open_vSwitch");
        OvsdbRowStore portRowStore = this.getRowStore("Open_vSwitch", "Port");
        if (portRowStore == null) {
            this.log.debug("The port uuid is null");
            return;
        }
        OvsdbRowStore qosRowStore = this.getRowStore("Open_vSwitch", "QoS");
        if (qosRowStore == null) {
            this.log.debug("The qos uuid is null");
            return;
        }
        ConcurrentMap<String, Row> qosTableRows = qosRowStore.getRowStore();
        ConcurrentMap<String, Row> portTableRows = portRowStore.getRowStore();
        Row qosRow = qosTableRows.values().stream().filter(r -> {
            OvsdbMap ovsdbMap = (OvsdbMap)r.getColumn("external_ids").data();
            return qosName.equals(ovsdbMap.map().get("onos-qos-id"));
        }).findFirst().orElse(null);
        Row portRow = portTableRows.values().stream().filter(r -> r.getColumn("name").data().equals(portNumber.name())).findFirst().orElse(null);
        if (portRow != null && qosRow != null) {
            String qosId = qosRow.uuid().value();
            Uuid portUuid = portRow.uuid();
            HashMap<String, Column> columns = new HashMap<String, Column>();
            Row newPortRow = new Row("Port", portUuid, columns);
            Port newport = new Port(dbSchema, newPortRow);
            columns.put(Port.PortColumn.QOS.columnName(), newport.getQosColumn());
            newport.setQos(Uuid.uuid((String)qosId));
            this.updateConfig("Port", "_uuid", portUuid.value(), newport.getRow());
        }
    }

    @Override
    public void removeQos(PortNumber portNumber) {
        DatabaseSchema dbSchema = this.schema.get("Open_vSwitch");
        OvsdbRowStore rowStore = this.getRowStore("Open_vSwitch", "Port");
        if (rowStore == null) {
            this.log.debug("The qos uuid is null");
            return;
        }
        ConcurrentMap<String, Row> ovsTableRows = rowStore.getRowStore();
        Row portRow = ovsTableRows.values().stream().filter(r -> r.getColumn("name").data().equals(portNumber.name())).findFirst().orElse(null);
        if (portRow == null) {
            this.log.warn("Couldn't find port {} in ovsdb port table.", (Object)portNumber.name());
            return;
        }
        OvsdbSet ovsdbSet = (OvsdbSet)portRow.getColumn("qos").data();
        Set qosIdSet = ovsdbSet.set();
        if (qosIdSet == null || qosIdSet.isEmpty()) {
            return;
        }
        Uuid qosUuid = (Uuid)qosIdSet.toArray()[0];
        Condition condition = ConditionUtil.isEqual((String)"_uuid", (Object)portRow.uuid());
        ArrayList conditions = Lists.newArrayList((Object[])new Condition[]{condition});
        Mutation mutation = MutationUtil.delete((String)"qos", (Object)qosUuid);
        ArrayList mutations = Lists.newArrayList((Object[])new Mutation[]{mutation});
        ArrayList operations = Lists.newArrayList();
        Mutate mutate = new Mutate(dbSchema.getTableSchema("Port"), (List)conditions, (List)mutations);
        operations.add(mutate);
        this.transactConfig("Open_vSwitch", operations);
    }

    @Override
    public boolean createQos(OvsdbQos ovsdbQos) {
        DatabaseSchema dbSchema = this.schema.get("Open_vSwitch");
        Qos qos = (Qos)TableGenerator.createTable((DatabaseSchema)dbSchema, (OvsdbTable)OvsdbTable.QOS);
        OvsdbRowStore rowStore = this.getRowStore("Open_vSwitch", "QoS");
        if (rowStore == null) {
            this.log.debug("The qos uuid is null");
            return false;
        }
        ArrayList operations = Lists.newArrayList();
        HashSet types = Sets.newHashSet();
        HashMap queues = Maps.newHashMap();
        types.add(ovsdbQos.qosType());
        qos.setOtherConfig(ovsdbQos.otherConfigs());
        qos.setExternalIds(ovsdbQos.externalIds());
        qos.setType((Set)types);
        if (ovsdbQos.qosQueues().isPresent()) {
            for (Map.Entry<Long, String> entry : ovsdbQos.qosQueues().get().entrySet()) {
                ConcurrentMap<String, Row> queueTableRows;
                Row queueRow;
                OvsdbRowStore queueRowStore = this.getRowStore("Open_vSwitch", "Queue");
                if (queueRowStore == null || (queueRow = (Row)(queueTableRows = queueRowStore.getRowStore()).values().stream().filter(r -> {
                    OvsdbMap ovsdbMap = (OvsdbMap)r.getColumn("external_ids").data();
                    return ((String)entry.getValue()).equals(ovsdbMap.map().get("onos-queue-id"));
                }).findFirst().orElse(null)) == null) continue;
                queues.put(entry.getKey(), queueRow.uuid());
            }
            qos.setQueues((Map)queues);
        }
        Insert qosInsert = new Insert(dbSchema.getTableSchema("QoS"), "QoS", qos.getRow());
        operations.add(qosInsert);
        try {
            this.transactConfig("Open_vSwitch", operations).get();
        }
        catch (InterruptedException | ExecutionException e) {
            return false;
        }
        return true;
    }

    @Override
    public void dropQos(QosId qosId) {
        ConcurrentMap<String, Row> qosTableRows;
        Row qosRow;
        OvsdbRowStore rowStore = this.getRowStore("Open_vSwitch", "QoS");
        if (rowStore != null && (qosRow = (Row)(qosTableRows = rowStore.getRowStore()).values().stream().filter(r -> {
            OvsdbMap ovsdbMap = (OvsdbMap)r.getColumn("external_ids").data();
            return qosId.name().equals(ovsdbMap.map().get("onos-qos-id"));
        }).findFirst().orElse(null)) != null) {
            this.deleteConfig("QoS", "_uuid", qosRow.uuid().value(), "Port", "qos", qosRow.uuid());
        }
    }

    @Override
    public OvsdbQos getQos(QosId qosId) {
        Set<OvsdbQos> ovsdbQoses = this.getQoses();
        return ovsdbQoses.stream().filter(r -> qosId.name().equals(r.externalIds().get("onos-qos-id"))).findFirst().orElse(null);
    }

    @Override
    public Set<OvsdbQos> getQoses() {
        HashSet<OvsdbQos> ovsdbQoses = new HashSet<OvsdbQos>();
        OvsdbRowStore rowStore = this.getRowStore("Open_vSwitch", "QoS");
        if (rowStore == null) {
            this.log.debug("The qos uuid is null");
            return ovsdbQoses;
        }
        ConcurrentMap<String, Row> rows = rowStore.getRowStore();
        for (String uuid : rows.keySet()) {
            Row row = this.getRow("Open_vSwitch", "QoS", uuid);
            OvsdbQos ovsdbQos = this.getOvsdbQos(row);
            if (ovsdbQos == null) continue;
            ovsdbQoses.add(ovsdbQos);
        }
        return ovsdbQoses;
    }

    @Override
    public boolean createQueue(OvsdbQueue ovsdbQueue) {
        DatabaseSchema dbSchema = this.schema.get("Open_vSwitch");
        Queue queue = (Queue)TableGenerator.createTable((DatabaseSchema)dbSchema, (OvsdbTable)OvsdbTable.QUEUE);
        ArrayList operations = Lists.newArrayList();
        OvsdbRowStore rowStore = this.getRowStore("Open_vSwitch", "Queue");
        if (rowStore == null) {
            this.log.debug("The queue uuid is null");
            return false;
        }
        if (ovsdbQueue.dscp().isPresent()) {
            queue.setDscp((Set)ImmutableSet.of((Object)ovsdbQueue.dscp().get()));
        }
        queue.setOtherConfig(ovsdbQueue.otherConfigs());
        queue.setExternalIds(ovsdbQueue.externalIds());
        Insert queueInsert = new Insert(dbSchema.getTableSchema("Queue"), "Queue", queue.getRow());
        operations.add(queueInsert);
        try {
            this.transactConfig("Open_vSwitch", operations).get();
        }
        catch (InterruptedException | ExecutionException e) {
            this.log.error("createQueue transactConfig get exception !");
        }
        return true;
    }

    @Override
    public void dropQueue(QueueId queueId) {
        OvsdbRowStore queueRowStore = this.getRowStore("Open_vSwitch", "Queue");
        if (queueRowStore == null) {
            return;
        }
        ConcurrentMap<String, Row> queueTableRows = queueRowStore.getRowStore();
        Row queueRow = queueTableRows.values().stream().filter(r -> {
            OvsdbMap ovsdbMap = (OvsdbMap)r.getColumn("external_ids").data();
            return queueId.name().equals(ovsdbMap.map().get("onos-queue-id"));
        }).findFirst().orElse(null);
        if (queueRow == null) {
            return;
        }
        String queueUuid = queueRow.uuid().value();
        OvsdbRowStore qosRowStore = this.getRowStore("Open_vSwitch", "QoS");
        if (qosRowStore != null) {
            HashMap queueMap = new HashMap();
            ConcurrentMap<String, Row> qosTableRows = qosRowStore.getRowStore();
            qosTableRows.values().stream().filter(r -> {
                Map ovsdbMap = ((OvsdbMap)r.getColumn("queues").data()).map();
                Set keySet = ovsdbMap.keySet();
                for (Integer keyId : keySet) {
                    if (!((Uuid)ovsdbMap.get(keyId)).equals((Object)Uuid.uuid((String)queueUuid))) continue;
                    queueMap.put(keyId.longValue(), Uuid.uuid((String)queueUuid));
                    return true;
                }
                return false;
            }).findFirst().orElse(null);
            this.deleteConfig("Queue", "_uuid", queueUuid, "QoS", "queues", OvsdbMap.ovsdbMap(queueMap));
        } else {
            this.deleteConfig("Queue", "_uuid", queueUuid, null, null, null);
        }
    }

    @Override
    public OvsdbQueue getQueue(QueueId queueId) {
        Set<OvsdbQueue> ovsdbQueues = this.getQueues();
        return ovsdbQueues.stream().filter(r -> queueId.name().equals(r.externalIds().get("onos-queue-id"))).findFirst().orElse(null);
    }

    @Override
    public Set<OvsdbQueue> getQueues() {
        HashSet<OvsdbQueue> ovsdbqueues = new HashSet<OvsdbQueue>();
        OvsdbRowStore rowStore = this.getRowStore("Open_vSwitch", "Queue");
        if (rowStore == null) {
            this.log.debug("The queue uuid is null");
            return ovsdbqueues;
        }
        ConcurrentMap<String, Row> rows = rowStore.getRowStore();
        for (String uuid : rows.keySet()) {
            Row row = this.getRow("Open_vSwitch", "Queue", uuid);
            OvsdbQueue ovsdbQueue = this.getOvsdbQueue(row);
            if (ovsdbQueue == null) continue;
            ovsdbqueues.add(ovsdbQueue);
        }
        return ovsdbqueues;
    }

    @Override
    public boolean createMirror(String bridgeName, OvsdbMirror mirror) {
        String bridgeUuid = this.getBridgeUuid(bridgeName);
        if (bridgeUuid == null) {
            this.log.warn("Couldn't find bridge {} in {}", (Object)bridgeName, (Object)this.nodeId.getIpAddress());
            return false;
        }
        OvsdbMirror.Builder mirrorBuilder = OvsdbMirror.builder();
        mirrorBuilder.mirroringName(mirror.mirroringName());
        mirrorBuilder.selectAll(mirror.selectAll());
        mirrorBuilder.monitorDstPorts(mirror.monitorDstPorts().parallelStream().map(dstPort -> {
            String dstPortUuid = this.getPortUuid(dstPort.value(), bridgeUuid);
            if (dstPortUuid != null) {
                return Uuid.uuid((String)dstPortUuid);
            }
            this.log.warn("Couldn't find port {} in {}", (Object)dstPort.value(), (Object)this.nodeId.getIpAddress());
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toSet()));
        mirrorBuilder.monitorSrcPorts(mirror.monitorSrcPorts().parallelStream().map(srcPort -> {
            String srcPortUuid = this.getPortUuid(srcPort.value(), bridgeUuid);
            if (srcPortUuid != null) {
                return Uuid.uuid((String)srcPortUuid);
            }
            this.log.warn("Couldn't find port {} in {}", (Object)srcPort.value(), (Object)this.nodeId.getIpAddress());
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toSet()));
        mirrorBuilder.monitorVlans(mirror.monitorVlans());
        mirrorBuilder.mirrorPort(mirror.mirrorPort());
        mirrorBuilder.mirrorVlan(mirror.mirrorVlan());
        mirrorBuilder.externalIds(mirror.externalIds());
        mirror = mirrorBuilder.build();
        if (mirror.monitorDstPorts().isEmpty() && mirror.monitorSrcPorts().isEmpty() && mirror.monitorVlans().isEmpty()) {
            this.log.warn("Invalid monitoring data");
            return false;
        }
        DatabaseSchema dbSchema = this.schema.get("Open_vSwitch");
        Mirror mirrorEntry = (Mirror)TableGenerator.createTable((DatabaseSchema)dbSchema, (OvsdbTable)OvsdbTable.MIRROR);
        mirrorEntry.setName(mirror.mirroringName());
        mirrorEntry.setSelectDstPort(mirror.monitorDstPorts());
        mirrorEntry.setSelectSrcPort(mirror.monitorSrcPorts());
        mirrorEntry.setSelectVlan(mirror.monitorVlans());
        mirrorEntry.setExternalIds(mirror.externalIds());
        if (mirror.mirrorPort() != null) {
            String outputPortUuid = this.getPortUuid(mirror.mirrorPort().value(), bridgeUuid);
            if (outputPortUuid == null) {
                this.log.warn("Couldn't find port {} in {}", (Object)mirror.mirrorPort().value(), (Object)this.nodeId.getIpAddress());
                return false;
            }
            mirrorEntry.setOutputPort(Uuid.uuid((String)outputPortUuid));
        } else if (mirror.mirrorVlan() != null) {
            mirrorEntry.setOutputVlan(mirror.mirrorVlan());
        } else {
            this.log.warn("Invalid mirror, no mirror port and no mirror vlan");
            return false;
        }
        ArrayList operations = Lists.newArrayList();
        Insert mirrorInsert = new Insert(dbSchema.getTableSchema("Mirror"), "Mirror", mirrorEntry.getRow());
        operations.add(mirrorInsert);
        Condition condition = ConditionUtil.isEqual((String)"_uuid", (Object)Uuid.uuid((String)bridgeUuid));
        Mutation mutation = MutationUtil.insert((String)"mirrors", (Object)Uuid.uuid((String)"Mirror"));
        ArrayList conditions = Lists.newArrayList((Object[])new Condition[]{condition});
        ArrayList mutations = Lists.newArrayList((Object[])new Mutation[]{mutation});
        operations.add(new Mutate(dbSchema.getTableSchema("Bridge"), (List)conditions, (List)mutations));
        this.transactConfig("Open_vSwitch", operations);
        this.log.info("Created mirror {}", (Object)mirror.mirroringName());
        return true;
    }

    @Override
    public void dropMirror(MirroringName mirroringName) {
        String mirrorUuid = this.getMirrorUuid(mirroringName.name());
        if (mirrorUuid != null) {
            this.log.info("Deleted mirror {}", (Object)mirroringName.name());
            this.deleteConfig("Mirror", "_uuid", mirrorUuid, "Bridge", "mirrors", Uuid.uuid((String)mirrorUuid));
        }
        this.log.warn("Unable to delete {}", (Object)mirroringName.name());
    }

    @Override
    @Deprecated
    public boolean createTunnel(String bridgeName, String ifaceName, String tunnelType, Map<String, String> options) {
        OvsdbInterface ovsdbIface = OvsdbInterface.builder().name(ifaceName).type(OvsdbInterface.Type.valueOf(tunnelType)).options(options).build();
        return this.createInterface(bridgeName, ovsdbIface);
    }

    @Override
    @Deprecated
    public void dropTunnel(IpAddress srcIp, IpAddress dstIp) {
    }

    @Override
    public boolean createInterface(String bridgeName, OvsdbInterface ovsdbIface) {
        String bridgeUuid = this.getBridgeUuid(bridgeName);
        if (bridgeUuid == null) {
            this.log.warn("Couldn't find bridge {} in {}", (Object)bridgeName, (Object)this.nodeId.getIpAddress());
            return false;
        }
        if (this.getPortUuid(ovsdbIface.name(), bridgeUuid) != null) {
            this.log.warn("Interface {} already exists", (Object)ovsdbIface.name());
            return false;
        }
        ArrayList operations = Lists.newArrayList();
        DatabaseSchema dbSchema = this.schema.get("Open_vSwitch");
        Port port = (Port)TableGenerator.createTable((DatabaseSchema)dbSchema, (OvsdbTable)OvsdbTable.PORT);
        port.setName(ovsdbIface.name());
        Insert portInsert = new Insert(dbSchema.getTableSchema("Port"), "Port", port.getRow());
        portInsert.getRow().put("interfaces", Uuid.uuid((String)"Interface"));
        operations.add(portInsert);
        Condition condition = ConditionUtil.isEqual((String)"_uuid", (Object)Uuid.uuid((String)bridgeUuid));
        Mutation mutation = MutationUtil.insert((String)"ports", (Object)Uuid.uuid((String)"Port"));
        ArrayList conditions = Lists.newArrayList((Object[])new Condition[]{condition});
        ArrayList mutations = Lists.newArrayList((Object[])new Mutation[]{mutation});
        operations.add(new Mutate(dbSchema.getTableSchema("Bridge"), (List)conditions, (List)mutations));
        Interface intf = (Interface)TableGenerator.createTable((DatabaseSchema)dbSchema, (OvsdbTable)OvsdbTable.INTERFACE);
        intf.setName(ovsdbIface.name());
        intf.setType(ovsdbIface.typeToString());
        intf.setOptions(ovsdbIface.options());
        Insert intfInsert = new Insert(dbSchema.getTableSchema("Interface"), "Interface", intf.getRow());
        operations.add(intfInsert);
        this.transactConfig("Open_vSwitch", operations);
        this.log.info("Created interface {}", (Object)ovsdbIface);
        return true;
    }

    @Override
    public boolean dropInterface(String ifaceName) {
        OvsdbRowStore rowStore = this.getRowStore("Open_vSwitch", "Bridge");
        if (rowStore == null) {
            this.log.warn("Failed to get BRIDGE table");
            return false;
        }
        ConcurrentMap<String, Row> bridgeTableRows = rowStore.getRowStore();
        if (bridgeTableRows == null) {
            this.log.warn("Failed to get BRIDGE table rows");
            return false;
        }
        Optional<String> bridgeId = bridgeTableRows.keySet().stream().filter(uuid -> this.getPortUuid(ifaceName, (String)uuid) != null).findFirst();
        if (bridgeId.isPresent()) {
            String portId = this.getPortUuid(ifaceName, bridgeId.get());
            this.deleteConfig("Port", "_uuid", portId, "Bridge", "ports", Uuid.uuid((String)portId));
            return true;
        }
        this.log.warn("Unable to find the interface with name {}", (Object)ifaceName);
        return false;
    }

    private void deleteConfig(String childTableName, String childColumnName, String childUuid, String parentTableName, String parentColumnName, Object referencedValue) {
        DatabaseSchema dbSchema = this.schema.get("Open_vSwitch");
        TableSchema childTableSchema = dbSchema.getTableSchema(childTableName);
        ArrayList operations = Lists.newArrayList();
        if (parentTableName != null && parentColumnName != null && referencedValue != null) {
            TableSchema parentTableSchema = dbSchema.getTableSchema(parentTableName);
            ColumnSchema parentColumnSchema = parentTableSchema.getColumnSchema(parentColumnName);
            ArrayList mutations = Lists.newArrayList();
            Mutation mutation = MutationUtil.delete((String)parentColumnSchema.name(), (Object)referencedValue);
            mutations.add(mutation);
            ArrayList conditions = Lists.newArrayList();
            Condition condition = ConditionUtil.includes((String)parentColumnName, (Object)referencedValue);
            conditions.add(condition);
            Mutate op = new Mutate(parentTableSchema, (List)conditions, (List)mutations);
            operations.add(op);
        }
        ArrayList conditions = Lists.newArrayList();
        Condition condition = ConditionUtil.isEqual((String)childColumnName, (Object)Uuid.uuid((String)childUuid));
        conditions.add(condition);
        Delete del = new Delete(childTableSchema, (List)conditions);
        operations.add(del);
        this.transactConfig("Open_vSwitch", operations);
    }

    private void updateConfig(String tableName, String columnName, String uuid, Row row) {
        DatabaseSchema dbSchema = this.schema.get("Open_vSwitch");
        TableSchema tableSchema = dbSchema.getTableSchema(tableName);
        ArrayList conditions = Lists.newArrayList();
        Condition condition = ConditionUtil.isEqual((String)columnName, (Object)Uuid.uuid((String)uuid));
        conditions.add(condition);
        Update update = new Update(tableSchema, row, (List)conditions);
        ArrayList operations = Lists.newArrayList();
        operations.add(update);
        this.transactConfig("Open_vSwitch", operations);
    }

    private String insertConfig(String childTableName, String childColumnName, String parentTableName, String parentColumnName, String parentUuid, Row row) {
        DatabaseSchema dbSchema = this.schema.get("Open_vSwitch");
        TableSchema tableSchema = dbSchema.getTableSchema(childTableName);
        Insert insert = new Insert(tableSchema, childTableName, row);
        ArrayList operations = Lists.newArrayList();
        operations.add(insert);
        if (parentTableName != null && parentColumnName != null) {
            TableSchema parentTableSchema = dbSchema.getTableSchema(parentTableName);
            ColumnSchema parentColumnSchema = parentTableSchema.getColumnSchema(parentColumnName);
            ArrayList mutations = Lists.newArrayList();
            Mutation mutation = MutationUtil.insert((String)parentColumnSchema.name(), (Object)Uuid.uuid((String)childTableName));
            mutations.add(mutation);
            ArrayList conditions = Lists.newArrayList();
            Condition condition = ConditionUtil.isEqual((String)"_uuid", (Object)Uuid.uuid((String)parentUuid));
            conditions.add(condition);
            Mutate op = new Mutate(parentTableSchema, (List)conditions, (List)mutations);
            operations.add(op);
        }
        if (childTableName.equalsIgnoreCase("Port")) {
            this.log.debug("Handle port insert");
            Insert intfInsert = this.handlePortInsertTable(row);
            if (intfInsert != null) {
                operations.add(intfInsert);
            }
            Insert ins = (Insert)operations.get(0);
            ins.getRow().put("interfaces", Uuid.uuid((String)"Interface"));
        }
        try {
            List results = (List)this.transactConfig("Open_vSwitch", operations).get(3L, TimeUnit.SECONDS);
            return ((OperationResult)results.get(0)).getUuid().value();
        }
        catch (TimeoutException e) {
            this.log.warn("TimeoutException thrown while to get result");
        }
        catch (InterruptedException e) {
            this.log.warn("Interrupted while waiting to get result");
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            this.log.error("Exception thrown while to get result");
        }
        return null;
    }

    private Insert handlePortInsertTable(Row portRow) {
        DatabaseSchema dbSchema = this.schema.get("Open_vSwitch");
        TableSchema portTableSchema = dbSchema.getTableSchema("Port");
        ColumnSchema portColumnSchema = portTableSchema.getColumnSchema("name");
        String portName = (String)portRow.getColumn(portColumnSchema.name()).data();
        Interface inf = (Interface)TableGenerator.createTable((DatabaseSchema)dbSchema, (OvsdbTable)OvsdbTable.INTERFACE);
        inf.setName(portName);
        TableSchema intfTableSchema = dbSchema.getTableSchema("Interface");
        return new Insert(intfTableSchema, "Interface", inf.getRow());
    }

    @Override
    public ListenableFuture<DatabaseSchema> getOvsdbSchema(String dbName) {
        if (dbName == null) {
            return null;
        }
        DatabaseSchema databaseSchema = this.schema.get(dbName);
        if (databaseSchema == null) {
            ArrayList<String> dbNames = new ArrayList<String>();
            dbNames.add(dbName);
            Function rowFunction = input -> {
                this.log.debug("Get ovsdb database schema {}", (Object)dbName);
                DatabaseSchema dbSchema = FromJsonUtil.jsonNodeToDbSchema((String)dbName, (JsonNode)input);
                if (dbSchema == null) {
                    this.log.debug("Get ovsdb database schema error");
                    return null;
                }
                this.schema.put(dbName, dbSchema);
                return dbSchema;
            };
            ListenableFuture<JsonNode> input2 = this.getSchema(dbNames);
            if (input2 != null) {
                return Futures.transform(input2, (Function)rowFunction);
            }
            return null;
        }
        return Futures.immediateFuture((Object)databaseSchema);
    }

    @Override
    public ListenableFuture<TableUpdates> monitorTables(String dbName, String id) {
        if (dbName == null) {
            return null;
        }
        DatabaseSchema dbSchema = this.schema.get(dbName);
        if (dbSchema != null) {
            Function rowFunction = input -> {
                this.log.debug("Get table updates");
                TableUpdates updates = FromJsonUtil.jsonNodeToTableUpdates((JsonNode)input, (DatabaseSchema)dbSchema);
                if (updates == null) {
                    this.log.debug("Get table updates error");
                    return null;
                }
                return updates;
            };
            return Futures.transform(this.monitor(dbSchema, id), (Function)rowFunction);
        }
        return null;
    }

    private ListenableFuture<List<OperationResult>> transactConfig(String dbName, List<Operation> operations) {
        if (dbName == null) {
            return null;
        }
        DatabaseSchema dbSchema = this.schema.get(dbName);
        if (dbSchema != null) {
            Function rowFunction = input -> {
                this.log.debug("Get ovsdb operation result");
                List result = FromJsonUtil.jsonNodeToOperationResult((List)input, (List)operations);
                if (result == null) {
                    this.log.debug("The operation result is null");
                    return null;
                }
                return result;
            };
            return Futures.transform(this.transact(dbSchema, operations), (Function)rowFunction);
        }
        return null;
    }

    public ListenableFuture<JsonNode> getSchema(List<String> dbnames) {
        String id = UUID.randomUUID().toString();
        String getSchemaString = JsonRpcWriterUtil.getSchemaStr((String)id, dbnames);
        SettableFuture sf = SettableFuture.create();
        this.requestResult.put(id, (SettableFuture<? extends Object>)sf);
        this.requestMethod.put(id, "getSchema");
        this.channel.writeAndFlush((Object)getSchemaString);
        return sf;
    }

    public ListenableFuture<List<String>> echo() {
        String id = UUID.randomUUID().toString();
        String echoString = JsonRpcWriterUtil.echoStr((String)id);
        SettableFuture sf = SettableFuture.create();
        this.requestResult.put(id, (SettableFuture<? extends Object>)sf);
        this.requestMethod.put(id, "echo");
        this.channel.writeAndFlush((Object)echoString);
        return sf;
    }

    public ListenableFuture<JsonNode> monitor(DatabaseSchema dbSchema, String monitorId) {
        String id = UUID.randomUUID().toString();
        String monitorString = JsonRpcWriterUtil.monitorStr((String)id, (String)monitorId, (DatabaseSchema)dbSchema);
        SettableFuture sf = SettableFuture.create();
        this.requestResult.put(id, (SettableFuture<? extends Object>)sf);
        this.requestMethod.put(id, "monitor");
        this.channel.writeAndFlush((Object)monitorString);
        return sf;
    }

    public ListenableFuture<List<String>> listDbs() {
        String id = UUID.randomUUID().toString();
        String listDbsString = JsonRpcWriterUtil.listDbsStr((String)id);
        SettableFuture sf = SettableFuture.create();
        this.requestResult.put(id, (SettableFuture<? extends Object>)sf);
        this.requestMethod.put(id, "listDbs");
        this.channel.writeAndFlush((Object)listDbsString);
        return sf;
    }

    public ListenableFuture<List<JsonNode>> transact(DatabaseSchema dbSchema, List<Operation> operations) {
        String id = UUID.randomUUID().toString();
        String transactString = JsonRpcWriterUtil.transactStr((String)id, (DatabaseSchema)dbSchema, operations);
        SettableFuture sf = SettableFuture.create();
        this.requestResult.put(id, (SettableFuture<? extends Object>)sf);
        this.requestMethod.put(id, "transact");
        this.channel.writeAndFlush((Object)transactString);
        return sf;
    }

    @Override
    public void processResult(JsonNode response) {
        this.log.debug("Handle result");
        String requestId = response.get("id").asText();
        SettableFuture<? extends Object> sf = this.requestResult.get(requestId);
        if (sf == null) {
            this.log.debug("No such future to process");
            return;
        }
        String methodName = this.requestMethod.get(requestId);
        sf.set(FromJsonUtil.jsonResultParser((JsonNode)response, (String)methodName));
    }

    @Override
    public void processRequest(JsonNode requestJson) {
        this.log.debug("Handle request");
        if (requestJson.get("method").asText().equalsIgnoreCase("echo")) {
            this.log.debug("handle echo request");
            String replyString = FromJsonUtil.getEchoRequestStr((JsonNode)requestJson);
            this.channel.writeAndFlush((Object)replyString);
        } else {
            FromJsonUtil.jsonCallbackRequestParser((JsonNode)requestJson, (Callback)this.monitorCallBack);
        }
    }

    @Override
    public void setCallback(Callback monitorCallback) {
        this.monitorCallBack = monitorCallback;
    }

    @Override
    public Set<OvsdbBridge> getBridges() {
        HashSet<OvsdbBridge> ovsdbBridges = new HashSet<OvsdbBridge>();
        OvsdbTableStore tableStore = this.getTableStore("Open_vSwitch");
        if (tableStore == null) {
            return ovsdbBridges;
        }
        OvsdbRowStore rowStore = tableStore.getRows("Bridge");
        if (rowStore == null) {
            return ovsdbBridges;
        }
        ConcurrentMap<String, Row> rows = rowStore.getRowStore();
        for (String uuid : rows.keySet()) {
            Row row = this.getRow("Open_vSwitch", "Bridge", uuid);
            OvsdbBridge ovsdbBridge = this.getOvsdbBridge(row);
            if (ovsdbBridge == null) continue;
            ovsdbBridges.add(ovsdbBridge);
        }
        return ovsdbBridges;
    }

    @Override
    public Set<ControllerInfo> getControllers(DeviceId openflowDeviceId) {
        Uuid bridgeUuid = this.getBridgeUuid(openflowDeviceId);
        if (bridgeUuid == null) {
            this.log.warn("bad bridge Uuid");
            return null;
        }
        List<Controller> controllers = this.getControllers(bridgeUuid);
        if (controllers == null) {
            this.log.warn("bad list of controllers");
            return null;
        }
        return controllers.stream().map(controller -> new ControllerInfo((String)controller.getTargetColumn().data())).collect(Collectors.toSet());
    }

    private List<Controller> getControllers(Uuid bridgeUuid) {
        DatabaseSchema dbSchema = this.schema.get("Open_vSwitch");
        if (dbSchema == null) {
            return null;
        }
        OvsdbRowStore rowStore = this.getRowStore("Open_vSwitch", "Bridge");
        if (rowStore == null) {
            this.log.debug("There is no bridge table");
            return null;
        }
        Row bridgeRow = rowStore.getRow(bridgeUuid.value());
        Bridge bridge = (Bridge)TableGenerator.getTable((DatabaseSchema)dbSchema, (Row)bridgeRow, (OvsdbTable)OvsdbTable.BRIDGE);
        this.log.warn("type of controller column", bridge.getControllerColumn().data().getClass());
        Set controllerUuids = ((OvsdbSet)bridge.getControllerColumn().data()).set();
        OvsdbRowStore controllerRowStore = this.getRowStore("Open_vSwitch", "Controller");
        if (controllerRowStore == null) {
            this.log.debug("There is no controller table");
            return null;
        }
        ArrayList<Controller> ovsdbControllers = new ArrayList<Controller>();
        ConcurrentMap<String, Row> controllerTableRows = controllerRowStore.getRowStore();
        controllerTableRows.forEach((key, row) -> {
            if (!controllerUuids.contains(Uuid.uuid((String)key))) {
                return;
            }
            Controller controller = (Controller)TableGenerator.getTable((DatabaseSchema)dbSchema, (Row)row, (OvsdbTable)OvsdbTable.CONTROLLER);
            ovsdbControllers.add(controller);
        });
        return ovsdbControllers;
    }

    private Uuid getBridgeUuid(DeviceId openflowDeviceId) {
        DatabaseSchema dbSchema = this.schema.get("Open_vSwitch");
        if (dbSchema == null) {
            return null;
        }
        OvsdbRowStore rowStore = this.getRowStore("Open_vSwitch", "Bridge");
        if (rowStore == null) {
            this.log.debug("There is no bridge table");
            return null;
        }
        ConcurrentMap<String, Row> bridgeTableRows = rowStore.getRowStore();
        AtomicReference<Uuid> uuid = new AtomicReference<Uuid>();
        for (Map.Entry entry : bridgeTableRows.entrySet()) {
            Bridge bridge = (Bridge)TableGenerator.getTable((DatabaseSchema)dbSchema, (Row)((Row)entry.getValue()), (OvsdbTable)OvsdbTable.BRIDGE);
            if (!DefaultOvsdbClient.matchesDpid(bridge, openflowDeviceId)) continue;
            uuid.set(Uuid.uuid((String)((String)entry.getKey())));
            break;
        }
        if (uuid.get() == null) {
            this.log.debug("There is no bridge for {}", (Object)openflowDeviceId);
        }
        return (Uuid)uuid.get();
    }

    private static boolean matchesDpid(Bridge b, DeviceId deviceId) {
        String ofDpid = deviceId.toString().replace("of:", "");
        Set ofDeviceIds = ((OvsdbSet)b.getDatapathIdColumn().data()).set();
        return ofDeviceIds.contains(ofDpid);
    }

    @Override
    public Set<OvsdbPort> getPorts() {
        HashSet<OvsdbPort> ovsdbPorts = new HashSet<OvsdbPort>();
        OvsdbTableStore tableStore = this.getTableStore("Open_vSwitch");
        if (tableStore == null) {
            return null;
        }
        OvsdbRowStore rowStore = tableStore.getRows("Interface");
        if (rowStore == null) {
            return null;
        }
        ConcurrentMap<String, Row> rows = rowStore.getRowStore();
        for (String uuid : rows.keySet()) {
            Row row = this.getRow("Open_vSwitch", "Interface", uuid);
            OvsdbPort ovsdbPort = this.getOvsdbPort(row);
            if (ovsdbPort == null) continue;
            ovsdbPorts.add(ovsdbPort);
        }
        return ovsdbPorts;
    }

    @Override
    public DatabaseSchema getDatabaseSchema(String dbName) {
        return this.schema.get(dbName);
    }

    private OvsdbPort getOvsdbPort(Row row) {
        DatabaseSchema dbSchema = this.getDatabaseSchema("Open_vSwitch");
        Interface intf = (Interface)TableGenerator.getTable((DatabaseSchema)dbSchema, (Row)row, (OvsdbTable)OvsdbTable.INTERFACE);
        if (intf == null) {
            return null;
        }
        long ofPort = this.getOfPort(intf);
        String portName = intf.getName();
        if (ofPort < 0L || portName == null) {
            return null;
        }
        return new OvsdbPort(new OvsdbPortNumber(ofPort), new OvsdbPortName(portName));
    }

    private OvsdbBridge getOvsdbBridge(Row row) {
        DatabaseSchema dbSchema = this.getDatabaseSchema("Open_vSwitch");
        Bridge bridge = (Bridge)TableGenerator.getTable((DatabaseSchema)dbSchema, (Row)row, (OvsdbTable)OvsdbTable.BRIDGE);
        if (bridge == null) {
            return null;
        }
        OvsdbSet datapathIdSet = (OvsdbSet)bridge.getDatapathIdColumn().data();
        Set datapathIds = datapathIdSet.set();
        if (datapathIds == null || datapathIds.isEmpty()) {
            return null;
        }
        String datapathId = (String)datapathIds.toArray()[0];
        String bridgeName = bridge.getName();
        if (datapathId == null || bridgeName == null) {
            return null;
        }
        return OvsdbBridge.builder().name(bridgeName).datapathId(datapathId).build();
    }

    private OvsdbQos getOvsdbQos(Row row) {
        DatabaseSchema dbSchema = this.getDatabaseSchema("Open_vSwitch");
        Qos qos = (Qos)TableGenerator.getTable((DatabaseSchema)dbSchema, (Row)row, (OvsdbTable)OvsdbTable.QOS);
        if (qos == null) {
            return null;
        }
        String type = (String)qos.getTypeColumn().data();
        Map otherConfigs = ((OvsdbMap)qos.getOtherConfigColumn().data()).map();
        Map externalIds = ((OvsdbMap)qos.getExternalIdsColumn().data()).map();
        Map queues = ((OvsdbMap)qos.getQueuesColumn().data()).map();
        return OvsdbQos.builder().qosType(type).queues(queues).otherConfigs(otherConfigs).externalIds(externalIds).build();
    }

    private OvsdbQueue getOvsdbQueue(Row row) {
        DatabaseSchema dbSchema = this.getDatabaseSchema("Open_vSwitch");
        Queue queue = (Queue)TableGenerator.getTable((DatabaseSchema)dbSchema, (Row)row, (OvsdbTable)OvsdbTable.QUEUE);
        if (queue == null) {
            return null;
        }
        OvsdbSet dscpOvsdbSet = (OvsdbSet)queue.getDscpColumn().data();
        Set dscpSet = dscpOvsdbSet.set();
        Long dscp = null;
        if (dscpSet != null && !dscpSet.isEmpty()) {
            dscp = Long.valueOf((String)dscpSet.toArray()[0]);
        }
        Map otherConfigs = ((OvsdbMap)queue.getOtherConfigColumn().data()).map();
        Map externalIds = ((OvsdbMap)queue.getExternalIdsColumn().data()).map();
        return OvsdbQueue.builder().dscp(dscp).otherConfigs(otherConfigs).externalIds(externalIds).build();
    }

    private long getOfPort(Interface intf) {
        OvsdbSet ofPortSet = (OvsdbSet)intf.getOpenFlowPortColumn().data();
        Set ofPorts = ofPortSet.set();
        if (ofPorts == null || ofPorts.isEmpty()) {
            this.log.debug("The ofport is null in {}", (Object)intf.getName());
            return -1L;
        }
        Iterator it = ofPorts.iterator();
        return Long.parseLong(((Integer)it.next()).toString());
    }

    @Override
    public Set<OvsdbPort> getLocalPorts(Iterable<String> ifaceids) {
        HashSet<OvsdbPort> ovsdbPorts = new HashSet<OvsdbPort>();
        OvsdbTableStore tableStore = this.getTableStore("Open_vSwitch");
        if (tableStore == null) {
            return null;
        }
        OvsdbRowStore rowStore = tableStore.getRows("Interface");
        if (rowStore == null) {
            return null;
        }
        ConcurrentMap<String, Row> rows = rowStore.getRowStore();
        for (String uuid : rows.keySet()) {
            long ofPort;
            String portName;
            Row row = this.getRow("Open_vSwitch", "Interface", uuid);
            DatabaseSchema dbSchema = this.getDatabaseSchema("Open_vSwitch");
            Interface intf = (Interface)TableGenerator.getTable((DatabaseSchema)dbSchema, (Row)row, (OvsdbTable)OvsdbTable.INTERFACE);
            if (intf == null || this.getIfaceid(intf) == null || (portName = intf.getName()) == null) continue;
            HashSet ifaceidSet = Sets.newHashSet(ifaceids);
            if (portName.startsWith("vxlan") || !ifaceidSet.contains(this.getIfaceid(intf)) || (ofPort = this.getOfPort(intf)) < 0L) continue;
            ovsdbPorts.add(new OvsdbPort(new OvsdbPortNumber(ofPort), new OvsdbPortName(portName)));
        }
        return ovsdbPorts;
    }

    private String getIfaceid(Interface intf) {
        OvsdbMap ovsdbMap = (OvsdbMap)intf.getExternalIdsColumn().data();
        Map externalIds = ovsdbMap.map();
        if (externalIds.isEmpty()) {
            this.log.warn("The external_ids is null");
            return null;
        }
        String ifaceid = (String)externalIds.get("iface-id");
        if (ifaceid == null) {
            this.log.warn("The ifaceid is null");
            return null;
        }
        return ifaceid;
    }

    @Override
    public void disconnect() {
        this.channel.disconnect();
        this.agent.removeConnectedNode(this.nodeId);
    }
}

