/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ovsdb.controller;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.onlab.util.Bandwidth;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.behaviour.QueueDescription;

public final class OvsdbQueue {
    private final Optional<Long> dscp;
    private final Map<String, String> otherConfigs;
    private final Map<String, String> externalIds;

    private OvsdbQueue(Optional<Long> dscp, Map<String, String> otherConfigs, Map<String, String> externalIds) {
        this.dscp = dscp;
        this.otherConfigs = otherConfigs;
        this.externalIds = externalIds;
    }

    public Optional<Long> dscp() {
        return this.dscp;
    }

    public Map<String, String> otherConfigs() {
        return this.otherConfigs;
    }

    public Map<String, String> externalIds() {
        return this.externalIds;
    }

    public int hashCode() {
        return Objects.hash(this.dscp, this.otherConfigs, this.externalIds);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof OvsdbQueue) {
            OvsdbQueue other = (OvsdbQueue)obj;
            return Objects.equals(this.dscp, other.dscp) && Objects.equals(this.otherConfigs, other.otherConfigs) && Objects.equals(this.externalIds, other.externalIds);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("dscp", this.dscp()).add("maxRate", this.otherConfigs()).add("externalIds", this.externalIds()).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(QueueDescription queueDescription) {
        return new Builder(queueDescription);
    }

    public static final class Builder {
        private Optional<Long> dscp = Optional.empty();
        private Map<String, String> otherConfigs = Maps.newHashMap();
        private Map<String, String> externalIds = Maps.newHashMap();

        private Builder() {
        }

        private Builder(QueueDescription queueDescription) {
            if (queueDescription.maxRate().isPresent()) {
                this.otherConfigs.put("max-rate", String.valueOf((long)((Bandwidth)queueDescription.maxRate().get()).bps()));
            }
            if (queueDescription.minRate().isPresent()) {
                this.otherConfigs.put("min-rate", String.valueOf((long)((Bandwidth)queueDescription.minRate().get()).bps()));
            }
            if (queueDescription.burst().isPresent()) {
                this.otherConfigs.put("burst", ((Long)queueDescription.burst().get()).toString());
            }
            if (queueDescription.priority().isPresent()) {
                this.otherConfigs.put("priority", ((Long)queueDescription.priority().get()).toString());
            }
            if (queueDescription.dscp().isPresent()) {
                this.dscp = Optional.of(((Integer)queueDescription.dscp().get()).longValue());
            }
            this.externalIds.putAll(((DefaultAnnotations)queueDescription.annotations()).asMap());
            this.externalIds.put("onos-queue-id", queueDescription.queueId().name());
        }

        public OvsdbQueue build() {
            return new OvsdbQueue(this.dscp, this.otherConfigs, this.externalIds);
        }

        public Builder dscp(Long dscp) {
            this.dscp = Optional.ofNullable(dscp);
            return this;
        }

        public Builder otherConfigs(Map<String, String> otherConfigs) {
            this.otherConfigs = Maps.newHashMap(otherConfigs);
            return this;
        }

        public Builder externalIds(Map<String, String> ids) {
            this.externalIds = ids;
            return this;
        }
    }
}

