/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ovsdb.controller;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.onlab.packet.VlanId;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.behaviour.MirroringDescription;
import org.onosproject.ovsdb.rfc.notation.Uuid;

public final class OvsdbMirror {
    private final String mirroringName;
    private boolean selectAll;
    private final Set<Uuid> monitorSrcPorts;
    private final Set<Uuid> monitorDstPorts;
    private final Set<Short> monitorVlans;
    private final Optional<Uuid> mirrorPort;
    private final Optional<Short> mirrorVlan;
    private Map<String, String> externalIds;

    private OvsdbMirror(String mirroringName, boolean selectAll, Set<Uuid> monitorSrcPorts, Set<Uuid> monitorDstPorts, Set<Short> monitorVlans, Optional<Uuid> mirrorPort, Optional<Short> mirrorVlan, Map<String, String> externalIds) {
        this.mirroringName = mirroringName;
        this.selectAll = selectAll;
        this.monitorSrcPorts = monitorSrcPorts;
        this.monitorDstPorts = monitorDstPorts;
        this.monitorVlans = monitorVlans;
        this.mirrorPort = mirrorPort;
        this.mirrorVlan = mirrorVlan;
        this.externalIds = externalIds;
    }

    public String mirroringName() {
        return this.mirroringName;
    }

    public boolean selectAll() {
        return this.selectAll;
    }

    public Set<Uuid> monitorSrcPorts() {
        return this.monitorSrcPorts;
    }

    public Set<Uuid> monitorDstPorts() {
        return this.monitorDstPorts;
    }

    public Set<Short> monitorVlans() {
        return this.monitorVlans;
    }

    public Uuid mirrorPort() {
        return this.mirrorPort.orElse(null);
    }

    public Short mirrorVlan() {
        return this.mirrorVlan.orElse(null);
    }

    public Map<String, String> externalIds() {
        return this.externalIds;
    }

    public int hashCode() {
        return Objects.hash(this.mirroringName, this.selectAll, this.monitorSrcPorts, this.monitorDstPorts, this.monitorVlans, this.mirrorPort, this.mirrorVlan, this.externalIds);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof OvsdbMirror) {
            OvsdbMirror other = (OvsdbMirror)obj;
            return Objects.equals(this.mirroringName, other.mirroringName) && Objects.equals(this.selectAll, other.selectAll) && Objects.equals(this.monitorSrcPorts, other.monitorSrcPorts) && Objects.equals(this.monitorDstPorts, other.monitorDstPorts) && Objects.equals(this.monitorVlans, other.monitorVlans) && Objects.equals(this.mirrorPort, other.mirrorPort) && Objects.equals(this.mirrorVlan, other.mirrorVlan) && Objects.equals(this.externalIds, other.externalIds);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("mirroringName", (Object)this.mirroringName()).add("selectAll", this.selectAll()).add("monitorSrcPorts", this.monitorSrcPorts()).add("monitorDstPorts", this.monitorDstPorts()).add("monitorVlans", this.monitorVlans()).add("mirrorPort", (Object)this.mirrorPort()).add("mirrorVlan", (Object)this.mirrorVlan()).add("externalIds", this.externalIds()).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(MirroringDescription mirrorDesc) {
        return new Builder(mirrorDesc);
    }

    public static final class Builder {
        private String mirroringName;
        private boolean selectAll;
        private Set<Uuid> monitorSrcPorts;
        private Set<Uuid> monitorDstPorts;
        private Set<Short> monitorVlans;
        private Optional<Uuid> mirrorPort;
        private Optional<Short> mirrorVlan;
        private Map<String, String> externalIds = Maps.newHashMap();

        private Builder() {
        }

        private Builder(MirroringDescription mirrorDesc) {
            this.mirroringName = mirrorDesc.name().name();
            this.selectAll = false;
            this.monitorSrcPorts = mirrorDesc.monitorSrcPorts().parallelStream().map(monitorSrcPort -> Uuid.uuid((String)monitorSrcPort)).collect(Collectors.toSet());
            this.monitorDstPorts = mirrorDesc.monitorDstPorts().parallelStream().map(monitorDstPort -> Uuid.uuid((String)monitorDstPort)).collect(Collectors.toSet());
            this.monitorVlans = mirrorDesc.monitorVlans().parallelStream().map(monitorVlan -> monitorVlan.toShort()).collect(Collectors.toSet());
            this.mirrorPort = mirrorDesc.mirrorPort().isPresent() ? Optional.of(Uuid.uuid((String)((String)mirrorDesc.mirrorPort().get()))) : Optional.empty();
            this.mirrorVlan = mirrorDesc.mirrorVlan().isPresent() ? Optional.of(((VlanId)mirrorDesc.mirrorVlan().get()).toShort()) : Optional.empty();
            this.externalIds.putAll(((DefaultAnnotations)mirrorDesc.annotations()).asMap());
        }

        public OvsdbMirror build() {
            return new OvsdbMirror(this.mirroringName, this.selectAll, this.monitorSrcPorts, this.monitorDstPorts, this.monitorVlans, this.mirrorPort, this.mirrorVlan, this.externalIds);
        }

        public Builder mirroringName(String name) {
            this.mirroringName = name;
            return this;
        }

        public Builder selectAll(boolean all) {
            this.selectAll = all;
            return this;
        }

        public Builder monitorSrcPorts(Set<Uuid> monitorPorts) {
            this.monitorSrcPorts = monitorPorts;
            return this;
        }

        public Builder monitorDstPorts(Set<Uuid> monitorPorts) {
            this.monitorDstPorts = monitorPorts;
            return this;
        }

        public Builder monitorVlans(Set<Short> vlans) {
            this.monitorVlans = vlans;
            return this;
        }

        public Builder mirrorPort(Uuid port) {
            this.mirrorPort = Optional.ofNullable(port);
            return this;
        }

        public Builder mirrorVlan(Short vlan) {
            this.mirrorVlan = Optional.ofNullable(vlan);
            return this;
        }

        public Builder externalIds(Map<String, String> ids) {
            this.externalIds = ids;
            return this;
        }
    }
}

