/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ovsdb.controller;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.onosproject.net.behaviour.BridgeDescription;
import org.onosproject.net.behaviour.ControllerInfo;

public final class OvsdbBridge {
    private final String name;
    private final Optional<BridgeDescription.FailMode> failMode;
    private final List<ControllerInfo> controllers;
    private final Map<String, String> otherConfigs;

    private OvsdbBridge(String name, Optional<BridgeDescription.FailMode> failMode, List<ControllerInfo> controllers, Map<String, String> otherConfigs) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.failMode = failMode;
        this.controllers = controllers;
        this.otherConfigs = otherConfigs;
    }

    public String name() {
        return this.name;
    }

    public List<ControllerInfo> controllers() {
        return this.controllers;
    }

    public Optional<BridgeDescription.FailMode> failMode() {
        return this.failMode;
    }

    public Map<String, String> otherConfigs() {
        return this.otherConfigs;
    }

    public Optional<String> datapathId() {
        return Optional.ofNullable(this.otherConfigs.get("datapath-id"));
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof OvsdbBridge) {
            OvsdbBridge otherOvsdbBridge = (OvsdbBridge)obj;
            return Objects.equals(this.name, otherOvsdbBridge.name);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("bridgeName", (Object)this.name).add("failMode", this.failMode).add("controllers", this.controllers).add("otherConfigs", this.otherConfigs).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(BridgeDescription bridgeDesc) {
        return new Builder(bridgeDesc);
    }

    public static final class Builder {
        private String name;
        private Optional<BridgeDescription.FailMode> failMode = Optional.empty();
        private List<ControllerInfo> controllers = Lists.newArrayList();
        private Map<String, String> otherConfigs = Maps.newHashMap();

        private Builder() {
        }

        private Builder(BridgeDescription bridgeDesc) {
            if (bridgeDesc.datapathId().isPresent()) {
                this.otherConfigs.put("datapath-id", (String)bridgeDesc.datapathId().get());
            }
            if (bridgeDesc.disableInBand().isPresent()) {
                this.otherConfigs.put("disable-in-band", ((Boolean)bridgeDesc.disableInBand().get()).toString());
            }
            this.name = bridgeDesc.name();
            this.failMode = bridgeDesc.failMode();
            this.controllers = Lists.newArrayList((Iterable)bridgeDesc.controllers());
        }

        public OvsdbBridge build() {
            return new OvsdbBridge(this.name, this.failMode, this.controllers, this.otherConfigs);
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder failMode(BridgeDescription.FailMode failMode) {
            this.failMode = Optional.ofNullable(failMode);
            return this;
        }

        public Builder controllers(List<ControllerInfo> controllers) {
            this.controllers = Lists.newArrayList(controllers);
            return this;
        }

        public Builder controller(ControllerInfo controller) {
            this.controllers = Lists.newArrayList((Object[])new ControllerInfo[]{controller});
            return this;
        }

        public Builder otherConfigs(Map<String, String> otherConfigs) {
            this.otherConfigs = Maps.newHashMap(otherConfigs);
            return this;
        }

        public Builder datapathId(String datapathId) {
            this.otherConfigs.put("datapath-id", datapathId);
            return this;
        }

        public Builder disableInBand() {
            this.otherConfigs.put("datapath-id", Boolean.TRUE.toString());
            return this;
        }
    }
}

