/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.mfwd.impl;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onlab.packet.Ethernet;
import org.onlab.packet.IPv4;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.IpAddress;
import org.onlab.packet.IpPrefix;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.event.EventListener;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentService;
import org.onosproject.net.intent.Key;
import org.onosproject.net.intent.SinglePointToMultiPointIntent;
import org.onosproject.net.mcast.McastEvent;
import org.onosproject.net.mcast.McastListener;
import org.onosproject.net.mcast.McastRoute;
import org.onosproject.net.mcast.McastRouteInfo;
import org.onosproject.net.mcast.MulticastRouteService;
import org.onosproject.net.packet.DefaultOutboundPacket;
import org.onosproject.net.packet.InboundPacket;
import org.onosproject.net.packet.OutboundPacket;
import org.onosproject.net.packet.PacketContext;
import org.onosproject.net.packet.PacketPriority;
import org.onosproject.net.packet.PacketProcessor;
import org.onosproject.net.packet.PacketService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class McastForwarding {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected PacketService packetService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    private IntentService intentService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected MulticastRouteService mcastRouteManager;
    protected McastIntentManager mcastIntentManager;
    private ReactivePacketProcessor processor = new ReactivePacketProcessor();
    private static ApplicationId appId;

    @Activate
    public void activate() {
        appId = this.coreService.registerApplication("org.onosproject.mfwd");
        this.mcastIntentManager = new McastIntentManager();
        this.mcastRouteManager.addListener((EventListener)this.mcastIntentManager);
        this.packetService.addProcessor((PacketProcessor)this.processor, PacketProcessor.director((int)2));
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        selector.matchEthType(Ethernet.TYPE_IPV4);
        selector.matchIPDst(IpPrefix.IPV4_MULTICAST_PREFIX);
        this.packetService.requestPackets(selector.build(), PacketPriority.REACTIVE, appId);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.packetService.removeProcessor((PacketProcessor)this.processor);
        this.mcastRouteManager.removeListener((EventListener)this.mcastIntentManager);
        this.mcastIntentManager.withdrawAllIntents();
        this.processor = null;
        this.log.info("Stopped");
    }

    public static ApplicationId getAppId() {
        return appId;
    }

    private void forwardPacketToDst(PacketContext context, ArrayList<ConnectPoint> egressList) {
        for (ConnectPoint egress : egressList) {
            TrafficTreatment treatment = DefaultTrafficTreatment.builder().setOutput(egress.port()).build();
            DefaultOutboundPacket packet = new DefaultOutboundPacket(egress.deviceId(), treatment, context.inPacket().unparsed());
            this.packetService.emit((OutboundPacket)packet);
        }
    }

    public static McastRoute createStaticRoute(String source, String group) {
        Preconditions.checkNotNull((Object)source, (Object)"Must provide a source");
        Preconditions.checkNotNull((Object)group, (Object)"Must provide a group");
        IpAddress ipSource = IpAddress.valueOf((String)source);
        IpAddress ipGroup = IpAddress.valueOf((String)group);
        return McastForwarding.createStaticcreateRoute(ipSource, ipGroup);
    }

    public static McastRoute createStaticcreateRoute(IpAddress source, IpAddress group) {
        Preconditions.checkNotNull((Object)source, (Object)"Must provide a source");
        Preconditions.checkNotNull((Object)group, (Object)"Must provide a group");
        McastRoute.Type type = McastRoute.Type.STATIC;
        return new McastRoute(source, group, type);
    }

    protected void bindPacketService(PacketService packetService) {
        this.packetService = packetService;
    }

    protected void unbindPacketService(PacketService packetService) {
        if (this.packetService == packetService) {
            this.packetService = null;
        }
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindIntentService(IntentService intentService) {
        this.intentService = intentService;
    }

    protected void unbindIntentService(IntentService intentService) {
        if (this.intentService == intentService) {
            this.intentService = null;
        }
    }

    protected void bindMcastRouteManager(MulticastRouteService multicastRouteService) {
        this.mcastRouteManager = multicastRouteService;
    }

    protected void unbindMcastRouteManager(MulticastRouteService multicastRouteService) {
        if (this.mcastRouteManager == multicastRouteService) {
            this.mcastRouteManager = null;
        }
    }

    private class McastIntentManager
    implements McastListener {
        private Map<McastRoute, Key> intentHashMap = new HashMap<McastRoute, Key>();

        public void event(McastEvent event) {
            McastRoute route = ((McastRouteInfo)event.subject()).route();
            if (this.intentHashMap.containsKey(route)) {
                this.withdrawIntent(this.intentHashMap.get(route));
            }
            Key routeKey = this.setIntent(route);
            this.intentHashMap.put(route, routeKey);
        }

        private Key setIntent(McastRoute route) {
            ConnectPoint ingressPoint = McastForwarding.this.mcastRouteManager.fetchSource(route);
            HashSet egressPoints = new HashSet(McastForwarding.this.mcastRouteManager.fetchSinks(route));
            TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
            TrafficTreatment treatment = DefaultTrafficTreatment.emptyTreatment();
            if (ingressPoint == null) {
                McastForwarding.this.log.warn("Can't set intent without an ingress or egress connect points");
                return null;
            }
            selector.matchEthType(Ethernet.TYPE_IPV4).matchIPDst(route.group().toIpPrefix()).matchIPSrc(route.source().toIpPrefix());
            SinglePointToMultiPointIntent.Builder builder = SinglePointToMultiPointIntent.builder().appId(appId).selector(selector.build()).treatment(treatment).ingressPoint(ingressPoint);
            if (!egressPoints.isEmpty()) {
                builder.egressPoints(egressPoints);
            }
            SinglePointToMultiPointIntent intent = builder.build();
            McastForwarding.this.intentService.submit((Intent)intent);
            return intent.key();
        }

        public void withdrawAllIntents() {
            for (Map.Entry<McastRoute, Key> entry : this.intentHashMap.entrySet()) {
                this.withdrawIntent(entry.getValue());
            }
            this.intentHashMap.clear();
        }

        public void withdrawIntent(Key key) {
            if (key == null) {
                return;
            }
            Intent intent = McastForwarding.this.intentService.getIntent(key);
            McastForwarding.this.intentService.withdraw(intent);
        }
    }

    private class ReactivePacketProcessor
    implements PacketProcessor {
        private ReactivePacketProcessor() {
        }

        public void process(PacketContext context) {
            if (context.isHandled()) {
                return;
            }
            InboundPacket pkt = context.inPacket();
            Ethernet ethPkt = pkt.parsed();
            if (ethPkt == null) {
                return;
            }
            if (ethPkt.getEtherType() != Ethernet.TYPE_IPV4 && ethPkt.getEtherType() != Ethernet.TYPE_IPV6) {
                return;
            }
            if (ethPkt.getEtherType() == Ethernet.TYPE_IPV6) {
                return;
            }
            IPv4 ip = (IPv4)ethPkt.getPayload();
            Ip4Address saddr = Ip4Address.valueOf((int)ip.getSourceAddress());
            IpAddress gaddr = IpAddress.valueOf((int)ip.getDestinationAddress());
            McastForwarding.this.log.debug("Packet ({}, {}) has been punted\n\tingress port: {}\n", new Object[]{saddr.toString(), gaddr.toString(), context.inPacket().receivedFrom().toString()});
            byte proto = ip.getProtocol();
            if (proto == 103 || proto == 2) {
                return;
            }
            IpPrefix spfx = IpPrefix.valueOf((IpAddress)saddr, (int)32);
            IpPrefix gpfx = IpPrefix.valueOf((IpAddress)gaddr, (int)32);
            McastRoute mRoute = new McastRoute((IpAddress)saddr, gaddr, McastRoute.Type.STATIC);
            ConnectPoint ingress = McastForwarding.this.mcastRouteManager.fetchSource(mRoute);
            if (ingress != null) {
                McastForwarding.this.log.error(McastForwarding.class.getSimpleName() + " received packet which already has a route.");
                return;
            }
            McastForwarding.this.mcastRouteManager.addSource(mRoute, pkt.receivedFrom());
            ArrayList egressList = (ArrayList)((Object)McastForwarding.this.mcastRouteManager.fetchSinks(mRoute));
            if (egressList.isEmpty()) {
                return;
            }
            McastForwarding.this.forwardPacketToDst(context, egressList);
        }
    }
}

