/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.arista;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.device.DefaultPortDescription;
import org.onosproject.net.device.DeviceDescription;
import org.onosproject.net.device.DeviceDescriptionDiscovery;
import org.onosproject.net.device.PortDescription;
import org.onosproject.net.driver.AbstractHandlerBehaviour;
import org.onosproject.net.driver.DriverHandler;
import org.onosproject.protocol.rest.RestSBController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceDescriptionDiscoveryAristaImpl
extends AbstractHandlerBehaviour
implements DeviceDescriptionDiscovery {
    private static final String JSON = "json";
    private static final String RESULT = "result";
    private static final String INTERFACE_STATUSES = "interfaceStatuses";
    private static final String LINK_STATUS = "linkStatus";
    private static final String LINE_PROTOCOL_STATUS = "lineProtocolStatus";
    private static final String BANDWIDTH = "bandwidth";
    private static final String ETHERNET = "Ethernet";
    private static final String MANAGEMENT = "Management";
    private static final String INTERFACE_TYPE = "interfaceType";
    private static final int WEIGHTING_FACTOR_MANAGEMENT_INTERFACE = 100;
    private static final String JSONRPC = "jsonrpc";
    private static final String METHOD = "method";
    private static final String RUN_CMDS = "runCmds";
    private static final String VERSION = "version";
    private static final String ID = "id";
    private static final String GET_PORT = "GetPort";
    private static final String PARAMS = "params";
    private static final String FORMAT = "format";
    private static final String TIMESTAMPS = "timestamps";
    private static final String CMDS = "cmds";
    private static final String SHOW_INTERFACES_STATUS = "show interfaces status";
    private static final String TWO_POINT_ZERO = "2.0";
    private static final long MBPS = 1000000L;
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String API_ENDPOINT = "/command-api/";

    public DeviceDescription discoverDeviceDetails() {
        this.log.info("No description to be added for device");
        return null;
    }

    public List<PortDescription> discoverPortDetails() {
        ArrayList ports = Lists.newArrayList();
        DriverHandler handler = this.handler();
        RestSBController controller = (RestSBController)Preconditions.checkNotNull((Object)handler.get(RestSBController.class));
        DeviceId deviceId = handler.data().deviceId();
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode sendObjNode = mapper.createObjectNode();
        sendObjNode.put(JSONRPC, TWO_POINT_ZERO).put(METHOD, RUN_CMDS).put(ID, GET_PORT).putObject(PARAMS).put(FORMAT, JSON).put(TIMESTAMPS, false).put(VERSION, 1).putArray(CMDS).add(SHOW_INTERFACES_STATUS);
        String response = (String)controller.post(deviceId, API_ENDPOINT, (InputStream)new ByteArrayInputStream(sendObjNode.toString().getBytes()), "application/json", String.class);
        try {
            ObjectNode node = (ObjectNode)mapper.readTree(response);
            ArrayNode arrayNode = (ArrayNode)node.get(RESULT);
            JsonNode jsonNode = ((JsonNode)arrayNode.iterator().next()).get(INTERFACE_STATUSES);
            jsonNode.fieldNames().forEachRemaining(name -> {
                JsonNode interfaceNode = jsonNode.get(name);
                Long bandwidth = interfaceNode.path(BANDWIDTH).asLong() / 1000000L;
                DefaultAnnotations annotations = DefaultAnnotations.builder().set(BANDWIDTH, bandwidth.toString()).set("name", name).set(LINK_STATUS, interfaceNode.path(LINK_STATUS).asText()).set(LINE_PROTOCOL_STATUS, interfaceNode.path(LINE_PROTOCOL_STATUS).asText()).set(INTERFACE_TYPE, interfaceNode.path(INTERFACE_TYPE).asText()).build();
                DefaultPortDescription portDescription = new DefaultPortDescription(PortNumber.portNumber((long)this.getPortNumber((String)name)), true, Port.Type.FIBER, bandwidth.longValue(), new SparseAnnotations[]{annotations});
                ports.add(portDescription);
            });
        }
        catch (IOException e) {
            this.log.warn("IO exception occured because of ", (Throwable)e);
        }
        return ports;
    }

    private int getPortNumber(String interfaceName) {
        if (interfaceName.startsWith(ETHERNET)) {
            return Integer.valueOf(interfaceName.substring(ETHERNET.length()));
        }
        return Integer.valueOf(interfaceName.substring(MANAGEMENT.length())) + 100;
    }
}

