/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.mapping.web.gui;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onosproject.mapping.web.gui.MappingsViewMessageHandler;
import org.onosproject.ui.UiExtension;
import org.onosproject.ui.UiExtensionService;
import org.onosproject.ui.UiMessageHandlerFactory;
import org.onosproject.ui.UiView;
import org.onosproject.ui.UiViewHidden;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, enabled=true)
@Service(value={MappingsUI.class})
public class MappingsUI {
    private static final String MAPPING_ID = "mapping";
    private static final String RES_PATH = "gui";
    private static final ClassLoader CL = MappingsUI.class.getClassLoader();
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected UiExtensionService uiExtensionService;
    private final UiMessageHandlerFactory messageHandlerFactory = () -> ImmutableList.of((Object)new MappingsViewMessageHandler());
    private final List<UiView> views = ImmutableList.of((Object)new UiViewHidden("mapping"));
    private final UiExtension uiExtension = new UiExtension.Builder(CL, this.views).messageHandlerFactory(this.messageHandlerFactory).resourcePath("gui").build();

    @Activate
    protected void activate() {
        this.uiExtensionService.register(this.uiExtension);
        this.log.info("Started");
    }

    @Deactivate
    protected void deactivate() {
        this.uiExtensionService.unregister(this.uiExtension);
        this.log.info("Stopped");
    }

    protected void bindUiExtensionService(UiExtensionService uiExtensionService) {
        this.uiExtensionService = uiExtensionService;
    }

    protected void unbindUiExtensionService(UiExtensionService uiExtensionService) {
        if (this.uiExtensionService == uiExtensionService) {
            this.uiExtensionService = null;
        }
    }
}

