/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.mapping.web.api;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.onlab.util.ItemNotFoundException;
import org.onosproject.codec.CodecContext;
import org.onosproject.mapping.MappingEntry;
import org.onosproject.mapping.MappingService;
import org.onosproject.mapping.MappingStore;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.device.DeviceService;
import org.onosproject.rest.AbstractWebResource;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="mappings")
public class MappingsWebResource
extends AbstractWebResource {
    private static final String DEVICE_NOT_FOUND = "Device is not found";
    private static final String TYPE_NOT_NULL = "Mapping store type should not be null";
    private static final String TYPE_ILLEGAL = "Mapping store type is not correct";
    private static final String MAPPINGS = "mappings";
    private static final String DB = "database";
    private static final String CACHE = "cache";
    private final MappingService mappingService = (MappingService)this.get(MappingService.class);
    private final DeviceService deviceService = (DeviceService)this.get(DeviceService.class);
    private final ObjectNode root = this.mapper().createObjectNode();
    private final ArrayNode mappingsNode = this.root.putArray("mappings");

    @GET
    @Produces(value={"application/json"})
    @Path(value="{type}")
    public Response getMappings(@PathParam(value="type") String type) {
        Iterable mappingEntries = this.mappingService.getAllMappingEntries(this.getTypeEnum(type));
        if (mappingEntries == null || !mappingEntries.iterator().hasNext()) {
            return MappingsWebResource.ok((Object)this.root).build();
        }
        for (MappingEntry entry : mappingEntries) {
            this.mappingsNode.add((JsonNode)this.codec(MappingEntry.class).encode((Object)entry, (CodecContext)this));
        }
        return MappingsWebResource.ok((Object)this.root).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{deviceId}/{type}")
    public Response getMappingsByDeviceId(@PathParam(value="deviceId") String deviceId, @PathParam(value="type") String type) {
        Device device = this.deviceService.getDevice(DeviceId.deviceId((String)deviceId));
        if (device == null) {
            throw new ItemNotFoundException("Device is not found");
        }
        Iterable mappingEntries = this.mappingService.getMappingEntries(this.getTypeEnum(type), device.id());
        if (mappingEntries == null || !mappingEntries.iterator().hasNext()) {
            return MappingsWebResource.ok((Object)this.root).build();
        }
        for (MappingEntry entry : mappingEntries) {
            this.mappingsNode.add((JsonNode)this.codec(MappingEntry.class).encode((Object)entry, (CodecContext)this));
        }
        return MappingsWebResource.ok((Object)this.root).build();
    }

    private MappingStore.Type getTypeEnum(String type) {
        if (type == null) {
            throw new IllegalArgumentException("Mapping store type should not be null");
        }
        switch (type) {
            case "database": {
                return MappingStore.Type.MAP_DATABASE;
            }
            case "cache": {
                return MappingStore.Type.MAP_CACHE;
            }
        }
        throw new IllegalArgumentException("Mapping store type is not correct");
    }
}

