/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.gui;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableSet;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import org.onlab.osgi.ServiceDirectory;
import org.onosproject.ui.RequestHandler;
import org.onosproject.ui.UiConnection;
import org.onosproject.ui.UiMessageHandler;
import org.onosproject.ui.table.TableModel;
import org.onosproject.ui.table.TableRequestHandler;
import org.onosproject.yang.model.YangModel;
import org.onosproject.yang.model.YangModule;
import org.onosproject.yang.model.YangModuleId;
import org.onosproject.yang.runtime.YangModelRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YangModelMessageHandler
extends UiMessageHandler {
    private static final String TABLE_REQ = "yangModelDataRequest";
    private static final String TABLE_RESP = "yangModelDataResponse";
    private static final String MODELS = "yangModels";
    private static final String DETAILS_REQ = "yangModelDetailsRequest";
    private static final String DETAILS_RESP = "yangModelDetailsResponse";
    private static final String DETAILS = "details";
    private static final String ID = "id";
    private static final String REVISION = "revision";
    private static final String MODEL_ID = "modelId";
    private static final String SOURCE = "source";
    private static final String[] COL_IDS = new String[]{"id", "revision", "modelId"};
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private YangModelRegistry modelRegistry;

    public void init(UiConnection connection, ServiceDirectory directory) {
        super.init(connection, directory);
        this.modelRegistry = (YangModelRegistry)directory.get(YangModelRegistry.class);
    }

    public void destroy() {
        super.destroy();
    }

    protected Collection<RequestHandler> createRequestHandlers() {
        return ImmutableSet.of((Object)((Object)new TableDataHandler()), (Object)((Object)new DetailRequestHandler()));
    }

    private YangModule getModule(String modelId, String name) {
        int nid = Integer.parseInt(modelId.substring(2));
        this.log.info("Got {}; {}", (Object)modelId, (Object)nid);
        YangModel model = this.modelRegistry.getModels().stream().filter(m -> this.modelId((YangModel)m).equals(modelId)).findFirst().orElse(null);
        if (model != null) {
            this.log.info("Got model");
            return model.getYangModules().stream().filter(m -> m.getYangModuleId().moduleName().contentEquals(name)).findFirst().orElse(null);
        }
        return null;
    }

    private String modelId(YangModel m) {
        return "YM" + Math.abs(m.hashCode());
    }

    private final class DetailRequestHandler
    extends RequestHandler {
        private DetailRequestHandler() {
            super(YangModelMessageHandler.DETAILS_REQ);
        }

        public void process(ObjectNode payload) {
            String name = this.string(payload, YangModelMessageHandler.ID);
            String modelId = this.string(payload, YangModelMessageHandler.MODEL_ID);
            YangModule module = YangModelMessageHandler.this.getModule(modelId, name);
            ObjectNode data = YangModelMessageHandler.this.objectNode();
            data.put(YangModelMessageHandler.ID, name);
            if (module != null) {
                data.put(YangModelMessageHandler.REVISION, module.getYangModuleId().revision());
                data.put(YangModelMessageHandler.MODEL_ID, modelId);
                ArrayNode source = YangModelMessageHandler.this.arrayNode();
                data.set(YangModelMessageHandler.SOURCE, (JsonNode)source);
                this.addSource(source, module.getYangSource());
            }
            ObjectNode rootNode = YangModelMessageHandler.this.objectNode();
            rootNode.set(YangModelMessageHandler.DETAILS, (JsonNode)data);
            this.sendMessage(YangModelMessageHandler.DETAILS_RESP, rootNode);
        }

        private void addSource(ArrayNode source, InputStream yangSource) {
            try (InputStreamReader isr = new InputStreamReader(yangSource);
                 BufferedReader br = new BufferedReader(isr);){
                String line;
                while ((line = br.readLine()) != null) {
                    source.add(line);
                }
            }
            catch (IOException e) {
                YangModelMessageHandler.this.log.warn("Unable to read YANG source", (Throwable)e);
            }
        }
    }

    private final class TableDataHandler
    extends TableRequestHandler {
        private static final String NO_ROWS_MESSAGE = "No YANG Models found";

        private TableDataHandler() {
            super(YangModelMessageHandler.TABLE_REQ, YangModelMessageHandler.TABLE_RESP, YangModelMessageHandler.MODELS);
        }

        protected String[] getColumnIds() {
            return COL_IDS;
        }

        protected String noRowsMessage(ObjectNode payload) {
            return NO_ROWS_MESSAGE;
        }

        protected void populateTable(TableModel tm, ObjectNode payload) {
            for (YangModel model : YangModelMessageHandler.this.modelRegistry.getModels()) {
                for (YangModuleId id : model.getYangModulesId()) {
                    this.populateRow(tm.addRow(), YangModelMessageHandler.this.modelId(model), id);
                }
            }
        }

        private void populateRow(TableModel.Row row, String modelId, YangModuleId moduleId) {
            row.cell(YangModelMessageHandler.ID, (Object)moduleId.moduleName()).cell(YangModelMessageHandler.REVISION, (Object)moduleId.revision()).cell(YangModelMessageHandler.MODEL_ID, (Object)modelId);
        }
    }
}

