/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.rest.device.impl;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import javax.ws.rs.ProcessingException;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onlab.packet.ChassisId;
import org.onlab.util.Tools;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.event.EventListener;
import org.onosproject.incubator.net.config.basics.ConfigException;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.MastershipRole;
import org.onosproject.net.PortNumber;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.behaviour.DevicesDiscovery;
import org.onosproject.net.behaviour.PortDiscovery;
import org.onosproject.net.config.ConfigFactory;
import org.onosproject.net.config.NetworkConfigEvent;
import org.onosproject.net.config.NetworkConfigListener;
import org.onosproject.net.config.NetworkConfigRegistry;
import org.onosproject.net.config.basics.SubjectFactories;
import org.onosproject.net.device.DefaultDeviceDescription;
import org.onosproject.net.device.DeviceDescription;
import org.onosproject.net.device.DeviceDescriptionDiscovery;
import org.onosproject.net.device.DeviceProvider;
import org.onosproject.net.device.DeviceProviderRegistry;
import org.onosproject.net.device.DeviceProviderService;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.driver.DefaultDriverData;
import org.onosproject.net.driver.DefaultDriverHandler;
import org.onosproject.net.driver.Driver;
import org.onosproject.net.driver.DriverData;
import org.onosproject.net.driver.DriverHandler;
import org.onosproject.net.driver.DriverService;
import org.onosproject.net.provider.AbstractProvider;
import org.onosproject.net.provider.Provider;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.protocol.rest.DefaultRestSBDevice;
import org.onosproject.protocol.rest.RestSBController;
import org.onosproject.protocol.rest.RestSBDevice;
import org.onosproject.provider.rest.device.impl.RestDeviceConfig;
import org.onosproject.provider.rest.device.impl.RestProviderConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class RestDeviceProvider
extends AbstractProvider
implements DeviceProvider {
    private static final String APP_NAME = "org.onosproject.restsb";
    protected static final String REST = "rest";
    private static final String JSON = "json";
    private static final String PROVIDER = "org.onosproject.provider.rest.device";
    private static final String IPADDRESS = "ipaddress";
    private static final String HTTPS = "https";
    private static final String AUTHORIZATION_PROPERTY = "authorization";
    private static final String BASIC_AUTH_PREFIX = "Basic ";
    private static final String URL_SEPARATOR = "://";
    protected static final String ISNOTNULL = "Rest device is not null";
    private static final String UNKNOWN = "unknown";
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceProviderRegistry providerRegistry;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected RestSBController controller;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected NetworkConfigRegistry cfgService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DriverService driverService;
    private DeviceProviderService providerService;
    private ApplicationId appId;
    private final ExecutorService executor = Executors.newFixedThreadPool(5, Tools.groupedThreads((String)"onos/restsbprovider", (String)"device-installer-%d", (Logger)this.log));
    protected final List<ConfigFactory> factories = ImmutableList.of((Object)new ConfigFactory<ApplicationId, RestProviderConfig>(SubjectFactories.APP_SUBJECT_FACTORY, RestProviderConfig.class, "devices", true){

        public RestProviderConfig createConfig() {
            return new RestProviderConfig();
        }
    }, (Object)new ConfigFactory<DeviceId, RestDeviceConfig>(SubjectFactories.DEVICE_SUBJECT_FACTORY, RestDeviceConfig.class, "rest"){

        public RestDeviceConfig createConfig() {
            return new RestDeviceConfig();
        }
    });
    private final NetworkConfigListener cfgLister = new InternalNetworkConfigListener();
    private Set<DeviceId> addedDevices = new HashSet<DeviceId>();

    @Activate
    public void activate() {
        this.appId = this.coreService.registerApplication(APP_NAME);
        this.providerService = (DeviceProviderService)this.providerRegistry.register((Provider)this);
        this.factories.forEach(arg_0 -> ((NetworkConfigRegistry)this.cfgService).registerConfigFactory(arg_0));
        this.cfgService.addListener((EventListener)this.cfgLister);
        this.executor.execute(this::createAndConnectDevices);
        this.executor.execute(this::createDevices);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.cfgService.removeListener((EventListener)this.cfgLister);
        this.controller.getDevices().keySet().forEach(this::deviceRemoved);
        this.providerRegistry.unregister((Provider)this);
        this.providerService = null;
        this.factories.forEach(arg_0 -> ((NetworkConfigRegistry)this.cfgService).unregisterConfigFactory(arg_0));
        this.log.info("Stopped");
    }

    public RestDeviceProvider() {
        super(new ProviderId(REST, PROVIDER));
    }

    public void triggerProbe(DeviceId deviceId) {
        this.log.info("Triggering probe on device {}", (Object)deviceId);
    }

    public void roleChanged(DeviceId deviceId, MastershipRole newRole) {
    }

    public boolean isReachable(DeviceId deviceId) {
        RestSBDevice restDevice = this.controller.getDevice(deviceId);
        if (restDevice == null && (restDevice = this.controller.getProxySBDevice(deviceId)) == null) {
            this.log.debug("the requested device id: " + deviceId.toString() + "  is not associated to any REST or REST proxy Device");
            return false;
        }
        return restDevice.isActive();
    }

    private void deviceAdded(RestSBDevice restSBDev) {
        Preconditions.checkNotNull((Object)restSBDev, (Object)ISNOTNULL);
        if (restSBDev.isProxy()) {
            Driver driver = this.driverService.getDriver((String)restSBDev.manufacturer().get(), (String)restSBDev.hwVersion().get(), (String)restSBDev.swVersion().get());
            if (driver != null && driver.hasBehaviour(DevicesDiscovery.class)) {
                DevicesDiscovery devicesDiscovery = this.devicesDiscovery(restSBDev, driver);
                Set deviceIds = devicesDiscovery.deviceIds();
                restSBDev.setActive(true);
                deviceIds.stream().forEach(deviceId -> {
                    this.controller.addProxiedDevice(deviceId, restSBDev);
                    DeviceDescription devDesc = devicesDiscovery.deviceDetails(deviceId);
                    Preconditions.checkNotNull((Object)devDesc, (Object)"deviceDescription cannot be null");
                    this.providerService.deviceConnected(deviceId, (DeviceDescription)this.mergeAnn(restSBDev.deviceId(), devDesc));
                    if (driver.hasBehaviour(DeviceDescriptionDiscovery.class)) {
                        DriverHandler h = this.driverService.createHandler(deviceId, new String[0]);
                        DeviceDescriptionDiscovery devDisc = (DeviceDescriptionDiscovery)h.behaviour(DeviceDescriptionDiscovery.class);
                        this.providerService.updatePorts(deviceId, devDisc.discoverPortDetails());
                    }
                    this.checkAndUpdateDevice((DeviceId)deviceId);
                    this.addedDevices.add((DeviceId)deviceId);
                });
            } else {
                this.log.warn("Driver not found for {}", (Object)restSBDev);
            }
        } else {
            DeviceId deviceId2 = restSBDev.deviceId();
            ChassisId cid = new ChassisId();
            String ipAddress = restSBDev.ip().toString();
            DefaultAnnotations annotations = DefaultAnnotations.builder().set(IPADDRESS, ipAddress).set("protocol", REST.toUpperCase()).build();
            DefaultDeviceDescription deviceDescription = new DefaultDeviceDescription(deviceId2.uri(), Device.Type.SWITCH, UNKNOWN, UNKNOWN, UNKNOWN, UNKNOWN, cid, new SparseAnnotations[]{annotations});
            restSBDev.setActive(true);
            this.providerService.deviceConnected(deviceId2, (DeviceDescription)deviceDescription);
            this.checkAndUpdateDevice(deviceId2);
            this.addedDevices.add(deviceId2);
        }
    }

    private DefaultDeviceDescription mergeAnn(DeviceId devId, DeviceDescription desc) {
        return new DefaultDeviceDescription(desc, new SparseAnnotations[]{DefaultAnnotations.merge((DefaultAnnotations)DefaultAnnotations.builder().set("protocol", REST.toUpperCase()).set("restServer", devId.toString()).build(), (SparseAnnotations)desc.annotations())});
    }

    private DevicesDiscovery devicesDiscovery(RestSBDevice restSBDevice, Driver driver) {
        DefaultDriverData driverData = new DefaultDriverData(driver, restSBDevice.deviceId());
        DevicesDiscovery devicesDiscovery = (DevicesDiscovery)driver.createBehaviour((DriverData)driverData, DevicesDiscovery.class);
        devicesDiscovery.setHandler((DriverHandler)new DefaultDriverHandler((DriverData)driverData));
        return devicesDiscovery;
    }

    private void checkAndUpdateDevice(DeviceId deviceId) {
        if (this.deviceService.getDevice(deviceId) == null) {
            this.log.warn("Device {} has not been added to store, maybe due to a problem in connectivity", (Object)deviceId);
        } else {
            boolean isReachable = this.isReachable(deviceId);
            if (isReachable && this.deviceService.isAvailable(deviceId)) {
                Device device = this.deviceService.getDevice(deviceId);
                if (device.is(DeviceDescriptionDiscovery.class)) {
                    DeviceDescriptionDiscovery deviceDescriptionDiscovery = (DeviceDescriptionDiscovery)device.as(DeviceDescriptionDiscovery.class);
                    DeviceDescription updatedDeviceDescription = deviceDescriptionDiscovery.discoverDeviceDetails();
                    if (updatedDeviceDescription != null && !this.descriptionEquals(device, updatedDeviceDescription)) {
                        this.providerService.deviceConnected(deviceId, (DeviceDescription)new DefaultDeviceDescription(updatedDeviceDescription, true, new SparseAnnotations[]{updatedDeviceDescription.annotations()}));
                        if (this.deviceService.getPorts(deviceId).isEmpty()) {
                            this.discoverPorts(deviceId);
                        }
                    }
                } else {
                    this.log.warn("No DeviceDescriptionDiscovery behaviour for device {}", (Object)deviceId);
                }
            } else if (!isReachable && this.deviceService.isAvailable(deviceId)) {
                this.providerService.deviceDisconnected(deviceId);
            }
        }
    }

    private boolean descriptionEquals(Device device, DeviceDescription updatedDeviceDescription) {
        return Objects.equal((Object)device.id().uri(), (Object)updatedDeviceDescription.deviceUri()) && Objects.equal((Object)device.type(), (Object)updatedDeviceDescription.type()) && Objects.equal((Object)device.manufacturer(), (Object)updatedDeviceDescription.manufacturer()) && Objects.equal((Object)device.hwVersion(), (Object)updatedDeviceDescription.hwVersion()) && Objects.equal((Object)device.swVersion(), (Object)updatedDeviceDescription.swVersion()) && Objects.equal((Object)device.serialNumber(), (Object)updatedDeviceDescription.serialNumber()) && Objects.equal((Object)device.chassisId(), (Object)updatedDeviceDescription.chassisId()) && Objects.equal((Object)device.annotations(), (Object)updatedDeviceDescription.annotations());
    }

    private void deviceRemoved(DeviceId deviceId) {
        Preconditions.checkNotNull((Object)deviceId, (Object)ISNOTNULL);
        this.providerService.deviceDisconnected(deviceId);
        this.controller.getProxiedDevices(deviceId).stream().forEach(device -> {
            this.controller.removeProxiedDevice(device);
            this.providerService.deviceDisconnected(device);
        });
        this.controller.removeDevice(deviceId);
    }

    private void createAndConnectDevices() {
        Set deviceSubjects = this.cfgService.getSubjects(DeviceId.class, RestDeviceConfig.class);
        this.connectDevices(deviceSubjects.stream().filter(deviceId -> this.deviceService.getDevice(deviceId) == null).map(deviceId -> {
            RestDeviceConfig config = (RestDeviceConfig)this.cfgService.getConfig(deviceId, RestDeviceConfig.class);
            DefaultRestSBDevice device = new DefaultRestSBDevice(config.ip(), config.port(), config.username(), config.password(), config.protocol(), config.url(), false, config.testUrl(), config.manufacturer(), config.hwVersion(), config.swVersion());
            return device;
        }).collect(Collectors.toSet()));
    }

    private void createDevices() {
        RestProviderConfig cfg = (RestProviderConfig)this.cfgService.getConfig((Object)this.appId, RestProviderConfig.class);
        try {
            if (cfg != null && cfg.getDevicesAddresses() != null) {
                this.connectDevices(cfg.getDevicesAddresses());
            }
        }
        catch (ConfigException e) {
            this.log.error("Configuration error {}", (Throwable)e);
        }
        this.log.debug("REST Devices {}", (Object)this.controller.getDevices());
        this.addedDevices.clear();
    }

    private void connectDevices(Set<RestSBDevice> devices) {
        HashSet toBeRemoved = new HashSet(this.controller.getDevices().values());
        toBeRemoved.removeAll(devices);
        devices.stream().filter(device -> {
            device.setActive(false);
            this.controller.addDevice(device);
            return this.testDeviceConnection((RestSBDevice)device);
        }).forEach(device -> this.deviceAdded((RestSBDevice)device));
        toBeRemoved.forEach(device -> this.deviceRemoved(device.deviceId()));
    }

    private void discoverPorts(DeviceId deviceId) {
        Device device = this.deviceService.getDevice(deviceId);
        if (device.is(PortDiscovery.class)) {
            PortDiscovery portConfig = (PortDiscovery)device.as(PortDiscovery.class);
            this.providerService.updatePorts(deviceId, portConfig.getPorts());
        } else {
            DeviceDescriptionDiscovery deviceDescriptionDiscovery = (DeviceDescriptionDiscovery)device.as(DeviceDescriptionDiscovery.class);
            this.providerService.updatePorts(deviceId, deviceDescriptionDiscovery.discoverPortDetails());
        }
    }

    private boolean testDeviceConnection(RestSBDevice dev) {
        try {
            if (dev.testUrl().isPresent()) {
                return this.controller.get(dev.deviceId(), (String)dev.testUrl().get(), JSON) != null;
            }
            return this.controller.get(dev.deviceId(), "", JSON) != null;
        }
        catch (ProcessingException e) {
            this.log.warn("Cannot connect to device {}", (Object)dev, (Object)e);
            return false;
        }
    }

    public void changePortState(DeviceId deviceId, PortNumber portNumber, boolean enable) {
    }

    protected void bindProviderRegistry(DeviceProviderRegistry deviceProviderRegistry) {
        this.providerRegistry = deviceProviderRegistry;
    }

    protected void unbindProviderRegistry(DeviceProviderRegistry deviceProviderRegistry) {
        if (this.providerRegistry == deviceProviderRegistry) {
            this.providerRegistry = null;
        }
    }

    protected void bindController(RestSBController restSBController) {
        this.controller = restSBController;
    }

    protected void unbindController(RestSBController restSBController) {
        if (this.controller == restSBController) {
            this.controller = null;
        }
    }

    protected void bindCfgService(NetworkConfigRegistry networkConfigRegistry) {
        this.cfgService = networkConfigRegistry;
    }

    protected void unbindCfgService(NetworkConfigRegistry networkConfigRegistry) {
        if (this.cfgService == networkConfigRegistry) {
            this.cfgService = null;
        }
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }

    protected void bindDriverService(DriverService driverService) {
        this.driverService = driverService;
    }

    protected void unbindDriverService(DriverService driverService) {
        if (this.driverService == driverService) {
            this.driverService = null;
        }
    }

    private class InternalNetworkConfigListener
    implements NetworkConfigListener {
        private InternalNetworkConfigListener() {
        }

        public void event(NetworkConfigEvent event) {
            if (event.configClass().equals(RestDeviceConfig.class)) {
                RestDeviceProvider.this.executor.execute(() -> RestDeviceProvider.this.createAndConnectDevices());
            } else {
                RestDeviceProvider.this.log.warn("Injecting device via this Json is deprecated, please put configuration under devices/");
                RestDeviceProvider.this.executor.execute(() -> RestDeviceProvider.this.createDevices());
            }
        }

        public boolean isRelevant(NetworkConfigEvent event) {
            return !(!event.configClass().equals(RestDeviceConfig.class) && !event.configClass().equals(RestProviderConfig.class) || event.type() != NetworkConfigEvent.Type.CONFIG_ADDED && event.type() != NetworkConfigEvent.Type.CONFIG_UPDATED);
        }
    }
}

