/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.rest.device.impl;

import com.google.common.annotations.Beta;
import org.apache.commons.lang3.tuple.Pair;
import org.onlab.packet.IpAddress;
import org.onosproject.net.DeviceId;
import org.onosproject.net.config.Config;

@Beta
public class RestDeviceConfig
extends Config<DeviceId> {
    private static final String IP = "ip";
    private static final String PORT = "port";
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";
    private static final String PROTOCOL = "protocol";
    private static final String URL = "url";
    private static final String TESTURL = "testUrl";
    private static final String MANUFACTURER = "manufacturer";
    private static final String HWVERSION = "hwVersion";
    private static final String SWVERSION = "swVersion";

    public boolean isValid() {
        return this.hasOnlyFields(new String[]{IP, PORT, USERNAME, PASSWORD, PROTOCOL, URL, TESTURL, MANUFACTURER, HWVERSION, SWVERSION}) && this.ip() != null;
    }

    public IpAddress ip() {
        return IpAddress.valueOf((String)this.get(IP, (String)this.extractIpPort().getKey()));
    }

    public int port() {
        return this.get(PORT, (Integer)this.extractIpPort().getValue());
    }

    public String protocol() {
        return this.get(PROTOCOL, "http");
    }

    public String username() {
        return this.get(USERNAME, "");
    }

    public String password() {
        return this.get(PASSWORD, "");
    }

    public String url() {
        return this.get(URL, "");
    }

    public String testUrl() {
        return this.get(TESTURL, "");
    }

    public String manufacturer() {
        return this.get(MANUFACTURER, "");
    }

    public String hwVersion() {
        return this.get(HWVERSION, "");
    }

    public String swVersion() {
        return this.get(SWVERSION, "");
    }

    private Pair<String, Integer> extractIpPort() {
        String info = ((DeviceId)this.subject).toString();
        if (info.startsWith("rest")) {
            String ip = info.substring(info.indexOf(":") + 1, info.lastIndexOf(":"));
            int port = Integer.parseInt(info.substring(info.lastIndexOf(":") + 1));
            return Pair.of((Object)ip, (Object)port);
        }
        return null;
    }
}

