/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.lisp.device.impl;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onlab.packet.ChassisId;
import org.onlab.packet.IpAddress;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.lisp.ctl.LispController;
import org.onosproject.lisp.ctl.LispRouterId;
import org.onosproject.lisp.ctl.LispRouterListener;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.MastershipRole;
import org.onosproject.net.PortNumber;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.device.DefaultDeviceDescription;
import org.onosproject.net.device.DeviceDescription;
import org.onosproject.net.device.DeviceProvider;
import org.onosproject.net.device.DeviceProviderRegistry;
import org.onosproject.net.device.DeviceProviderService;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.provider.AbstractProvider;
import org.onosproject.net.provider.Provider;
import org.onosproject.net.provider.ProviderId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class LispDeviceProvider
extends AbstractProvider
implements DeviceProvider {
    private static final Logger log = LoggerFactory.getLogger(LispDeviceProvider.class);
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceProviderRegistry providerRegistry;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected LispController controller;
    private static final String APP_NAME = "org.onosproject.lisp";
    private static final String SCHEME_NAME = "lisp";
    private static final String DEVICE_PROVIDER_PACKAGE = "org.onosproject.lisp.provider.device";
    private static final String MANUFACTURER = "IETF";
    private static final String HARDWARE_VERSION = "LISP Reference Router";
    private static final String SOFTWARE_VERSION = "1.0";
    private static final String SERIAL_NUMBER = "unknown";
    private static final String IS_NULL_MSG = "LISP device info is null";
    private static final String IPADDRESS = "ipaddress";
    private static final String LISP = "lisp";
    protected DeviceProviderService providerService;
    private InternalLispRouterListener routerListener = new InternalLispRouterListener();
    private ApplicationId appId;

    public LispDeviceProvider() {
        super(new ProviderId("lisp", DEVICE_PROVIDER_PACKAGE));
    }

    @Activate
    public void activate() {
        this.providerService = (DeviceProviderService)this.providerRegistry.register((Provider)this);
        this.appId = this.coreService.registerApplication(APP_NAME);
        this.controller.addRouterListener((LispRouterListener)this.routerListener);
        log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.controller.getRouters().forEach(router -> this.controller.disconnectRouter(new LispRouterId(router.routerId()), true));
        this.controller.removeRouterListener((LispRouterListener)this.routerListener);
        this.providerRegistry.unregister((Provider)this);
        this.providerService = null;
        log.info("Stopped");
    }

    public void triggerProbe(DeviceId deviceId) {
        log.info("Triggering probe on device {}", (Object)deviceId);
    }

    public void roleChanged(DeviceId deviceId, MastershipRole newRole) {
    }

    public boolean isReachable(DeviceId deviceId) {
        return true;
    }

    public void changePortState(DeviceId deviceId, PortNumber portNumber, boolean enable) {
        log.info("This operation is irrelevant for LISP router");
    }

    private void connectDevice(LispRouterId routerId) {
        DeviceId deviceId = this.getDeviceId(((IpAddress)routerId.id()).toString());
        Preconditions.checkNotNull((Object)deviceId, (Object)IS_NULL_MSG);
        ChassisId cid = new ChassisId();
        String ipAddress = ((IpAddress)routerId.id()).toString();
        DefaultAnnotations annotations = DefaultAnnotations.builder().set(IPADDRESS, ipAddress).set("protocol", "lisp".toUpperCase()).build();
        DefaultDeviceDescription deviceDescription = new DefaultDeviceDescription(deviceId.uri(), Device.Type.ROUTER, MANUFACTURER, HARDWARE_VERSION, SOFTWARE_VERSION, SERIAL_NUMBER, cid, false, new SparseAnnotations[]{annotations});
        if (this.deviceService.getDevice(deviceId) == null) {
            this.providerService.deviceConnected(deviceId, (DeviceDescription)deviceDescription);
        }
        this.checkAndUpdateDevice(deviceId, (DeviceDescription)deviceDescription);
    }

    private void checkAndUpdateDevice(DeviceId deviceId, DeviceDescription deviceDescription) {
        if (this.deviceService.getDevice(deviceId) == null) {
            log.warn("LISP router {} has not been added to store", (Object)deviceId);
        } else {
            boolean isReachable = this.isReachable(deviceId);
            if ((!isReachable || this.deviceService.isAvailable(deviceId)) && !isReachable && this.deviceService.isAvailable(deviceId)) {
                this.providerService.deviceDisconnected(deviceId);
            }
        }
    }

    private DeviceId getDeviceId(String ip) {
        try {
            return DeviceId.deviceId((URI)new URI("lisp", ip, null));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Unable to build deviceID for device " + ip, e);
        }
    }

    protected void bindProviderRegistry(DeviceProviderRegistry deviceProviderRegistry) {
        this.providerRegistry = deviceProviderRegistry;
    }

    protected void unbindProviderRegistry(DeviceProviderRegistry deviceProviderRegistry) {
        if (this.providerRegistry == deviceProviderRegistry) {
            this.providerRegistry = null;
        }
    }

    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindController(LispController lispController) {
        this.controller = lispController;
    }

    protected void unbindController(LispController lispController) {
        if (this.controller == lispController) {
            this.controller = null;
        }
    }

    private class InternalLispRouterListener
    implements LispRouterListener {
        private InternalLispRouterListener() {
        }

        public void routerAdded(LispRouterId routerId) {
            LispDeviceProvider.this.connectDevice(routerId);
            log.debug("LISP router {} added to core.", (Object)routerId);
        }

        public void routerRemoved(LispRouterId routerId) {
            Preconditions.checkNotNull((Object)routerId, (Object)LispDeviceProvider.IS_NULL_MSG);
            DeviceId deviceId = LispDeviceProvider.this.getDeviceId(((IpAddress)routerId.id()).toString());
            if (LispDeviceProvider.this.deviceService.getDevice(deviceId) != null) {
                LispDeviceProvider.this.providerService.deviceDisconnected(deviceId);
                log.debug("LISP router {} removed from LISP controller", (Object)deviceId);
            } else {
                log.warn("LISP router {} does not exist in the store, or it may already have been removed", (Object)deviceId);
            }
        }

        public void routerChanged(LispRouterId routerId) {
        }
    }
}

