/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.corsa;

import java.util.Collection;
import java.util.Collections;
import org.onlab.packet.Ethernet;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onosproject.drivers.corsa.AbstractCorsaPipeline;
import org.onosproject.net.flow.DefaultFlowRule;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.FlowRuleOperations;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.criteria.Criterion;
import org.onosproject.net.flow.criteria.EthCriterion;
import org.onosproject.net.flow.criteria.IPCriterion;
import org.onosproject.net.flow.criteria.IPProtocolCriterion;
import org.onosproject.net.flow.criteria.PortCriterion;
import org.onosproject.net.flow.criteria.VlanIdCriterion;
import org.onosproject.net.flowobjective.FilteringObjective;
import org.onosproject.net.flowobjective.ForwardingObjective;
import org.onosproject.net.flowobjective.Objective;
import org.onosproject.net.flowobjective.ObjectiveError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OvsCorsaPipeline
extends AbstractCorsaPipeline {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected static final int MAC_TABLE = 0;
    protected static final int VLAN_MPLS_TABLE = 1;
    protected static final int VLAN_TABLE = 2;
    protected static final int ETHER_TABLE = 4;
    protected static final int COS_MAP_TABLE = 5;
    protected static final int FIB_TABLE = 6;
    protected static final int LOCAL_TABLE = 9;

    @Override
    protected Collection<FlowRule> processArpTraffic(ForwardingObjective fwd, FlowRule.Builder rule) {
        this.log.warn("Driver automatically handles ARP packets by punting to controller  from ETHER table");
        this.pass((Objective)fwd);
        return Collections.emptyList();
    }

    @Override
    protected Collection<FlowRule> processLinkDiscovery(ForwardingObjective fwd, FlowRule.Builder rule) {
        this.log.warn("Driver currently does not currently handle LLDP packets");
        this.fail((Objective)fwd, ObjectiveError.UNSUPPORTED);
        return Collections.emptyList();
    }

    @Override
    protected Collection<FlowRule> processIpTraffic(ForwardingObjective fwd, FlowRule.Builder rule) {
        IPCriterion ipSrc = (IPCriterion)fwd.selector().getCriterion(Criterion.Type.IPV4_SRC);
        if (ipSrc != null) {
            this.log.warn("Driver does not currently handle matching Src IP");
            this.fail((Objective)fwd, ObjectiveError.UNSUPPORTED);
            return Collections.emptySet();
        }
        IPCriterion ipDst = (IPCriterion)fwd.selector().getCriterion(Criterion.Type.IPV4_DST);
        if (ipDst != null) {
            this.log.error("Driver handles Dst IP matching as specific forwarding objective, not versatile");
            this.fail((Objective)fwd, ObjectiveError.UNSUPPORTED);
            return Collections.emptySet();
        }
        IPProtocolCriterion ipProto = (IPProtocolCriterion)fwd.selector().getCriterion(Criterion.Type.IP_PROTO);
        if (ipProto != null && ipProto.protocol() == 6) {
            this.log.warn("Driver automatically punts all packets reaching the LOCAL table to the controller");
            this.pass((Objective)fwd);
            return Collections.emptySet();
        }
        return Collections.emptySet();
    }

    @Override
    protected FlowRule.Builder processSpecificRoutingRule(FlowRule.Builder rb) {
        return rb.forTable(6);
    }

    @Override
    protected FlowRule.Builder processIpFilter(FilteringObjective filt, IPCriterion ip, PortCriterion port) {
        this.log.debug("adding rule for IP: {}", (Object)ip.ip());
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder();
        selector.matchEthType(Ethernet.TYPE_IPV4);
        selector.matchIPDst(ip.ip());
        treatment.transition(Integer.valueOf(9));
        return DefaultFlowRule.builder().withSelector(selector.build()).withTreatment(treatment.build()).withPriority(65535).makePermanent().forTable(6);
    }

    @Override
    protected FlowRule.Builder processVlanFiler(FilteringObjective filt, VlanIdCriterion vlan, PortCriterion port) {
        this.log.debug("adding rule for VLAN: {}", (Object)vlan.vlanId());
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder();
        selector.matchVlanId(vlan.vlanId());
        selector.matchInPort(port.port());
        treatment.transition(Integer.valueOf(4));
        treatment.deferred().popVlan();
        return DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector.build()).withTreatment(treatment.build()).withPriority(255).makePermanent().forTable(2);
    }

    @Override
    protected FlowRule.Builder processEthFiler(FilteringObjective filt, EthCriterion eth, PortCriterion port) {
        this.log.debug("adding rule for MAC: {}", (Object)eth.mac());
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder();
        selector.matchEthDst(eth.mac());
        treatment.transition(Integer.valueOf(1));
        return DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector.build()).withTreatment(treatment.build()).withPriority(255).makePermanent().forTable(0);
    }

    @Override
    protected void initializePipeline() {
        this.processMacTable(true);
        this.processVlanMplsTable(true);
        this.processVlanTable(true);
        this.processEtherTable(true);
        this.processCosTable(true);
        this.processFibTable(true);
        this.processLocalTable(true);
    }

    private void processMacTable(boolean install) {
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder();
        selector.matchEthDst(MacAddress.BROADCAST);
        treatment.transition(Integer.valueOf(1));
        FlowRule rule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector.build()).withTreatment(treatment.build()).withPriority(255).fromApp(this.appId).makePermanent().forTable(0).build();
        this.processFlowRule(true, rule, "Provisioned mac table transition");
        this.processTableMissDrop(true, 0, "Provisioned mac table drop action");
    }

    protected void processVlanMplsTable(boolean install) {
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder();
        FlowRuleOperations.Builder ops = FlowRuleOperations.builder();
        selector.matchVlanId(VlanId.ANY);
        treatment.transition(Integer.valueOf(2));
        FlowRule rule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector.build()).withTreatment(treatment.build()).withPriority(255).fromApp(this.appId).makePermanent().forTable(1).build();
        this.processFlowRule(true, rule, "Provisioned vlan/mpls table");
    }

    private void processVlanTable(boolean install) {
        this.processTableMissDrop(true, 2, "Provisioned vlan table");
    }

    private void processEtherTable(boolean install) {
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder().matchEthType(Ethernet.TYPE_ARP);
        TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder().punt();
        FlowRule rule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector.build()).withTreatment(treatment.build()).withPriority(255).fromApp(this.appId).makePermanent().forTable(4).build();
        this.processFlowRule(true, rule, "Provisioned ether table");
        selector = DefaultTrafficSelector.builder().matchEthType(Ethernet.TYPE_IPV4);
        treatment = DefaultTrafficTreatment.builder().transition(Integer.valueOf(5));
        rule = DefaultFlowRule.builder().forDevice(this.deviceId).withPriority(255).withSelector(selector.build()).withTreatment(treatment.build()).fromApp(this.appId).makePermanent().forTable(4).build();
        this.processFlowRule(true, rule, "Provisioned ether table");
        this.processTableMissDrop(true, 2, "Provisioned ether table");
    }

    private void processCosTable(boolean install) {
        TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder().transition(Integer.valueOf(6));
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        FlowRule rule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector.build()).withTreatment(treatment.build()).withPriority(0).fromApp(this.appId).makePermanent().forTable(5).build();
        this.processFlowRule(true, rule, "Provisioned cos table");
    }

    private void processFibTable(boolean install) {
        this.processTableMissDrop(true, 6, "Provisioned FIB table");
    }

    private void processLocalTable(boolean install) {
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder().punt();
        FlowRule rule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector.build()).withTreatment(treatment.build()).withPriority(255).fromApp(this.appId).makePermanent().forTable(9).build();
        this.processFlowRule(true, rule, "Provisioned Local table");
    }
}

