/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.corsa;

import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import org.onosproject.net.meter.MeterId;
import org.onosproject.openflow.controller.driver.AbstractOpenFlowSwitch;
import org.onosproject.openflow.controller.driver.SwitchDriverSubHandshakeAlreadyStarted;
import org.onosproject.openflow.controller.driver.SwitchDriverSubHandshakeCompleted;
import org.onosproject.openflow.controller.driver.SwitchDriverSubHandshakeNotStarted;
import org.projectfloodlight.openflow.protocol.OFBarrierRequest;
import org.projectfloodlight.openflow.protocol.OFFlowDelete;
import org.projectfloodlight.openflow.protocol.OFGroupDelete;
import org.projectfloodlight.openflow.protocol.OFGroupType;
import org.projectfloodlight.openflow.protocol.OFMessage;
import org.projectfloodlight.openflow.protocol.OFMeterMod;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.types.OFGroup;
import org.projectfloodlight.openflow.types.TableId;

public class CorsaSwitchHandshaker
extends AbstractOpenFlowSwitch {
    private AtomicBoolean handshakeComplete = new AtomicBoolean(false);
    private int barrierXid;

    public Boolean supportNxRole() {
        return false;
    }

    public void startDriverHandshake() {
        if (this.startDriverHandshakeCalled) {
            throw new SwitchDriverSubHandshakeAlreadyStarted();
        }
        this.startDriverHandshakeCalled = true;
        OFFlowDelete fm = this.factory().buildFlowDelete().setTableId(TableId.ALL).setOutGroup(OFGroup.ANY).build();
        this.sendMsg(Collections.singletonList(fm));
        OFGroupDelete gm = this.factory().buildGroupDelete().setGroup(OFGroup.ALL).setGroupType(OFGroupType.ALL).build();
        this.sendMsg(Collections.singletonList(gm));
        OFMeterMod mm = this.factory().buildMeterMod().setMeterId(((Long)MeterId.ALL.id()).longValue()).build();
        this.sendMsg(Collections.singletonList(mm));
        this.barrierXid = this.getNextTransactionId();
        OFBarrierRequest barrier = this.factory().buildBarrierRequest().setXid((long)this.barrierXid).build();
        this.sendHandshakeMessage((OFMessage)barrier);
    }

    public boolean isDriverHandshakeComplete() {
        if (!this.startDriverHandshakeCalled) {
            throw new SwitchDriverSubHandshakeAlreadyStarted();
        }
        return this.handshakeComplete.get();
    }

    public void processDriverHandshakeMessage(OFMessage m) {
        if (!this.startDriverHandshakeCalled) {
            throw new SwitchDriverSubHandshakeNotStarted();
        }
        if (this.handshakeComplete.get()) {
            throw new SwitchDriverSubHandshakeCompleted(m);
        }
        if (m.getType() == OFType.BARRIER_REPLY && m.getXid() == (long)this.barrierXid) {
            this.handshakeComplete.set(true);
        }
    }
}

