/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.corsa;

import com.google.common.collect.ImmutableSet;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.onlab.packet.Ethernet;
import org.onlab.packet.VlanId;
import org.onosproject.drivers.corsa.AbstractCorsaPipeline;
import org.onosproject.drivers.corsa.CorsaPipelineV3;
import org.onosproject.net.flow.DefaultFlowRule;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.criteria.Criterion;
import org.onosproject.net.flow.criteria.IPCriterion;
import org.onosproject.net.flow.criteria.IPProtocolCriterion;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.flow.instructions.Instructions;
import org.onosproject.net.flow.instructions.L2ModificationInstruction;
import org.onosproject.net.flowobjective.ForwardingObjective;
import org.onosproject.net.flowobjective.Objective;
import org.onosproject.net.flowobjective.ObjectiveError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CorsaPipelineV39
extends CorsaPipelineV3 {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final Short NATIVE_VLAN = 4095;

    @Override
    public void initializePipeline() {
        this.processMeterTable(true);
        this.processPortBasedProtoTable(true);
        this.processVlanCheckTable(true);
        this.processVlanMacXlateTable(true);
        this.processVlanCircuitTable(true);
        this.processL3IFMacDATable(true);
        this.processEtherTable(true);
        this.processFibTable(true);
    }

    @Override
    protected void processVlanCheckTable(boolean install) {
        this.processTableMissGoTo(true, 1, 2, "Provisioned vlan tagged");
        this.processUntaggedPackets(install);
    }

    private void processUntaggedPackets(boolean install) {
        this.deviceService.getPorts(this.deviceId).forEach(port -> {
            if (!port.number().isLogical()) {
                TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder().pushVlan().setVlanId(VlanId.vlanId((short)NATIVE_VLAN)).transition(Integer.valueOf(2));
                TrafficSelector.Builder selector = DefaultTrafficSelector.builder().matchVlanId(VlanId.NONE).matchInPort(port.number());
                FlowRule.Builder rule = DefaultFlowRule.builder().forDevice(this.deviceId).withTreatment(treatment.build()).withSelector(selector.build()).withPriority(255).fromApp(this.appId).makePermanent().forTable(1);
                this.processFlowRule(install, rule.build(), "Provisioned vlan untagged packet table");
            }
        });
    }

    @Override
    protected void processVlanCircuitTable(boolean install) {
        this.processTableMissDrop(install, 3, "Provisioned vlan circuit table drop");
        this.processRouterPacket(install);
    }

    private void processRouterPacket(boolean install) {
        this.deviceService.getPorts(this.deviceId).forEach(port -> {
            if (!port.number().isLogical()) {
                TrafficSelector.Builder selector = DefaultTrafficSelector.builder().matchVlanId(VlanId.vlanId((short)NATIVE_VLAN)).matchInPort(port.number());
                TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder().setVlanPcp(Byte.valueOf((byte)0)).setQueue(0L).meter(this.defaultMeterId).transition(Integer.valueOf(5));
                FlowRule rule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector.build()).withTreatment(treatment.build()).withPriority(255).fromApp(this.appId).makePermanent().forTable(3).build();
                this.processFlowRule(install, rule, "Provisioned vlan circuit table");
            }
        });
    }

    @Override
    protected void processL3IFMacDATable(boolean install) {
        int table = 5;
        this.processTableMissDrop(install, table, "Provisioned l3 table drop");
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder().transition(Integer.valueOf(6));
        FlowRule rule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector.build()).withTreatment(treatment.build()).withPriority(1).fromApp(this.appId).makePermanent().forTable(table).build();
        this.processFlowRule(install, rule, "Provisioned l3 table");
    }

    @Override
    protected void processEtherTable(boolean install) {
        this.processTableMissDrop(install, 6, "Provisioned ether type table drop");
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder().matchEthType(Ethernet.TYPE_IPV4);
        TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder().transition(Integer.valueOf(7));
        FlowRule rule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector.build()).withTreatment(treatment.build()).withPriority(255).fromApp(this.appId).makePermanent().forTable(6).build();
        this.processFlowRule(install, rule, "Provisioned ether type table ip");
    }

    @Override
    protected Collection<FlowRule> processArpTraffic(ForwardingObjective fwd, FlowRule.Builder rule) {
        rule.forTable(0);
        rule.withPriority(255);
        return Collections.singletonList(rule.build());
    }

    @Override
    protected Collection<FlowRule> processLinkDiscovery(ForwardingObjective fwd, FlowRule.Builder rule) {
        rule.forTable(0);
        rule.withPriority(255);
        return Collections.singletonList(rule.build());
    }

    @Override
    protected Collection<FlowRule> processIpTraffic(ForwardingObjective fwd, FlowRule.Builder rule) {
        IPCriterion ipSrc = (IPCriterion)fwd.selector().getCriterion(Criterion.Type.IPV4_SRC);
        if (ipSrc != null) {
            this.log.warn("Driver does not currently handle matching Src IP");
            this.fail((Objective)fwd, ObjectiveError.UNSUPPORTED);
            return ImmutableSet.of();
        }
        IPCriterion ipDst = (IPCriterion)fwd.selector().getCriterion(Criterion.Type.IPV4_DST);
        if (ipDst != null) {
            this.log.error("Driver handles Dst IP matching as specific forwarding objective, not versatile");
            this.fail((Objective)fwd, ObjectiveError.UNSUPPORTED);
            return ImmutableSet.of();
        }
        IPProtocolCriterion ipProto = (IPProtocolCriterion)fwd.selector().getCriterion(Criterion.Type.IP_PROTO);
        if (ipProto != null && ipProto.protocol() == 6) {
            this.log.warn("Driver automatically punts all packets reaching the LOCAL table to the controller");
            this.pass((Objective)fwd);
            return ImmutableSet.of();
        }
        return ImmutableSet.of();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected AbstractCorsaPipeline.CorsaTrafficTreatment processNextTreatment(TrafficTreatment treatment) {
        tb = DefaultTrafficTreatment.builder();
        treatment.immediate().stream().filter((Predicate<Instruction>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$processNextTreatment$2(org.onosproject.net.flow.instructions.Instruction ), (Lorg/onosproject/net/flow/instructions/Instruction;)Z)()).forEach((Consumer<Instruction>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$processNextTreatment$3(org.onosproject.net.flow.TrafficTreatment$Builder org.onosproject.net.flow.instructions.Instruction ), (Lorg/onosproject/net/flow/instructions/Instruction;)V)((TrafficTreatment.Builder)tb));
        t = tb.build();
        isPresentModVlanId = false;
        isPresentModEthSrc = false;
        isPresentModEthDst = false;
        isPresentOutpuPort = false;
        for (Instruction instruction : t.immediate()) {
            switch (1.$SwitchMap$org$onosproject$net$flow$instructions$Instruction$Type[instruction.type().ordinal()]) {
                case 1: {
                    l2i = (L2ModificationInstruction)instruction;
                    if (l2i instanceof L2ModificationInstruction.ModVlanIdInstruction) {
                        isPresentModVlanId = true;
                    }
                    if (!(l2i instanceof L2ModificationInstruction.ModEtherInstruction)) ** GOTO lbl21
                    subType = l2i.subtype();
                    if (!subType.equals((Object)L2ModificationInstruction.L2SubType.ETH_SRC)) ** GOTO lbl19
                    isPresentModEthSrc = true;
                    ** GOTO lbl21
lbl19:
                    // 1 sources

                    if (subType.equals((Object)L2ModificationInstruction.L2SubType.ETH_DST)) {
                        isPresentModEthDst = true;
                    }
                }
lbl21:
                // 6 sources

                case 2: {
                    isPresentOutpuPort = true;
                }
            }
        }
        type = AbstractCorsaPipeline.CorsaTrafficTreatmentType.ACTIONS;
        if (isPresentModVlanId && isPresentModEthSrc && isPresentModEthDst && isPresentOutpuPort) {
            type = AbstractCorsaPipeline.CorsaTrafficTreatmentType.GROUP;
        } else if (isPresentModVlanId == false && isPresentModEthSrc != false && isPresentModEthDst != false && isPresentOutpuPort != false || isPresentModVlanId == false && isPresentModEthSrc == false && isPresentModEthDst != false && isPresentOutpuPort != false || !isPresentModVlanId && !isPresentModEthSrc && !isPresentModEthDst && isPresentOutpuPort) {
            type = AbstractCorsaPipeline.CorsaTrafficTreatmentType.GROUP;
            tb2 = DefaultTrafficTreatment.builder((TrafficTreatment)t);
            tb2.add(Instructions.popVlan());
            t = tb2.build();
        }
        corsaTreatment = new AbstractCorsaPipeline.CorsaTrafficTreatment(type, t);
        return corsaTreatment;
    }

    private static /* synthetic */ void lambda$processNextTreatment$3(TrafficTreatment.Builder tb, Instruction i) {
        tb.add(i);
    }

    private static /* synthetic */ boolean lambda$processNextTreatment$2(Instruction i) {
        switch (i.type()) {
            case L2MODIFICATION: {
                L2ModificationInstruction l2i = (L2ModificationInstruction)i;
                if (l2i.subtype() == L2ModificationInstruction.L2SubType.VLAN_ID || l2i.subtype() == L2ModificationInstruction.L2SubType.VLAN_POP || l2i.subtype() == L2ModificationInstruction.L2SubType.ETH_DST || l2i.subtype() == L2ModificationInstruction.L2SubType.ETH_SRC) {
                    return true;
                }
            }
            case OUTPUT: {
                return true;
            }
        }
        return false;
    }
}

