/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.corsa;

import com.google.common.collect.ImmutableSet;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.onlab.packet.Ethernet;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onosproject.drivers.corsa.AbstractCorsaPipeline;
import org.onosproject.net.flow.DefaultFlowRule;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.criteria.Criterion;
import org.onosproject.net.flow.criteria.EthCriterion;
import org.onosproject.net.flow.criteria.IPCriterion;
import org.onosproject.net.flow.criteria.PortCriterion;
import org.onosproject.net.flow.criteria.VlanIdCriterion;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.flow.instructions.L2ModificationInstruction;
import org.onosproject.net.flowobjective.FilteringObjective;
import org.onosproject.net.flowobjective.ForwardingObjective;
import org.onosproject.net.flowobjective.NextObjective;
import org.onosproject.net.flowobjective.Objective;
import org.onosproject.net.flowobjective.ObjectiveError;
import org.onosproject.net.meter.Band;
import org.onosproject.net.meter.DefaultBand;
import org.onosproject.net.meter.DefaultMeterRequest;
import org.onosproject.net.meter.Meter;
import org.onosproject.net.meter.MeterId;
import org.onosproject.net.meter.MeterRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CorsaPipelineV3
extends AbstractCorsaPipeline {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected static final int PORT_BASED_PROTO_TABLE = 0;
    protected static final int VLAN_CHECK_TABLE = 1;
    protected static final int VLAN_MAC_XLATE_TABLE = 2;
    protected static final int VLAN_CIRCUIT_TABLE = 3;
    protected static final int PRIORITY_MAP_TABLE = 4;
    protected static final int L3_IF_MAC_DA_TABLE = 5;
    protected static final int ETHER_TABLE = 6;
    protected static final int FIB_TABLE = 7;
    protected static final int LOCAL_TABLE = 9;
    protected static final byte MAX_VLAN_PCP = 7;
    protected MeterId defaultMeterId = null;

    /*
     * Unable to fully structure code
     */
    @Override
    protected AbstractCorsaPipeline.CorsaTrafficTreatment processNextTreatment(TrafficTreatment treatment) {
        tb = DefaultTrafficTreatment.builder();
        treatment.immediate().stream().filter((Predicate<Instruction>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$processNextTreatment$0(org.onosproject.net.flow.instructions.Instruction ), (Lorg/onosproject/net/flow/instructions/Instruction;)Z)()).forEach((Consumer<Instruction>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$processNextTreatment$1(org.onosproject.net.flow.TrafficTreatment$Builder org.onosproject.net.flow.instructions.Instruction ), (Lorg/onosproject/net/flow/instructions/Instruction;)V)((TrafficTreatment.Builder)tb));
        t = tb.build();
        isPresentModVlanId = false;
        isPresentModEthSrc = false;
        isPresentModEthDst = false;
        isPresentOutpuPort = false;
        for (Instruction instruction : t.immediate()) {
            switch (1.$SwitchMap$org$onosproject$net$flow$instructions$Instruction$Type[instruction.type().ordinal()]) {
                case 1: {
                    l2i = (L2ModificationInstruction)instruction;
                    if (l2i instanceof L2ModificationInstruction.ModVlanIdInstruction) {
                        isPresentModVlanId = true;
                    }
                    if (!(l2i instanceof L2ModificationInstruction.ModEtherInstruction)) ** GOTO lbl21
                    subType = l2i.subtype();
                    if (!subType.equals((Object)L2ModificationInstruction.L2SubType.ETH_SRC)) ** GOTO lbl19
                    isPresentModEthSrc = true;
                    ** GOTO lbl21
lbl19:
                    // 1 sources

                    if (subType.equals((Object)L2ModificationInstruction.L2SubType.ETH_DST)) {
                        isPresentModEthDst = true;
                    }
                }
lbl21:
                // 6 sources

                case 2: {
                    isPresentOutpuPort = true;
                }
            }
        }
        type = AbstractCorsaPipeline.CorsaTrafficTreatmentType.ACTIONS;
        if (isPresentModVlanId && isPresentModEthSrc && isPresentModEthDst && isPresentOutpuPort) {
            type = AbstractCorsaPipeline.CorsaTrafficTreatmentType.GROUP;
        }
        corsaTreatment = new AbstractCorsaPipeline.CorsaTrafficTreatment(type, t);
        return corsaTreatment;
    }

    @Override
    protected TrafficTreatment.Builder processSpecificRoutingTreatment() {
        return DefaultTrafficTreatment.builder().deferred();
    }

    @Override
    protected FlowRule.Builder processSpecificRoutingRule(FlowRule.Builder rb) {
        return rb.forTable(7);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected Collection<FlowRule> processSpecificSwitch(ForwardingObjective fwd) {
        TrafficSelector filteredSelector = DefaultTrafficSelector.builder().matchInPort(((PortCriterion)fwd.selector().getCriterion(Criterion.Type.IN_PORT)).port()).matchVlanId(((VlanIdCriterion)fwd.selector().getCriterion(Criterion.Type.VLAN_VID)).vlanId()).build();
        FlowRule.Builder ruleBuilder = DefaultFlowRule.builder().fromApp(fwd.appId()).withPriority(fwd.priority()).forDevice(this.deviceId).withSelector(filteredSelector).forTable(3);
        if (fwd.treatment() != null) {
            ruleBuilder.withTreatment(fwd.treatment());
        } else {
            if (fwd.nextId() == null) {
                this.log.warn("Missing NextObjective ID for ForwardingObjective {}", (Object)fwd.id());
                this.fail((Objective)fwd, ObjectiveError.BADPARAMS);
                return ImmutableSet.of();
            }
            NextObjective nextObjective = (NextObjective)this.pendingNext.getIfPresent((Object)fwd.nextId());
            if (nextObjective == null) {
                this.log.warn("The group left!");
                fwd.context().ifPresent(c -> c.onError((Objective)fwd, ObjectiveError.GROUPMISSING));
                return ImmutableSet.of();
            }
            this.pendingNext.invalidate((Object)fwd.nextId());
            TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder().setVlanPcp(Byte.valueOf((byte)0)).setQueue(0L).meter(this.defaultMeterId);
            nextObjective.next().forEach(trafficTreatment -> trafficTreatment.allInstructions().forEach(instruction -> treatment.add(instruction)));
            ruleBuilder.withTreatment(treatment.build());
        }
        if (fwd.permanent()) {
            ruleBuilder.makePermanent();
            return Collections.singletonList(ruleBuilder.build());
        }
        ruleBuilder.makeTemporary(fwd.timeout());
        return Collections.singletonList(ruleBuilder.build());
    }

    @Override
    protected Collection<FlowRule> processArpTraffic(ForwardingObjective fwd, FlowRule.Builder rule) {
        return ImmutableSet.of();
    }

    @Override
    protected Collection<FlowRule> processLinkDiscovery(ForwardingObjective fwd, FlowRule.Builder rule) {
        return ImmutableSet.of();
    }

    @Override
    protected Collection<FlowRule> processIpTraffic(ForwardingObjective fwd, FlowRule.Builder rule) {
        return ImmutableSet.of();
    }

    @Override
    protected FlowRule.Builder processEthFiler(FilteringObjective filt, EthCriterion eth, PortCriterion port) {
        this.log.debug("adding rule for MAC: {}", (Object)eth.mac());
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder();
        selector.matchEthDst(eth.mac());
        selector.matchInPort(port.port());
        treatment.transition(Integer.valueOf(6));
        return DefaultFlowRule.builder().withSelector(selector.build()).withTreatment(treatment.build()).withPriority(255).makePermanent().forTable(5);
    }

    @Override
    protected FlowRule.Builder processVlanFiler(FilteringObjective filt, VlanIdCriterion vlan, PortCriterion port) {
        this.log.debug("adding rule for VLAN: {}", (Object)vlan.vlanId());
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder();
        selector.matchVlanId(vlan.vlanId());
        selector.matchInPort(port.port());
        treatment.setVlanPcp(Byte.valueOf((byte)7));
        treatment.setQueue(0L);
        treatment.meter(MeterId.meterId((long)((Long)this.defaultMeterId.id())));
        treatment.transition(Integer.valueOf(5));
        return DefaultFlowRule.builder().withSelector(selector.build()).withTreatment(treatment.build()).withPriority(255).makePermanent().forTable(3);
    }

    @Override
    protected FlowRule.Builder processIpFilter(FilteringObjective filt, IPCriterion ip, PortCriterion port) {
        this.log.debug("adding rule for IP: {}", (Object)ip.ip());
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder();
        selector.matchEthType(Ethernet.TYPE_IPV4);
        selector.matchIPDst(ip.ip());
        treatment.transition(Integer.valueOf(9));
        return DefaultFlowRule.builder().withSelector(selector.build()).withTreatment(treatment.build()).withPriority(65535).makePermanent().forTable(7);
    }

    @Override
    public void initializePipeline() {
        this.processMeterTable(true);
        this.processPortBasedProtoTable(true);
        this.processVlanCheckTable(true);
        this.processVlanMacXlateTable(true);
        this.processVlanCircuitTable(true);
        this.processPriorityMapTable(true);
        this.processL3IFMacDATable(true);
        this.processEtherTable(true);
        this.processFibTable(true);
        this.processLocalTable(true);
    }

    protected void processMeterTable(boolean install) {
        Band dropBand = DefaultBand.builder().ofType(Band.Type.DROP).withRate(-1L).build();
        MeterRequest.Builder ops = DefaultMeterRequest.builder().forDevice(this.deviceId).withBands(Collections.singletonList(dropBand)).fromApp(this.appId);
        Meter meter = this.meterService.submit(install ? ops.add() : ops.remove());
        this.defaultMeterId = meter.id();
    }

    protected void processPortBasedProtoTable(boolean install) {
        this.processTableMissGoTo(install, 0, 1, "Provisioned port-based table");
    }

    protected void processVlanCheckTable(boolean install) {
        this.processTableMissDrop(install, 1, "Provisioned vlantable drop");
        this.processTaggedPackets(install);
    }

    protected void processTaggedPackets(boolean install) {
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        selector.matchVlanId(VlanId.ANY);
        TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder();
        treatment.transition(Integer.valueOf(2));
        FlowRule rule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector.build()).withTreatment(treatment.build()).withPriority(255).fromApp(this.appId).makePermanent().forTable(1).build();
        this.processFlowRule(install, rule, "Provisioned vlan table tagged packets");
    }

    protected void processVlanMacXlateTable(boolean install) {
        this.processTableMissGoTo(install, 2, 3, "Provisioned vlan mac table");
    }

    protected void processVlanCircuitTable(boolean install) {
        this.processTableMissDrop(install, 3, "Provisioned vlan circuit");
    }

    private void processPriorityMapTable(boolean install) {
    }

    protected void processL3IFMacDATable(boolean install) {
        int table = 5;
        this.processTableMissDrop(install, table, "Provisioned l3 table drop");
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        selector.matchEthDst(MacAddress.BROADCAST);
        TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder();
        treatment.transition(Integer.valueOf(6));
        FlowRule rule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector.build()).withTreatment(treatment.build()).withPriority(255).fromApp(this.appId).makePermanent().forTable(table).build();
        this.processFlowRule(install, rule, "Provisioned l3 table");
    }

    protected void processEtherTable(boolean install) {
        int table = 6;
        this.processTableMissDrop(install, table, "Provisioned ether type table drop");
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        selector.matchEthType(Ethernet.TYPE_ARP);
        TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder();
        treatment.punt();
        FlowRule rule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector.build()).withTreatment(treatment.build()).withPriority(255).fromApp(this.appId).makePermanent().forTable(table).build();
        this.processFlowRule(install, rule, "Provisioned ether type table arp");
        selector = DefaultTrafficSelector.builder();
        selector.matchEthType(Ethernet.TYPE_IPV4);
        treatment = DefaultTrafficTreatment.builder();
        treatment.transition(Integer.valueOf(7));
        rule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector.build()).withTreatment(treatment.build()).withPriority(255).fromApp(this.appId).makePermanent().forTable(table).build();
        this.processFlowRule(install, rule, "Provisioned ether type table ip");
    }

    protected void processFibTable(boolean install) {
        this.processTableMissDrop(install, 7, "Provisioned fib drop");
    }

    private void processLocalTable(boolean install) {
        int table = 9;
        this.processTableMissDrop(install, table, "Provisioned local table drop");
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder();
        treatment.punt();
        FlowRule rule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector.build()).withTreatment(treatment.build()).withPriority(255).fromApp(this.appId).makePermanent().forTable(table).build();
        this.processFlowRule(install, rule, "Provisioned ether type table to controller");
    }

    private static /* synthetic */ void lambda$processNextTreatment$1(TrafficTreatment.Builder tb, Instruction i) {
        tb.add(i);
    }

    private static /* synthetic */ boolean lambda$processNextTreatment$0(Instruction i) {
        switch (i.type()) {
            case L2MODIFICATION: {
                L2ModificationInstruction l2i = (L2ModificationInstruction)i;
                if (l2i instanceof L2ModificationInstruction.ModVlanIdInstruction || l2i instanceof L2ModificationInstruction.ModEtherInstruction) {
                    return true;
                }
            }
            case OUTPUT: {
                return true;
            }
        }
        return false;
    }
}

