/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.corsa;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalCause;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.onlab.osgi.ServiceDirectory;
import org.onlab.packet.Ethernet;
import org.onlab.util.KryoNamespace;
import org.onlab.util.Tools;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.event.EventListener;
import org.onosproject.net.DeviceId;
import org.onosproject.net.behaviour.NextGroup;
import org.onosproject.net.behaviour.Pipeliner;
import org.onosproject.net.behaviour.PipelinerContext;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.driver.AbstractHandlerBehaviour;
import org.onosproject.net.flow.DefaultFlowRule;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.FlowRuleOperations;
import org.onosproject.net.flow.FlowRuleOperationsContext;
import org.onosproject.net.flow.FlowRuleService;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.criteria.Criteria;
import org.onosproject.net.flow.criteria.Criterion;
import org.onosproject.net.flow.criteria.EthCriterion;
import org.onosproject.net.flow.criteria.EthTypeCriterion;
import org.onosproject.net.flow.criteria.IPCriterion;
import org.onosproject.net.flow.criteria.PortCriterion;
import org.onosproject.net.flow.criteria.VlanIdCriterion;
import org.onosproject.net.flowobjective.DefaultForwardingObjective;
import org.onosproject.net.flowobjective.FilteringObjective;
import org.onosproject.net.flowobjective.FlowObjectiveStore;
import org.onosproject.net.flowobjective.ForwardingObjective;
import org.onosproject.net.flowobjective.NextObjective;
import org.onosproject.net.flowobjective.Objective;
import org.onosproject.net.flowobjective.ObjectiveContext;
import org.onosproject.net.flowobjective.ObjectiveError;
import org.onosproject.net.group.DefaultGroupBucket;
import org.onosproject.net.group.DefaultGroupDescription;
import org.onosproject.net.group.DefaultGroupKey;
import org.onosproject.net.group.Group;
import org.onosproject.net.group.GroupBucket;
import org.onosproject.net.group.GroupBuckets;
import org.onosproject.net.group.GroupDescription;
import org.onosproject.net.group.GroupEvent;
import org.onosproject.net.group.GroupKey;
import org.onosproject.net.group.GroupListener;
import org.onosproject.net.group.GroupService;
import org.onosproject.net.meter.MeterService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCorsaPipeline
extends AbstractHandlerBehaviour
implements Pipeliner {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private ServiceDirectory serviceDirectory;
    protected FlowRuleService flowRuleService;
    private CoreService coreService;
    protected GroupService groupService;
    protected MeterService meterService;
    protected FlowObjectiveStore flowObjectiveStore;
    protected DeviceId deviceId;
    protected ApplicationId appId;
    protected DeviceService deviceService;
    protected KryoNamespace appKryo = new KryoNamespace.Builder().register(new Class[]{GroupKey.class}).register(new Class[]{DefaultGroupKey.class}).register(new Class[]{CorsaGroup.class}).register(new Class[]{byte[].class}).build("AbstractCorsaPipeline");
    private Cache<GroupKey, NextObjective> pendingGroups;
    protected Cache<Integer, NextObjective> pendingNext;
    private ScheduledExecutorService groupChecker = Executors.newScheduledThreadPool(2, Tools.groupedThreads((String)"onos/pipeliner", (String)"ovs-corsa-%d", (Logger)this.log));
    protected static final int CONTROLLER_PRIORITY = 255;
    protected static final int DROP_PRIORITY = 0;
    protected static final int HIGHEST_PRIORITY = 65535;
    protected static final String APPID = "org.onosproject.drivers.corsa.CorsaPipeline";

    public void init(DeviceId deviceId, PipelinerContext context) {
        this.serviceDirectory = context.directory();
        this.deviceId = deviceId;
        this.pendingGroups = CacheBuilder.newBuilder().expireAfterWrite(20L, TimeUnit.SECONDS).removalListener(notification -> {
            if (notification.getCause() == RemovalCause.EXPIRED) {
                this.fail((Objective)notification.getValue(), ObjectiveError.GROUPINSTALLATIONFAILED);
            }
        }).build();
        this.pendingNext = CacheBuilder.newBuilder().expireAfterWrite(20L, TimeUnit.SECONDS).removalListener(notification -> {
            if (notification.getCause() == RemovalCause.EXPIRED) {
                ((NextObjective)notification.getValue()).context().ifPresent(c -> c.onError((Objective)notification.getValue(), ObjectiveError.FLOWINSTALLATIONFAILED));
            }
        }).build();
        this.groupChecker.scheduleAtFixedRate(new GroupChecker(), 0L, 500L, TimeUnit.MILLISECONDS);
        this.coreService = (CoreService)this.serviceDirectory.get(CoreService.class);
        this.flowRuleService = (FlowRuleService)this.serviceDirectory.get(FlowRuleService.class);
        this.groupService = (GroupService)this.serviceDirectory.get(GroupService.class);
        this.meterService = (MeterService)this.serviceDirectory.get(MeterService.class);
        this.deviceService = (DeviceService)this.serviceDirectory.get(DeviceService.class);
        this.flowObjectiveStore = context.store();
        this.groupService.addListener((EventListener)new InnerGroupListener());
        this.appId = this.coreService.registerApplication(APPID);
        this.initializePipeline();
    }

    protected abstract void initializePipeline();

    protected void pass(Objective obj) {
        obj.context().ifPresent(context -> context.onSuccess(obj));
    }

    protected void fail(Objective obj, ObjectiveError error) {
        obj.context().ifPresent(context -> context.onError(obj, error));
    }

    public List<String> getNextMappings(NextGroup nextGroup) {
        return Collections.emptyList();
    }

    public void filter(FilteringObjective filteringObjective) {
        if (filteringObjective.type() == FilteringObjective.Type.PERMIT) {
            this.processFilter(filteringObjective, filteringObjective.op() == Objective.Operation.ADD, filteringObjective.appId());
        } else {
            this.fail((Objective)filteringObjective, ObjectiveError.UNSUPPORTED);
        }
    }

    private void processFilter(final FilteringObjective filt, boolean install, ApplicationId applicationId) {
        if (filt.key().equals(Criteria.dummy()) || filt.key().type() != Criterion.Type.IN_PORT) {
            this.log.warn("No key defined in filtering objective from app: {}. Notprocessing filtering objective", (Object)applicationId);
            this.fail((Objective)filt, ObjectiveError.UNKNOWN);
            return;
        }
        PortCriterion port = (PortCriterion)filt.key();
        FlowRuleOperations.Builder ops = FlowRuleOperations.builder();
        for (Criterion c : filt.conditions()) {
            FlowRule.Builder rule;
            if (c.type() == Criterion.Type.ETH_DST) {
                EthCriterion eth = (EthCriterion)c;
                rule = this.processEthFiler(filt, eth, port);
                rule.forDevice(this.deviceId).fromApp(applicationId);
                ops = install ? ops.add(rule.build()) : ops.remove(rule.build());
                continue;
            }
            if (c.type() == Criterion.Type.VLAN_VID) {
                VlanIdCriterion vlan = (VlanIdCriterion)c;
                rule = this.processVlanFiler(filt, vlan, port);
                rule.forDevice(this.deviceId).fromApp(applicationId);
                ops = install ? ops.add(rule.build()) : ops.remove(rule.build());
                continue;
            }
            if (c.type() == Criterion.Type.IPV4_DST) {
                IPCriterion ip = (IPCriterion)c;
                rule = this.processIpFilter(filt, ip, port);
                rule.forDevice(this.deviceId).fromApp(applicationId);
                ops = install ? ops.add(rule.build()) : ops.remove(rule.build());
                continue;
            }
            this.log.warn("Driver does not currently process filtering condition of type: {}", (Object)c.type());
            this.fail((Objective)filt, ObjectiveError.UNSUPPORTED);
        }
        this.flowRuleService.apply(ops.build(new FlowRuleOperationsContext(){

            public void onSuccess(FlowRuleOperations ops) {
                AbstractCorsaPipeline.this.pass((Objective)filt);
                AbstractCorsaPipeline.this.log.info("Applied filtering rules");
            }

            public void onError(FlowRuleOperations ops) {
                AbstractCorsaPipeline.this.fail((Objective)filt, ObjectiveError.FLOWINSTALLATIONFAILED);
                AbstractCorsaPipeline.this.log.info("Failed to apply filtering rules");
            }
        }));
    }

    protected abstract FlowRule.Builder processEthFiler(FilteringObjective var1, EthCriterion var2, PortCriterion var3);

    protected abstract FlowRule.Builder processVlanFiler(FilteringObjective var1, VlanIdCriterion var2, PortCriterion var3);

    protected abstract FlowRule.Builder processIpFilter(FilteringObjective var1, IPCriterion var2, PortCriterion var3);

    public void forward(final ForwardingObjective fwd) {
        FlowRuleOperations.Builder flowBuilder = FlowRuleOperations.builder();
        Collection<FlowRule> rules = this.processForward(fwd);
        switch (fwd.op()) {
            case ADD: {
                rules.stream().filter(Objects::nonNull).forEach(arg_0 -> ((FlowRuleOperations.Builder)flowBuilder).add(arg_0));
                break;
            }
            case REMOVE: {
                rules.stream().filter(Objects::nonNull).forEach(arg_0 -> ((FlowRuleOperations.Builder)flowBuilder).remove(arg_0));
                break;
            }
            default: {
                this.fail((Objective)fwd, ObjectiveError.UNKNOWN);
                this.log.warn("Unknown forwarding type {}", (Object)fwd.op());
            }
        }
        this.flowRuleService.apply(flowBuilder.build(new FlowRuleOperationsContext(){

            public void onSuccess(FlowRuleOperations ops) {
                AbstractCorsaPipeline.this.pass((Objective)fwd);
            }

            public void onError(FlowRuleOperations ops) {
                AbstractCorsaPipeline.this.fail((Objective)fwd, ObjectiveError.FLOWINSTALLATIONFAILED);
            }
        }));
    }

    private Collection<FlowRule> processForward(ForwardingObjective fwd) {
        switch (fwd.flag()) {
            case SPECIFIC: {
                return this.processSpecific(fwd);
            }
            case VERSATILE: {
                fwd = this.preProcessVersatile(fwd);
                return this.processVersatile(fwd);
            }
        }
        this.fail((Objective)fwd, ObjectiveError.UNKNOWN);
        this.log.warn("Unknown forwarding flag {}", (Object)fwd.flag());
        return ImmutableSet.of();
    }

    private Collection<FlowRule> processSpecific(ForwardingObjective fwd) {
        this.log.debug("Processing specific forwarding objective");
        TrafficSelector selector = fwd.selector();
        EthTypeCriterion ethTypeCriterion = (EthTypeCriterion)selector.getCriterion(Criterion.Type.ETH_TYPE);
        VlanIdCriterion vlanIdCriterion = (VlanIdCriterion)selector.getCriterion(Criterion.Type.VLAN_VID);
        if (ethTypeCriterion != null) {
            short et = ethTypeCriterion.ethType().toShort();
            if (et == Ethernet.TYPE_IPV4) {
                return this.processSpecificRoute(fwd);
            }
            if (et == Ethernet.TYPE_VLAN) {
                return this.processSpecificSwitch(fwd);
            }
        } else if (vlanIdCriterion != null) {
            return this.processSpecificSwitch(fwd);
        }
        this.fail((Objective)fwd, ObjectiveError.UNSUPPORTED);
        return ImmutableSet.of();
    }

    protected Collection<FlowRule> processSpecificSwitch(ForwardingObjective fwd) {
        this.log.warn("Vlan switching not supported in ovs-corsa driver");
        this.fail((Objective)fwd, ObjectiveError.UNSUPPORTED);
        return ImmutableSet.of();
    }

    private ForwardingObjective preProcessVersatile(ForwardingObjective fwd) {
        if (fwd.treatment().clearedDeferred()) {
            TrafficTreatment.Builder noClearTreatment = DefaultTrafficTreatment.builder();
            fwd.treatment().allInstructions().forEach(arg_0 -> ((TrafficTreatment.Builder)noClearTreatment).add(arg_0));
            DefaultForwardingObjective.Builder noClearFwd = DefaultForwardingObjective.builder((ForwardingObjective)fwd);
            noClearFwd.withTreatment(noClearTreatment.build());
            switch (fwd.op()) {
                case ADD: {
                    fwd = noClearFwd.add((ObjectiveContext)fwd.context().orElse(null));
                    break;
                }
                case REMOVE: {
                    fwd = noClearFwd.remove((ObjectiveContext)fwd.context().orElse(null));
                    break;
                }
                default: {
                    this.log.warn("Unknown operation {}", (Object)fwd.op());
                }
            }
        }
        return fwd;
    }

    private Collection<FlowRule> processVersatile(ForwardingObjective fwd) {
        this.log.debug("Processing vesatile forwarding objective");
        TrafficSelector selector = fwd.selector();
        EthTypeCriterion ethType = (EthTypeCriterion)selector.getCriterion(Criterion.Type.ETH_TYPE);
        if (ethType == null) {
            this.log.error("Versatile forwarding objective must include ethType");
            this.fail((Objective)fwd, ObjectiveError.UNKNOWN);
            return ImmutableSet.of();
        }
        FlowRule.Builder rule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(fwd.selector()).withTreatment(fwd.treatment()).withPriority(fwd.priority()).fromApp(fwd.appId()).makePermanent();
        if (ethType.ethType().toShort() == Ethernet.TYPE_ARP) {
            return this.processArpTraffic(fwd, rule);
        }
        if (ethType.ethType().toShort() == Ethernet.TYPE_LLDP || ethType.ethType().toShort() == Ethernet.TYPE_BSN) {
            return this.processLinkDiscovery(fwd, rule);
        }
        if (ethType.ethType().toShort() == Ethernet.TYPE_IPV4) {
            return this.processIpTraffic(fwd, rule);
        }
        this.log.warn("Driver does not support given versatile forwarding objective");
        this.fail((Objective)fwd, ObjectiveError.UNSUPPORTED);
        return ImmutableSet.of();
    }

    protected abstract Collection<FlowRule> processArpTraffic(ForwardingObjective var1, FlowRule.Builder var2);

    protected abstract Collection<FlowRule> processLinkDiscovery(ForwardingObjective var1, FlowRule.Builder var2);

    protected abstract Collection<FlowRule> processIpTraffic(ForwardingObjective var1, FlowRule.Builder var2);

    private Collection<FlowRule> processSpecificRoute(ForwardingObjective fwd) {
        Group group;
        TrafficSelector filteredSelector = DefaultTrafficSelector.builder().matchEthType(Ethernet.TYPE_IPV4).matchIPDst(((IPCriterion)fwd.selector().getCriterion(Criterion.Type.IPV4_DST)).ip()).build();
        TrafficTreatment.Builder tb = this.processSpecificRoutingTreatment();
        if (fwd.nextId() != null) {
            NextGroup next = this.flowObjectiveStore.getNextGroup(fwd.nextId());
            GroupKey key = (GroupKey)this.appKryo.deserialize(next.data());
            group = this.groupService.getGroup(this.deviceId, key);
            if (group == null) {
                this.log.warn("The group left!");
                this.fail((Objective)fwd, ObjectiveError.GROUPMISSING);
                return ImmutableSet.of();
            }
        } else {
            this.log.error("Missing NextObjective ID for ForwardingObjective {}", (Object)fwd.id());
            this.fail((Objective)fwd, ObjectiveError.BADPARAMS);
            return ImmutableSet.of();
        }
        tb.group(group.id());
        FlowRule.Builder ruleBuilder = DefaultFlowRule.builder().fromApp(fwd.appId()).withPriority(fwd.priority()).forDevice(this.deviceId).withSelector(filteredSelector).withTreatment(tb.build());
        ruleBuilder = this.processSpecificRoutingRule(ruleBuilder);
        if (fwd.permanent()) {
            ruleBuilder.makePermanent();
        } else {
            ruleBuilder.makeTemporary(fwd.timeout());
        }
        return Collections.singletonList(ruleBuilder.build());
    }

    protected TrafficTreatment.Builder processSpecificRoutingTreatment() {
        return DefaultTrafficTreatment.builder();
    }

    protected abstract FlowRule.Builder processSpecificRoutingRule(FlowRule.Builder var1);

    public void next(NextObjective nextObjective) {
        switch (nextObjective.type()) {
            case SIMPLE: {
                Collection treatments = nextObjective.next();
                if (treatments.size() != 1) break;
                TrafficTreatment treatment = (TrafficTreatment)treatments.iterator().next();
                CorsaTrafficTreatment corsaTreatment = this.processNextTreatment(treatment);
                DefaultGroupKey key = new DefaultGroupKey(this.appKryo.serialize((Object)nextObjective.id()));
                if (corsaTreatment.type() == CorsaTrafficTreatmentType.GROUP) {
                    GroupBucket bucket = DefaultGroupBucket.createIndirectGroupBucket((TrafficTreatment)corsaTreatment.treatment());
                    GroupBuckets buckets = new GroupBuckets(Collections.singletonList(bucket));
                    DefaultGroupDescription groupDescription = new DefaultGroupDescription(this.deviceId, GroupDescription.Type.INDIRECT, buckets, (GroupKey)key, null, nextObjective.appId());
                    this.groupService.addGroup((GroupDescription)groupDescription);
                    this.pendingGroups.put((Object)key, (Object)nextObjective);
                    break;
                }
                if (corsaTreatment.type() != CorsaTrafficTreatmentType.ACTIONS) break;
                this.pendingNext.put((Object)nextObjective.id(), (Object)nextObjective);
                this.flowObjectiveStore.putNextGroup(Integer.valueOf(nextObjective.id()), (NextGroup)new CorsaGroup((GroupKey)key));
                nextObjective.context().ifPresent(context -> context.onSuccess((Objective)nextObjective));
                break;
            }
            case HASHED: 
            case BROADCAST: 
            case FAILOVER: {
                this.fail((Objective)nextObjective, ObjectiveError.UNSUPPORTED);
                this.log.warn("Unsupported next objective type {}", (Object)nextObjective.type());
                break;
            }
            default: {
                this.fail((Objective)nextObjective, ObjectiveError.UNKNOWN);
                this.log.warn("Unknown next objective type {}", (Object)nextObjective.type());
            }
        }
    }

    protected CorsaTrafficTreatment processNextTreatment(TrafficTreatment treatment) {
        return new CorsaTrafficTreatment(CorsaTrafficTreatmentType.GROUP, treatment);
    }

    protected void processTableMissDrop(boolean install, int table, String description) {
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder();
        treatment.drop();
        FlowRule rule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector.build()).withTreatment(treatment.build()).withPriority(0).fromApp(this.appId).makePermanent().forTable(table).build();
        this.processFlowRule(install, rule, description);
    }

    protected void processTableMissGoTo(boolean install, int table, int goTo, String description) {
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder();
        treatment.transition(Integer.valueOf(goTo));
        FlowRule rule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector.build()).withTreatment(treatment.build()).withPriority(0).fromApp(this.appId).makePermanent().forTable(table).build();
        this.processFlowRule(install, rule, description);
    }

    protected void processFlowRule(boolean install, final FlowRule rule, final String description) {
        FlowRuleOperations.Builder ops = FlowRuleOperations.builder();
        ops = install ? ops.add(rule) : ops.remove(rule);
        this.flowRuleService.apply(ops.build(new FlowRuleOperationsContext(){

            public void onSuccess(FlowRuleOperations ops) {
                AbstractCorsaPipeline.this.log.info(description + " success: " + ops.toString() + ", " + rule.toString());
            }

            public void onError(FlowRuleOperations ops) {
                AbstractCorsaPipeline.this.log.info(description + " error: " + ops.toString() + ", " + rule.toString());
            }
        }));
    }

    protected class CorsaTrafficTreatment {
        private CorsaTrafficTreatmentType type;
        private TrafficTreatment trafficTreatment;

        public CorsaTrafficTreatment(CorsaTrafficTreatmentType treatmentType, TrafficTreatment trafficTreatment) {
            this.type = treatmentType;
            this.trafficTreatment = trafficTreatment;
        }

        public CorsaTrafficTreatmentType type() {
            return this.type;
        }

        public TrafficTreatment treatment() {
            return this.trafficTreatment;
        }
    }

    protected static enum CorsaTrafficTreatmentType {
        GROUP,
        ACTIONS;

    }

    private class InnerGroupListener
    implements GroupListener {
        private InnerGroupListener() {
        }

        public void event(GroupEvent event) {
            if (event.type() == GroupEvent.Type.GROUP_ADDED) {
                GroupKey key = ((Group)event.subject()).appCookie();
                NextObjective obj = (NextObjective)AbstractCorsaPipeline.this.pendingGroups.getIfPresent((Object)key);
                if (obj != null) {
                    AbstractCorsaPipeline.this.flowObjectiveStore.putNextGroup(Integer.valueOf(obj.id()), (NextGroup)new CorsaGroup(key));
                    AbstractCorsaPipeline.this.pass((Objective)obj);
                    AbstractCorsaPipeline.this.pendingGroups.invalidate((Object)key);
                }
            }
        }
    }

    private class CorsaGroup
    implements NextGroup {
        private final GroupKey key;

        public CorsaGroup(GroupKey key) {
            this.key = key;
        }

        public GroupKey key() {
            return this.key;
        }

        public byte[] data() {
            return AbstractCorsaPipeline.this.appKryo.serialize((Object)this.key);
        }
    }

    private class GroupChecker
    implements Runnable {
        private GroupChecker() {
        }

        @Override
        public void run() {
            Set<GroupKey> keys = AbstractCorsaPipeline.this.pendingGroups.asMap().keySet().stream().filter(key -> AbstractCorsaPipeline.this.groupService.getGroup(AbstractCorsaPipeline.this.deviceId, key) != null).collect(Collectors.toSet());
            keys.forEach(key -> {
                NextObjective obj = (NextObjective)AbstractCorsaPipeline.this.pendingGroups.getIfPresent(key);
                if (obj == null) {
                    return;
                }
                AbstractCorsaPipeline.this.pass((Objective)obj);
                AbstractCorsaPipeline.this.pendingGroups.invalidate(key);
                AbstractCorsaPipeline.this.log.info("Heard back from group service for group {}. Applying pending forwarding objectives", (Object)obj.id());
                AbstractCorsaPipeline.this.flowObjectiveStore.putNextGroup(Integer.valueOf(obj.id()), (NextGroup)new CorsaGroup((GroupKey)key));
            });
        }
    }
}

